/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.data;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import net.valhelsia.valhelsia_core.registry.RegistryManager;

public abstract class ValhelsiaBlockStateProvider
extends BlockStateProvider {
    private final RegistryManager registryManager;

    public ValhelsiaBlockStateProvider(DataGenerator gen, RegistryManager registryManager, ExistingFileHelper exFileHelper) {
        super(gen, registryManager.getModId(), exFileHelper);
        this.registryManager = registryManager;
    }

    protected abstract void register(Set<RegistryObject<Block>> var1);

    protected void registerStatesAndModels() {
        this.register(new HashSet<RegistryObject<Block>>(this.registryManager.getBlockHelper().getDeferredRegister().getEntries()));
    }

    public <T extends Block> void forEach(Set<RegistryObject<T>> blocks, Predicate<T> predicate, Consumer<T> consumer) {
        Iterator<RegistryObject<T>> iterator = blocks.iterator();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next().get();
            if (!predicate.test(block)) continue;
            consumer.accept(block);
            iterator.remove();
        }
    }

    public <T extends Block> void forEach(Set<RegistryObject<T>> blocks, Consumer<T> consumer) {
        Iterator<RegistryObject<T>> iterator = blocks.iterator();
        while (iterator.hasNext()) {
            consumer.accept(iterator.next().get());
            iterator.remove();
        }
    }

    @SafeVarargs
    public final <T extends Block> void take(Set<RegistryObject<T>> set, Consumer<T> consumer, RegistryObject<? extends Block> ... blocks) {
        for (RegistryObject<? extends Block> block : blocks) {
            consumer.accept((Block)block.get());
            set.remove(block);
        }
    }

    public ModelFile.ExistingModelFile getExistingModel(ResourceLocation resourceLocation) {
        return this.models().getExistingFile(resourceLocation);
    }

    public void withExistingModel(Block block) {
        this.withExistingModel(block, false);
    }

    public void withExistingModel(Block block, boolean mcLoc) {
        String name = Objects.requireNonNull(block.getRegistryName()).func_110623_a();
        this.simpleBlock(block, (ModelFile)this.getExistingModel(mcLoc ? this.mcLoc("block/" + name) : this.modLoc("block/" + name)));
    }

    public void buttonBlock(AbstractButtonBlock block, ResourceLocation texture) {
        String name = Objects.requireNonNull(block.getRegistryName()).func_110623_a();
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/button"))).texture("texture", texture);
        ModelBuilder modelPressed = ((BlockModelBuilder)this.models().withExistingParent(name + "_pressed", this.mcLoc("block/button_pressed"))).texture("texture", texture);
        ((BlockModelBuilder)this.models().withExistingParent(name + "_inventory", this.mcLoc("block/button_inventory"))).texture("texture", texture);
        this.getVariantBuilder((Block)block).forAllStates(arg_0 -> ValhelsiaBlockStateProvider.lambda$buttonBlock$0((ModelFile)model, (ModelFile)modelPressed, arg_0));
    }

    public void fenceBlock(FenceBlock block, ResourceLocation texture) {
        super.fenceBlock(block, texture);
        String name = Objects.requireNonNull(block.getRegistryName()).func_110623_a();
        this.models().fenceInventory(name + "_inventory", texture);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$buttonBlock$0(ModelFile model, ModelFile modelPressed, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        AttachFace face = (AttachFace)state.func_177229_b((Property)BlockStateProperties.field_208158_K);
        int rotationX = face == AttachFace.CEILING ? 180 : (face == AttachFace.WALL ? 90 : 0);
        int rotationY = (int)facing.func_176746_e().func_185119_l() + 90;
        return ConfiguredModel.builder().modelFile((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) == false ? model : modelPressed).rotationX(rotationX).rotationY(face == AttachFace.CEILING ? rotationY - 180 : rotationY).uvLock(face == AttachFace.WALL).build();
    }
}

