/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.data;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.valhelsia.valhelsia_core.registry.RegistryManager;

public abstract class ValhelsiaItemModelProvider
extends ItemModelProvider {
    private final RegistryManager registryManager;

    public ValhelsiaItemModelProvider(DataGenerator generator, RegistryManager registryManager, ExistingFileHelper existingFileHelper) {
        super(generator, registryManager.getModId(), existingFileHelper);
        this.registryManager = registryManager;
    }

    protected abstract void register(Set<RegistryObject<Item>> var1, Set<RegistryObject<Item>> var2);

    protected void registerModels() {
        Collection entries = this.registryManager.getItemHelper().getDeferredRegister().getEntries();
        this.register(entries.stream().filter(itemRegistryObject -> !(itemRegistryObject.get() instanceof BlockItem)).collect(Collectors.toSet()), entries.stream().filter(itemRegistryObject -> itemRegistryObject.get() instanceof BlockItem).collect(Collectors.toSet()));
    }

    public <T extends Item> void forEach(Set<RegistryObject<T>> items, Predicate<T> predicate, Consumer<T> consumer) {
        Iterator<RegistryObject<T>> iterator = items.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next().get();
            if (!predicate.test(item)) continue;
            consumer.accept(item);
            iterator.remove();
        }
    }

    public <T extends Item> void forEach(Set<RegistryObject<T>> items, Consumer<T> consumer) {
        Iterator<RegistryObject<T>> iterator = items.iterator();
        while (iterator.hasNext()) {
            consumer.accept(iterator.next().get());
            iterator.remove();
        }
    }

    @SafeVarargs
    public final <T extends Item> void take(Set<RegistryObject<T>> set, Consumer<Item> consumer, RegistryObject<? extends Item> ... items) {
        for (RegistryObject<? extends Item> item : items) {
            consumer.accept((Item)item.get());
            set.remove(item);
        }
    }

    @SafeVarargs
    public final <T extends Item> void takeBlockItem(Set<RegistryObject<T>> set, Consumer<Item> consumer, RegistryObject<? extends Block> ... blocks) {
        for (RegistryObject<? extends Block> block : blocks) {
            consumer.accept(((Block)block.get()).func_199767_j());
            set.remove(RegistryObject.of((ResourceLocation)((Block)block.get()).getRegistryName(), (IForgeRegistry)ForgeRegistries.ITEMS));
        }
    }

    public <T extends Item> void simpleModel(T item) {
        String name = Objects.requireNonNull(item.getRegistryName()).func_110623_a();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", "item/" + name);
    }

    public <T extends Item> void simpleModelBlockTexture(T item) {
        String name = Objects.requireNonNull(item.getRegistryName()).func_110623_a();
        this.simpleModelBlockTexture(item, name);
    }

    public <T extends Item> void simpleModelBlockTexture(T item, String texture) {
        String name = Objects.requireNonNull(item.getRegistryName()).func_110623_a();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", "block/" + texture);
    }

    public <T extends Item> void withParent(T item) {
        this.withParent(item, false);
    }

    public <T extends Item> void withParent(T item, boolean mcLoc) {
        String name = Objects.requireNonNull(item.getRegistryName()).func_110623_a();
        this.withParent(item, name, mcLoc);
    }

    public <T extends Item> void withParent(T item, String loc) {
        this.withParent(item, loc, false);
    }

    public <T extends Item> void withParent(T item, String loc, boolean mcLoc) {
        String name = Objects.requireNonNull(item.getRegistryName()).func_110623_a();
        this.withExistingParent(name, mcLoc ? this.mcLoc("block/" + loc) : this.modLoc("block/" + loc));
    }

    public <T extends Item> void withParentInventory(T item) {
        String name = Objects.requireNonNull(item.getRegistryName()).func_110623_a();
        this.withExistingParent(name, this.modLoc("block/" + name + "_inventory"));
    }
}

