/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.event;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.ValhelsiaCore;
import net.valhelsia.valhelsia_core.gui.ConfigErrorScreen;
import net.valhelsia.valhelsia_core.registry.RegistryManager;
import net.valhelsia.valhelsia_core.util.AbstractConfigValidator;
import net.valhelsia.valhelsia_core.util.ConfigError;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiListener {
    @SubscribeEvent
    public static void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof MainMenuScreen && !ValhelsiaCore.allConfigsValidated) {
            ArrayList<ConfigError> errors = new ArrayList<ConfigError>();
            for (RegistryManager registryManager : ValhelsiaCore.REGISTRY_MANAGERS) {
                if (registryManager.getConfigValidator() == null) continue;
                AbstractConfigValidator configValidator = registryManager.getConfigValidator();
                configValidator.validate();
                configValidator.getErrors().forEach(configError -> configError.setModID(registryManager.getModId()));
                errors.addAll(configValidator.getErrors());
            }
            if (!errors.isEmpty()) {
                event.setCanceled(true);
                ConfigError error = (ConfigError)errors.get(0);
                errors.remove(error);
                Minecraft.func_71410_x().func_147108_a((Screen)(errors.isEmpty() ? new ConfigErrorScreen(error) : new ConfigErrorScreen(error, errors)));
            }
            ValhelsiaCore.allConfigsValidated = true;
        }
    }
}

