/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.block;

import java.util.Random;
import java.util.function.Function;
import mrp_v2.versatileportals.block.util.PortalSize;
import mrp_v2.versatileportals.particles.PortalParticleData;
import mrp_v2.versatileportals.tileentity.PortalControllerTileEntity;
import mrp_v2.versatileportals.util.Util;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PortalBlock
extends Block {
    public static final String ID = "portal";
    public static final VoxelShape Y_AABB = PortalBlock.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    public static final VoxelShape Z_AABB = PortalBlock.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    public static final VoxelShape X_AABB = PortalBlock.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public PortalBlock() {
        this(properties -> properties);
    }

    protected PortalBlock(Function<AbstractBlock.Properties, AbstractBlock.Properties> propertiesModifier) {
        super(propertiesModifier.apply(AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_200942_a().func_200943_b(-1.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(state -> 11)));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis updateAxis = facing.func_176740_k();
        Direction.Axis thisAxis = (Direction.Axis)stateIn.func_177229_b((Property)BlockStateProperties.field_208148_A);
        boolean isUpdateFromOtherAxis = thisAxis == updateAxis;
        return !isUpdateFromOtherAxis && !facingState.func_203425_a((Block)this) && !new PortalSize((IBlockReader)worldIn, currentPos, thisAxis).isValidAndHasCorrectPortalBlockCount() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A)) {
                    case Z: {
                        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A)) {
            case X: {
                return X_AABB;
            }
            case Y: {
                return Y_AABB;
            }
            case Z: {
                return Z_AABB;
            }
        }
        throw new IllegalStateException();
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU()) {
            Util.getPortalData(entityIn).setPortal(pos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.func_177958_n() + rand.nextDouble();
            double y = (double)pos.func_177956_o() + rand.nextDouble();
            double z = (double)pos.func_177952_p() + rand.nextDouble();
            double xSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double ySpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double zSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            switch ((Direction.Axis)stateIn.func_177229_b((Property)BlockStateProperties.field_208148_A)) {
                case X: {
                    x = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                    xSpeed = rand.nextFloat() * 2.0f * (float)j;
                    break;
                }
                case Y: {
                    y = (double)pos.func_177956_o() + 0.5 + 0.25 * (double)j;
                    ySpeed = rand.nextFloat() * 2.0f * (float)j;
                    break;
                }
                case Z: {
                    z = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                    zSpeed = rand.nextFloat() * 2.0f * (float)j;
                }
            }
            worldIn.func_195594_a((IParticleData)new PortalParticleData(PortalBlock.getColor(stateIn, (IBlockReader)worldIn, pos), stateIn.func_177229_b((Property)BlockStateProperties.field_208148_A) == Direction.Axis.Y), x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public static int getColor(BlockState blockState, IBlockReader world, BlockPos pos) {
        PortalSize size = new PortalSize(world, pos, (Direction.Axis)blockState.func_177229_b((Property)BlockStateProperties.field_208148_A));
        PortalControllerTileEntity portalControllerTE = (PortalControllerTileEntity)((Object)size.getPortalController(world).getLeft());
        if (portalControllerTE != null) {
            return portalControllerTE.getPortalColor();
        }
        return 0xFFFFFF;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208148_A});
    }
}

