/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.block;

import javax.annotation.Nullable;
import mrp_v2.versatileportals.block.IPortalFrame;
import mrp_v2.versatileportals.block.PortalFrameBlock;
import mrp_v2.versatileportals.block.util.PortalFrameUtil;
import mrp_v2.versatileportals.particles.PortalControllerParticleData;
import mrp_v2.versatileportals.tileentity.PortalControllerTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class PortalControllerBlock
extends PortalFrameBlock
implements IPortalFrame {
    public static final String ID = "portal_controller";
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208148_A;
    public static final VoxelShape TOP_SIDE = PortalControllerBlock.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape BOTTOM_SIDE = PortalControllerBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    public static final VoxelShape EAST_SIDE = PortalControllerBlock.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape WEST_SIDE = PortalControllerBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    public static final VoxelShape SOUTH_SIDE = PortalControllerBlock.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape NORTH_SIDE = PortalControllerBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    public static final VoxelShape SHAPE_NS = VoxelShapes.func_216384_a((VoxelShape)TOP_SIDE, (VoxelShape[])new VoxelShape[]{BOTTOM_SIDE, EAST_SIDE, WEST_SIDE}).func_197753_c();
    public static final VoxelShape SHAPE_EW = VoxelShapes.func_216384_a((VoxelShape)TOP_SIDE, (VoxelShape[])new VoxelShape[]{BOTTOM_SIDE, SOUTH_SIDE, NORTH_SIDE}).func_197753_c();
    public static final VoxelShape SHAPE_UD = VoxelShapes.func_216384_a((VoxelShape)EAST_SIDE, (VoxelShape[])new VoxelShape[]{WEST_SIDE, SOUTH_SIDE, NORTH_SIDE});

    public PortalControllerBlock() {
        super(AbstractBlock.Properties::func_226896_b_);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    public static void animateTick(BlockState stateIn, World worldIn, BlockPos pos) {
        PortalControllerParticleData data = new PortalControllerParticleData(PortalFrameUtil.getColor((IBlockReader)worldIn, pos));
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        double motion = 0.375;
        double noMotion = 0.0;
        Direction.Axis axis = (Direction.Axis)stateIn.func_177229_b(AXIS);
        if (axis != Direction.Axis.X) {
            worldIn.func_195594_a((IParticleData)data, x, y, z, motion, noMotion, noMotion);
            worldIn.func_195594_a((IParticleData)data, x, y, z, -motion, noMotion, noMotion);
        }
        if (axis != Direction.Axis.Y) {
            worldIn.func_195594_a((IParticleData)data, x, y, z, noMotion, motion, noMotion);
            worldIn.func_195594_a((IParticleData)data, x, y, z, noMotion, -motion, noMotion);
        }
        if (axis != Direction.Axis.Z) {
            worldIn.func_195594_a((IParticleData)data, x, y, z, noMotion, noMotion, motion);
            worldIn.func_195594_a((IParticleData)data, x, y, z, noMotion, noMotion, -motion);
        }
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasTileEntity() && (state.func_177230_c() != newState.func_177230_c() || !newState.hasTileEntity())) {
            worldIn.func_175625_s(pos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemHandler.getStackInSlot(i));
                }
            });
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public boolean isSideValidForPortal(BlockState state, IBlockReader reader, BlockPos pos, Direction side) {
        return state.func_224755_d(reader, pos, side);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PortalControllerTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        PortalControllerTileEntity portalController = (PortalControllerTileEntity)worldIn.func_175625_s(pos);
        if (portalController != null) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)portalController, buffer -> {
                    buffer.writeInt(portalController.getPortalColor());
                    buffer.func_179255_a(pos);
                });
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    private VoxelShape getShape(BlockState state) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return SHAPE_EW;
            }
            case Y: {
                return SHAPE_UD;
            }
            case Z: {
                return SHAPE_NS;
            }
        }
        throw new IllegalStateException();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(AXIS, (Comparable)context.func_196010_d().func_176740_k());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileEntity;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tileEntity = worldIn.func_175625_s(pos)) instanceof PortalControllerTileEntity) {
            ((PortalControllerTileEntity)tileEntity).setCustomName(stack.func_200301_q());
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS});
    }
}

