/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.block.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mrp_v2.versatileportals.block.util.PortalSize;
import mrp_v2.versatileportals.network.PacketHandler;
import mrp_v2.versatileportals.network.PortalFrameUpdatePacket;
import mrp_v2.versatileportals.tileentity.PortalControllerTileEntity;
import mrp_v2.versatileportals.util.Util;
import mrp_v2.versatileportals.world.WorldWrapper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class PortalFrameUtil {
    public static int getColor(IBlockReader world, BlockPos pos) {
        PortalControllerTileEntity controller = PortalFrameUtil.getPortalController(world, pos);
        if (controller != null) {
            return controller.getPortalColor();
        }
        return 0xFFFFFF;
    }

    @Nullable
    public static PortalControllerTileEntity getPortalController(IBlockReader world, BlockPos pos) {
        PortalControllerTileEntity testController = null;
        for (PortalSize size : PortalFrameUtil.getPortalSizes(pos, world, false)) {
            PortalControllerTileEntity testTileEntity = (PortalControllerTileEntity)((Object)size.getPortalController(world).getLeft());
            if (testTileEntity == null) continue;
            if (testController != null && testController != testTileEntity) {
                return null;
            }
            testController = testTileEntity;
        }
        return testController;
    }

    public static List<PortalSize> getPortalSizes(BlockPos pos, IBlockReader world, boolean includeSelf) {
        ArrayList portals = Lists.newArrayList();
        for (Pair<BlockPos, Direction.Axis> test : PortalFrameUtil.getPossiblePortalLocations(pos)) {
            PortalSize size = new PortalSize(world, (BlockPos)test.getLeft(), (Direction.Axis)test.getRight());
            if (!size.isValid()) continue;
            portals.add(size);
        }
        if (includeSelf) {
            PortalSize size = new PortalSize(world, pos, Direction.Axis.X);
            if (size.isValid()) {
                portals.add(size);
            }
            if ((size = new PortalSize(world, pos, Direction.Axis.Z)).isValid()) {
                portals.add(size);
            }
            if ((size = new PortalSize(world, pos, Direction.Axis.Y)).isValid()) {
                portals.add(size);
            }
        }
        return portals;
    }

    public static Pair<BlockPos, Direction.Axis>[] getPossiblePortalLocations(BlockPos pos) {
        return Util.mergePairArrays(PortalFrameUtil.getNeighbors(pos), PortalFrameUtil.getVerticalDiagonals(pos));
    }

    public static Pair<BlockPos, Direction.Axis>[] getNeighbors(BlockPos pos) {
        ArrayList<Pair> tests = new ArrayList<Pair>();
        for (Direction.Axis axis : Direction.Axis.values()) {
            Pair otherAxes = (Pair)Util.OTHER_AXES_MAP.get((Object)axis);
            tests.add(Pair.of((Object)pos.func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getLeft()), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)), (Object)axis));
            tests.add(Pair.of((Object)pos.func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getLeft()), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)), (Object)axis));
            tests.add(Pair.of((Object)pos.func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getRight()), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)), (Object)axis));
            tests.add(Pair.of((Object)pos.func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getRight()), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)), (Object)axis));
        }
        return tests.toArray(Util.makeArray(new Pair[0]));
    }

    public static Pair<BlockPos, Direction.Axis>[] getVerticalDiagonals(BlockPos pos) {
        ArrayList<Pair> tests = new ArrayList<Pair>();
        for (Direction.Axis axis : Direction.Axis.values()) {
            Pair otherAxes = (Pair)Util.OTHER_AXES_MAP.get((Object)axis);
            tests.add(Pair.of((Object)pos.func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getLeft()), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getRight()), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)), (Object)axis));
            tests.add(Pair.of((Object)pos.func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getLeft()), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getRight()), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)), (Object)axis));
            tests.add(Pair.of((Object)pos.func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getLeft()), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)).func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getRight()), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)), (Object)axis));
            tests.add(Pair.of((Object)pos.func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getLeft()), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)).func_177972_a(Direction.func_211699_a((Direction.Axis)((Direction.Axis)otherAxes.getRight()), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)), (Object)axis));
        }
        return tests.toArray(Util.makeArray(new Pair[0]));
    }

    public static void sendUpdatePacket(BlockState oldState, BlockPos pos, World world) {
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos)), (Object)new PortalFrameUpdatePacket(pos, PortalFrameUtil.getUpdateSizes(oldState, pos, world)));
    }

    public static List<PortalSize> getUpdateSizes(BlockState oldState, BlockPos pos, World world) {
        ArrayList sizes = Lists.newArrayList();
        sizes.addAll(PortalFrameUtil.getPortalSizes(pos, (IBlockReader)world, false));
        sizes.addAll(PortalFrameUtil.getPortalSizes(pos, (IBlockReader)new WorldWrapper(world, pos, oldState), true));
        return sizes;
    }

    public static void updatePortals(List<PortalSize> sizes) {
        for (PortalSize size : sizes) {
            Pair<BlockPos, BlockPos> range = size.getBlockRange();
            int x1 = ((BlockPos)range.getLeft()).func_177958_n();
            int y1 = ((BlockPos)range.getLeft()).func_177956_o();
            int z1 = ((BlockPos)range.getLeft()).func_177952_p();
            int x2 = ((BlockPos)range.getRight()).func_177958_n();
            int y2 = ((BlockPos)range.getRight()).func_177956_o();
            int z2 = ((BlockPos)range.getRight()).func_177952_p();
            if (x1 > x2) {
                int xt = x1;
                x1 = x2;
                x2 = xt;
            }
            if (y1 > y2) {
                int yt = y1;
                y1 = y2;
                y2 = yt;
            }
            if (z1 > z2) {
                int zt = z1;
                z1 = z2;
                z2 = zt;
            }
            Minecraft.func_71410_x().field_71438_f.func_147585_a(x1, y1, z1, x2, y2, z2);
        }
    }
}

