/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.block.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mrp_v2.versatileportals.block.IPortalFrame;
import mrp_v2.versatileportals.block.PortalBlock;
import mrp_v2.versatileportals.block.PortalControllerBlock;
import mrp_v2.versatileportals.tileentity.PortalControllerTileEntity;
import mrp_v2.versatileportals.util.ObjectHolder;
import mrp_v2.versatileportals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.Pair;

public class PortalSize {
    public static final int MAX_SIZE = 21;
    public static final int MIN_SIZE = 1;
    public static final Codec<PortalSize> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Direction.Axis.field_239632_d_.fieldOf("Axis").forGetter(size -> size.axis), (App)BlockPos.field_239578_a_.fieldOf("FarthestDownNorthWestPortalLoc").forGetter(size -> size.farthestDownNorthWestPortalLoc), (App)Codec.INT.fieldOf("SizeA").forGetter(size -> size.sizeA), (App)Codec.INT.fieldOf("SizeB").forGetter(size -> size.sizeB), (App)Codec.INT.fieldOf("PortalBlockCount").forGetter(size -> size.portalBlockCount)).apply((Applicative)builder, PortalSize::new));
    private final Direction.Axis axis;
    private final Direction dirA;
    private final Direction dirB;
    private final Direction oppositeDirA;
    private final Direction oppositeDirB;
    private int sizeA;
    private int sizeB;
    private int portalBlockCount;
    @Nullable
    private BlockPos farthestDownNorthWestPortalLoc;
    @Nullable
    private BlockPos portalControllerRelativePos;

    private PortalSize(Direction.Axis axis, BlockPos farthestDownNorthWestPortalLoc, int sizeA, int sizeB, int portalBlockCount) {
        this.axis = axis;
        Pair otherAxes = (Pair)Util.OTHER_AXES_MAP.get((Object)axis);
        this.dirA = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)otherAxes.getLeft()));
        this.oppositeDirA = this.dirA.func_176734_d();
        this.dirB = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)otherAxes.getRight()));
        this.oppositeDirB = this.dirB.func_176734_d();
        this.farthestDownNorthWestPortalLoc = farthestDownNorthWestPortalLoc;
        this.sizeA = sizeA;
        this.sizeB = sizeB;
        this.portalBlockCount = portalBlockCount;
    }

    public PortalSize(IBlockReader world, BlockPos pos, Direction.Axis axis) {
        this.axis = axis;
        Pair otherAxes = (Pair)Util.OTHER_AXES_MAP.get((Object)axis);
        this.dirA = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)otherAxes.getLeft()));
        this.oppositeDirA = this.dirA.func_176734_d();
        this.dirB = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)otherAxes.getRight()));
        this.oppositeDirB = this.dirB.func_176734_d();
        this.farthestDownNorthWestPortalLoc = this.getFarthestDownNorthWestPortalLoc(pos, world);
        if (this.farthestDownNorthWestPortalLoc == null) {
            this.invalidate();
        } else {
            this.sizeA = this.getSizeA(world);
            if (this.sizeA > 0) {
                this.sizeB = this.getSizeB(world);
            } else {
                this.invalidate();
            }
        }
        if (this.isValid()) {
            Pair<PortalControllerTileEntity, Boolean> portalControllerResult = this.getPortalController(world);
            if (!((Boolean)portalControllerResult.getRight()).booleanValue()) {
                this.invalidate();
            }
            if (portalControllerResult.getLeft() != null) {
                this.portalControllerRelativePos = ((PortalControllerTileEntity)((Object)portalControllerResult.getLeft())).func_174877_v().func_177973_b((Vector3i)this.farthestDownNorthWestPortalLoc);
            }
        }
    }

    public Pair<PortalControllerTileEntity, Boolean> getPortalController(IBlockReader world) {
        PortalControllerTileEntity portalControllerTileEntity = null;
        boolean found = false;
        if (this.isValid()) {
            for (Pair<BlockPos, Optional<Direction>> frame : this.getFrameBlocks()) {
                BlockState state = world.func_180495_p((BlockPos)frame.getLeft());
                if (!PortalSize.isPortalController(state)) continue;
                if (found) {
                    return Pair.of(null, (Object)false);
                }
                TileEntity temp = world.func_175625_s((BlockPos)frame.getLeft());
                portalControllerTileEntity = temp instanceof PortalControllerTileEntity ? (PortalControllerTileEntity)temp : null;
                found = true;
            }
        }
        return Pair.of(portalControllerTileEntity, (Object)found);
    }

    public static boolean isPortalController(BlockState state) {
        return state.func_203425_a((Block)ObjectHolder.PORTAL_CONTROLLER_BLOCK.get());
    }

    public List<Pair<BlockPos, Optional<Direction>>> getFrameBlocks() {
        int i;
        ArrayList frame = Lists.newArrayListWithCapacity((int)(this.sizeA * 2 + this.sizeB * 2 + 4));
        frame.add(Pair.of((Object)this.farthestDownNorthWestPortalLoc.func_177972_a(this.oppositeDirB).func_177972_a(this.oppositeDirA), Optional.empty()));
        frame.add(Pair.of((Object)this.farthestDownNorthWestPortalLoc.func_177972_a(this.oppositeDirB).func_177967_a(this.dirA, this.sizeA), Optional.empty()));
        frame.add(Pair.of((Object)this.farthestDownNorthWestPortalLoc.func_177967_a(this.dirB, this.sizeB).func_177972_a(this.oppositeDirA), Optional.empty()));
        frame.add(Pair.of((Object)this.farthestDownNorthWestPortalLoc.func_177967_a(this.dirB, this.sizeB).func_177967_a(this.dirA, this.sizeA), Optional.empty()));
        for (i = 0; i < this.sizeB; ++i) {
            frame.add(Pair.of((Object)this.farthestDownNorthWestPortalLoc.func_177972_a(this.oppositeDirA).func_177967_a(this.dirB, i), Optional.of(this.dirA)));
            frame.add(Pair.of((Object)this.farthestDownNorthWestPortalLoc.func_177967_a(this.dirA, this.sizeA).func_177967_a(this.dirB, i), Optional.of(this.oppositeDirA)));
        }
        for (i = 0; i < this.sizeA; ++i) {
            frame.add(Pair.of((Object)this.farthestDownNorthWestPortalLoc.func_177972_a(this.oppositeDirB).func_177967_a(this.dirA, i), Optional.of(this.dirB)));
            frame.add(Pair.of((Object)this.farthestDownNorthWestPortalLoc.func_177967_a(this.dirB, this.sizeB).func_177967_a(this.dirA, i), Optional.of(this.oppositeDirB)));
        }
        return frame;
    }

    @Nullable
    private BlockPos getFarthestDownNorthWestPortalLoc(BlockPos pos, IBlockReader world) {
        if (!PortalSize.canConnect(world.func_180495_p(pos))) {
            return null;
        }
        int i = Math.max(this.dirB.func_176740_k() == Direction.Axis.Y ? 0 : Integer.MIN_VALUE, this.getOnAxis(pos, this.dirB.func_176740_k()) - 21);
        while (this.getOnAxis(pos, this.dirB.func_176740_k()) > i && PortalSize.canConnect(world.func_180495_p(pos.func_177972_a(this.oppositeDirB)))) {
            pos = pos.func_177972_a(this.oppositeDirB);
        }
        int j = this.getDistanceFromEdge(pos, this.oppositeDirA, this.dirA, this.oppositeDirB, this.dirB, world) - 1;
        return j < 0 ? null : pos.func_177967_a(this.oppositeDirA, j);
    }

    private static boolean canConnect(BlockState state) {
        return state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_232872_am_) || PortalSize.isPortal(state);
    }

    public static List<PortalSize> readListFromBuffer(PacketBuffer buffer) {
        int length = buffer.readInt();
        ArrayList sizes = Lists.newArrayListWithCapacity((int)length);
        for (int i = 0; i < length; ++i) {
            sizes.add(new PortalSize(buffer));
        }
        return sizes;
    }

    public static void writeListToBuffer(List<PortalSize> sizes, PacketBuffer buffer) {
        buffer.writeInt(sizes.size());
        sizes.forEach(size -> size.writeToBuffer(buffer));
    }

    public static boolean isPortal(BlockState state) {
        return state.func_203425_a((Block)ObjectHolder.PORTAL_BLOCK.get());
    }

    public static Optional<PortalSize> tryGetEmptyPortalSize(IWorld world, BlockPos pos) {
        Optional<PortalSize> optionalSize = PortalSize.tryGetPortalSize(world, pos, PortalSize::isValidAndEmpty, Direction.Axis.X);
        if (optionalSize.isPresent()) {
            return optionalSize;
        }
        optionalSize = PortalSize.tryGetPortalSize(world, pos, PortalSize::isValidAndEmpty, Direction.Axis.Z);
        if (optionalSize.isPresent()) {
            return optionalSize;
        }
        return PortalSize.tryGetPortalSize(world, pos, PortalSize::isValidAndEmpty, Direction.Axis.Y);
    }

    public static Optional<PortalSize> tryGetPortalSize(IWorld world, BlockPos pos, Predicate<PortalSize> test, Direction.Axis axis) {
        return Optional.of(new PortalSize((IBlockReader)world, pos, axis)).filter(test);
    }

    public boolean isValidAndEmpty() {
        return this.isValid() && this.portalBlockCount == 0;
    }

    public boolean isValid() {
        return this.farthestDownNorthWestPortalLoc != null && this.sizeB >= 1 && this.sizeB <= 21 && this.sizeA >= 1 && this.sizeA <= 21;
    }

    public int getSizeOnAxis(Direction.Axis axis) {
        if (this.dirA.func_176740_k() == axis) {
            return this.sizeA;
        }
        if (this.dirB.func_176740_k() == axis) {
            return this.sizeB;
        }
        return 1;
    }

    public int getHorizontalSize() {
        if (this.axis == Direction.Axis.Y) {
            throw new IllegalStateException();
        }
        return this.dirA.func_176740_k() == Direction.Axis.Y ? this.sizeB : this.sizeA;
    }

    public int getVerticalSize() {
        if (this.axis == Direction.Axis.Y) {
            throw new IllegalStateException();
        }
        return this.dirA.func_176740_k() == Direction.Axis.Y ? this.sizeA : this.sizeB;
    }

    public Direction getDirA() {
        return this.dirA;
    }

    public Direction getDirB() {
        return this.dirB;
    }

    public Direction getOppositeDirA() {
        return this.oppositeDirA;
    }

    public Direction getOppositeDirB() {
        return this.oppositeDirB;
    }

    public int getSizeA() {
        return this.sizeA;
    }

    public int getSizeB() {
        return this.sizeB;
    }

    private void invalidate() {
        this.farthestDownNorthWestPortalLoc = null;
        this.sizeA = 0;
        this.sizeB = 0;
    }

    @Nullable
    public BlockPos getPortalControllerRelativePos() {
        return this.portalControllerRelativePos;
    }

    private int getDistanceFromEdge(BlockPos start, Direction movingDir, Direction oppositeMovingDir, Direction testingDir, Direction oppositeTestingDir, IBlockReader world) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int i = 0; i <= 21; ++i) {
            mutable.func_189533_g((Vector3i)start).func_189534_c(movingDir, i);
            BlockState nextBlockState = world.func_180495_p((BlockPos)mutable);
            if (!PortalSize.canConnect(nextBlockState)) {
                if (!PortalSize.isPortalFrame(nextBlockState, world, (BlockPos)mutable, oppositeMovingDir)) break;
                return i;
            }
            BlockState sideState = world.func_180495_p((BlockPos)mutable.func_189536_c(testingDir));
            if (!PortalSize.isPortalFrame(sideState, world, (BlockPos)mutable, oppositeTestingDir)) break;
        }
        return 0;
    }

    public static boolean isPortalFrame(BlockState state, IBlockReader reader, BlockPos pos, Direction side) {
        Block block = state.func_177230_c();
        if (state.func_203425_a((Block)ObjectHolder.PORTAL_CONTROLLER_BLOCK.get())) {
            return ((PortalControllerBlock)block).isSideValidForPortal(state, reader, pos, side);
        }
        if (state.func_203425_a((Block)ObjectHolder.PORTAL_FRAME_BLOCK.get())) {
            return true;
        }
        if (state.func_177230_c() instanceof IPortalFrame) {
            return ((IPortalFrame)state.func_177230_c()).isSideValidForPortal(state, reader, pos, side);
        }
        return false;
    }

    protected PortalSize(PacketBuffer buffer) {
        this.farthestDownNorthWestPortalLoc = buffer.func_179259_c();
        this.sizeA = buffer.readInt();
        this.sizeB = buffer.readInt();
        this.portalBlockCount = buffer.readInt();
        this.axis = (Direction.Axis)buffer.func_179257_a(Direction.Axis.class);
        Pair otherAxes = (Pair)Util.OTHER_AXES_MAP.get((Object)this.axis);
        this.dirA = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)otherAxes.getLeft()));
        this.oppositeDirA = this.dirA.func_176734_d();
        this.dirB = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)otherAxes.getRight()));
        this.oppositeDirB = this.dirB.func_176734_d();
    }

    public boolean isValidAndHasCorrectPortalBlockCount() {
        return this.isValid() && this.portalBlockCount == this.sizeB * this.sizeA;
    }

    private int getSizeB(IBlockReader world) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int i = this.getDistanceFromPositiveBSide(mutable, world);
        return i >= 1 && i <= 21 && this.isPositiveBFrameSideValid(mutable, i, world) ? i : 0;
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.farthestDownNorthWestPortalLoc);
        buffer.writeInt(this.sizeA);
        buffer.writeInt(this.sizeB);
        buffer.writeInt(this.portalBlockCount);
        buffer.func_179249_a((Enum)this.axis);
    }

    public void placePortalBlocks(IWorld world) {
        BlockState state = (BlockState)((PortalBlock)ObjectHolder.PORTAL_BLOCK.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)this.axis);
        BlockPos.func_218278_a((BlockPos)this.farthestDownNorthWestPortalLoc, (BlockPos)this.farthestDownNorthWestPortalLoc.func_177967_a(this.dirA, this.sizeA - 1).func_177967_a(this.dirB, this.sizeB - 1)).forEach(pos -> world.func_180501_a(pos, state, 18));
    }

    private int getDistanceFromPositiveBSide(BlockPos.Mutable pos, IBlockReader world) {
        for (int i = 0; i < 21; ++i) {
            pos.func_189533_g((Vector3i)this.farthestDownNorthWestPortalLoc).func_189534_c(this.dirB, i).func_189536_c(this.oppositeDirA);
            if (!PortalSize.isPortalFrame(world.func_180495_p((BlockPos)pos), world, (BlockPos)pos, this.dirA)) {
                return i;
            }
            pos.func_189533_g((Vector3i)this.farthestDownNorthWestPortalLoc).func_189534_c(this.dirB, i).func_189534_c(this.dirA, this.sizeA);
            if (!PortalSize.isPortalFrame(world.func_180495_p((BlockPos)pos), world, (BlockPos)pos, this.oppositeDirA)) {
                return i;
            }
            for (int j = 0; j < this.sizeA; ++j) {
                pos.func_189533_g((Vector3i)this.farthestDownNorthWestPortalLoc).func_189534_c(this.dirB, i).func_189534_c(this.dirA, j);
                BlockState state = world.func_180495_p((BlockPos)pos);
                if (!PortalSize.canConnect(state)) {
                    return i;
                }
                if (!state.func_203425_a((Block)ObjectHolder.PORTAL_BLOCK.get())) continue;
                ++this.portalBlockCount;
            }
        }
        return 21;
    }

    private int getOnAxis(BlockPos pos, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return pos.func_177958_n();
            }
            case Y: {
                return pos.func_177956_o();
            }
            case Z: {
                return pos.func_177952_p();
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean isPositiveBFrameSideValid(BlockPos.Mutable pos, int distanceFromSide, IBlockReader world) {
        for (int i = 0; i < this.sizeA; ++i) {
            BlockPos.Mutable mutable = pos.func_189533_g((Vector3i)this.farthestDownNorthWestPortalLoc).func_189534_c(this.dirB, distanceFromSide).func_189534_c(this.dirA, i);
            if (PortalSize.isPortalFrame(world.func_180495_p((BlockPos)mutable), world, (BlockPos)mutable, this.oppositeDirB)) continue;
            return false;
        }
        return true;
    }

    private int getSizeA(IBlockReader world) {
        int i = this.getDistanceFromEdge(this.farthestDownNorthWestPortalLoc, this.dirA, this.oppositeDirA, this.oppositeDirB, this.dirB, world);
        return i >= 1 && i <= 21 ? i : 0;
    }

    public Pair<BlockPos, BlockPos> getBlockRange() {
        BlockPos a = this.farthestDownNorthWestPortalLoc.func_177967_a(this.dirB, -1).func_177967_a(this.dirA, -1);
        BlockPos b = this.farthestDownNorthWestPortalLoc.func_177967_a(this.dirB, this.sizeB).func_177967_a(this.dirA, this.sizeA);
        return Pair.of((Object)a, (Object)b);
    }

    public int hashCode() {
        return Objects.hash(this.axis, this.farthestDownNorthWestPortalLoc, this.sizeA, this.sizeB);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PortalSize)) {
            return false;
        }
        PortalSize that = (PortalSize)o;
        return this.sizeA == that.sizeA && this.sizeB == that.sizeB && this.axis == that.axis && Objects.equals(this.farthestDownNorthWestPortalLoc, that.farthestDownNorthWestPortalLoc);
    }

    public Direction.Axis getAxis() {
        return this.axis;
    }
}

