/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.client.renderer.color;

import java.lang.reflect.Field;
import javax.annotation.Nullable;
import mrp_v2.versatileportals.block.PortalBlock;
import mrp_v2.versatileportals.block.util.PortalFrameUtil;
import mrp_v2.versatileportals.util.ObjectHolder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PortalColorer
implements IBlockColor {
    public static final PortalColorer INSTANCE = new PortalColorer();

    public int getColor(BlockState blockState, @Nullable IBlockDisplayReader iBlockDisplayReader, @Nullable BlockPos pos, int tint) {
        if (iBlockDisplayReader == null || pos == null) {
            return 0xFFFFFF;
        }
        ClientWorld world = null;
        if (iBlockDisplayReader instanceof ChunkRenderCache) {
            for (Field field : ChunkRenderCache.class.getDeclaredFields()) {
                if (field.getType() != World.class) continue;
                field.setAccessible(true);
                try {
                    world = (ClientWorld)field.get(iBlockDisplayReader);
                    break;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        if (world == null) {
            return 0xFFFFFF;
        }
        if (blockState.func_203425_a((Block)ObjectHolder.PORTAL_FRAME_BLOCK.get()) || blockState.func_203425_a((Block)ObjectHolder.PORTAL_CONTROLLER_BLOCK.get())) {
            return PortalFrameUtil.getColor(world, pos);
        }
        if (blockState.func_203425_a((Block)ObjectHolder.PORTAL_BLOCK.get())) {
            return PortalBlock.getColor(blockState, world, pos);
        }
        return 0xFFFFFF;
    }
}

