/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.item;

import javax.annotation.Nullable;
import mrp_v2.versatileportals.block.util.PortalSize;
import mrp_v2.versatileportals.item.BasicSingleItem;
import mrp_v2.versatileportals.item.IPortalControlItem;
import mrp_v2.versatileportals.util.ObjectHolder;
import mrp_v2.versatileportals.util.Util;
import mrp_v2.versatileportals.world.BasicWorldTeleporter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class ExistingWorldControlItem
extends BasicSingleItem
implements IPortalControlItem {
    public static final String ID = "existing_world_control";
    public static final String COLOR_NBT_ID = "Color";
    public static final String WORLD_ID_NBT_ID = "WorldID";
    public static final TranslationTextComponent worldDoesNotExist = new TranslationTextComponent("item.versatileportals.existing_world_control.message.worldDoesNotExist");
    public static final TranslationTextComponent noTeleportSelf = new TranslationTextComponent("item.versatileportals.existing_world_control.message.noTeleportSelf");

    public ExistingWorldControlItem() {
        super(properties -> properties.func_200916_a(null));
    }

    public static int getColorDataFromItem(ItemStack stack) {
        CompoundNBT compound = stack.func_196082_o();
        return compound.func_74764_b(COLOR_NBT_ID) ? compound.func_74762_e(COLOR_NBT_ID) : 0x808080;
    }

    public static ItemStack getItemForWorld(World world) {
        ItemStack itemStack = new ItemStack((IItemProvider)ObjectHolder.EXISTING_WORLD_TELEPORT_ITEM.get());
        ExistingWorldControlItem.addTeleportDataToItem(itemStack, new ResourceLocation(Util.getWorldID(world)));
        ExistingWorldControlItem.addColorDataToItem(itemStack, ExistingWorldControlItem.getColorFromWorld(world));
        return itemStack;
    }

    public static void addColorDataToItem(ItemStack stack, int color) {
        CompoundNBT compound = stack.func_196082_o();
        compound.func_74768_a(COLOR_NBT_ID, color);
        stack.func_77982_d(compound);
    }

    private static int getColorFromWorld(World world) {
        return world.func_234923_W_().toString().hashCode() & 0xFFFFFF;
    }

    public static void addTeleportDataToItem(ItemStack stack, ResourceLocation worldID) {
        CompoundNBT compound = stack.func_196082_o();
        compound.func_74778_a(WORLD_ID_NBT_ID, worldID.toString());
        stack.func_77982_d(compound);
        stack.func_200302_a((ITextComponent)new StringTextComponent(worldID.func_110623_a()));
    }

    @Override
    @Nullable
    public Entity teleportEntity(Entity entity, ServerWorld currentWorld, PortalSize portalSize, ItemStack itemStack) {
        ServerWorld destinationWorld = currentWorld.func_73046_m().func_71218_a(ExistingWorldControlItem.getTeleportDestination(itemStack));
        if (destinationWorld == null) {
            if (entity instanceof ServerPlayerEntity) {
                Util.sendMessage((ServerPlayerEntity)entity, (ITextComponent)worldDoesNotExist);
            }
            return null;
        }
        if (destinationWorld == currentWorld) {
            if (entity instanceof ServerPlayerEntity) {
                Util.sendMessage((ServerPlayerEntity)entity, (ITextComponent)noTeleportSelf);
            }
            return null;
        }
        return entity.changeDimension(destinationWorld, (ITeleporter)new BasicWorldTeleporter(destinationWorld, currentWorld, portalSize));
    }

    public static RegistryKey<World> getTeleportDestination(ItemStack stack) {
        String worldID = stack.func_196082_o().func_74779_i(WORLD_ID_NBT_ID);
        return Util.createWorldKey(worldID);
    }
}

