/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public abstract class ColorParticleData
implements IParticleData {
    protected final int color;

    public ColorParticleData(int color) {
        this.color = color;
    }

    protected static <T extends ColorParticleData> ParticleType<T> createParticleType(final Supplier<Codec<T>> codecSupplier, IParticleData.IDeserializer<T> deserializerSupplier) {
        ParticleType particleType = new ParticleType<T>(false, deserializerSupplier){

            public Codec<T> func_230522_e_() {
                return (Codec)codecSupplier.get();
            }
        };
        return particleType;
    }

    protected static <T extends ColorParticleData> Codec<T> makeCodec(Function<Integer, T> constructor) {
        return RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("color").forGetter(ColorParticleData::getColor)).apply((Applicative)builder, constructor));
    }

    public int getColor() {
        return this.color;
    }

    protected static <T extends ColorParticleData> IParticleData.IDeserializer<T> makeDeserializer(final Function<Integer, T> constructor) {
        return new IParticleData.IDeserializer<T>(){

            public T fromCommand(ParticleType<T> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                return (ColorParticleData)constructor.apply(reader.readInt());
            }

            public T fromNetwork(ParticleType<T> particleTypeIn, PacketBuffer buffer) {
                return (ColorParticleData)constructor.apply(buffer.readInt());
            }
        };
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeInt(this.color);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s, %d", this.getID(), this.color);
    }

    abstract String getID();
}

