/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.tileentity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import mrp_v2.versatileportals.VersatilePortals;
import mrp_v2.versatileportals.block.PortalControllerBlock;
import mrp_v2.versatileportals.block.util.PortalFrameUtil;
import mrp_v2.versatileportals.inventory.PortalControllerItemStackHandler;
import mrp_v2.versatileportals.inventory.container.PortalControllerContainer;
import mrp_v2.versatileportals.item.ExistingWorldControlItem;
import mrp_v2.versatileportals.tileentity.util.PortalControllerData;
import mrp_v2.versatileportals.util.ObjectHolder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.logging.log4j.Logger;

public class PortalControllerTileEntity
extends TileEntity
implements ICapabilityProvider,
INamedContainerProvider,
ITickableTileEntity,
INameable {
    public static final String ID = "portal_controller";
    public static final int DEFAULT_PORTAL_COLOR = 65280;
    public static final int ERROR_PORTAL_COLOR = 0xFFFFFF;
    public static final int TICKS_PER_RENDER_REVOLUTION = 120;
    private static final String DATA_NBT_ID = "PortalControllerData";
    private final PortalControllerItemStackHandler inventory = new PortalControllerItemStackHandler(this);
    private final LazyOptional<PortalControllerItemStackHandler> inventoryLazyOptional = LazyOptional.of(() -> this.inventory);
    public int ticks;
    private ITextComponent customName;
    private int portalColor = 65280;

    public static TileEntityType<PortalControllerTileEntity> createTileEntity() {
        return TileEntityType.Builder.func_223042_a(PortalControllerTileEntity::new, (Block[])new Block[]{(Block)ObjectHolder.PORTAL_CONTROLLER_BLOCK.get()}).func_206865_a(null);
    }

    public PortalControllerTileEntity() {
        super((TileEntityType)ObjectHolder.PORTAL_CONTROLLER_TILE_ENTITY_TYPE.get());
    }

    public PortalControllerItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getControlItemStack() {
        return this.inventory.getStackInSlot(0);
    }

    @Nullable
    public RegistryKey<World> getTeleportDestination() {
        if (this.inventory.getStackInSlot(0).func_190926_b()) {
            return null;
        }
        return ExistingWorldControlItem.getTeleportDestination(this.inventory.getStackInSlot(0));
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public void setCustomName(@Nullable ITextComponent name) {
        this.customName = name;
    }

    public ITextComponent getDefaultName() {
        return new TranslationTextComponent(((PortalControllerBlock)ObjectHolder.PORTAL_CONTROLLER_BLOCK.get()).func_149739_a());
    }

    public Container createMenu(int id, PlayerInventory playerInventoryIn, PlayerEntity playerIn) {
        return new PortalControllerContainer(id, playerInventoryIn, this.inventory, this.portalColor, this.func_174877_v());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        if (this.field_145850_b.func_175667_e(this.field_174879_c)) {
            PortalFrameUtil.updatePortals(PortalFrameUtil.getPortalSizes(this.field_174879_c, (IBlockReader)this.field_145850_b, false));
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b(DATA_NBT_ID, 10)) {
            CompoundNBT dataNBT = compound.func_74775_l(DATA_NBT_ID);
            DataResult dataResult = PortalControllerData.CODEC.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)dataNBT);
            dataResult.resultOrPartial(arg_0 -> ((Logger)VersatilePortals.LOGGER).error(arg_0)).ifPresent(data -> {
                this.portalColor = data.getPortalColor();
                this.inventory.deserializeNBT(data.getInventoryData());
                this.customName = data.getCustomName();
            });
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        PortalControllerData.CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)new PortalControllerData(this)).resultOrPartial(arg_0 -> ((Logger)VersatilePortals.LOGGER).error(arg_0)).ifPresent(data -> compound.func_218657_a(DATA_NBT_ID, data));
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189515_b(new CompoundNBT()));
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public void func_145843_s() {
        this.inventoryLazyOptional.invalidate();
        super.func_145843_s();
    }

    public int getPortalColor() {
        return this.portalColor;
    }

    public void setPortalColor(int newPortalColor) {
        if (this.portalColor != newPortalColor) {
            this.portalColor = newPortalColor;
            this.func_70296_d();
            this.sendUpdateToClient();
        }
    }

    private void sendUpdateToClient() {
        BlockState state = this.func_195044_w();
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 2);
    }

    public void onInventorySlotChanged() {
        this.func_70296_d();
        this.sendUpdateToClient();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (++this.ticks >= 120) {
            this.ticks = 0;
        }
        if (this.ticks % 4 == 0) {
            if (this.inventory.getStackInSlot(0).func_190926_b()) {
                return;
            }
            PortalControllerBlock.animateTick(this.func_195044_w(), this.field_145850_b, this.field_174879_c);
        }
    }

    public ITextComponent func_145748_c_() {
        return super.func_145748_c_();
    }
}

