/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.tileentity.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import mrp_v2.versatileportals.tileentity.PortalControllerTileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class PortalControllerData {
    private static final String NULL_STRING = "null";
    public static final Codec<PortalControllerData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("PortalColor").forGetter(PortalControllerData::getPortalColor), (App)Codec.STRING.fieldOf("CustomName").forGetter(PortalControllerData::getCustomNameString), (App)CompoundNBT.field_240597_a_.fieldOf("Inventory").forGetter(PortalControllerData::getInventoryData)).apply((Applicative)builder, PortalControllerData::new));
    private final CompoundNBT inventoryData;
    @Nullable
    private final ITextComponent customName;
    private final int portalColor;

    public PortalControllerData(PortalControllerTileEntity portalController) {
        this(portalController.getPortalColor(), portalController.func_200201_e(), portalController.getInventory().serializeNBT());
    }

    private PortalControllerData(int portalColor, @Nullable ITextComponent customName, CompoundNBT inventoryData) {
        this.portalColor = portalColor;
        this.customName = customName;
        this.inventoryData = inventoryData;
    }

    private PortalControllerData(int portalColor, String customName, CompoundNBT inventoryData) {
        this(portalColor, PortalControllerData.makeITextComponent(customName), inventoryData);
    }

    @Nullable
    private static ITextComponent makeITextComponent(String str) {
        return str.equals(NULL_STRING) ? null : ITextComponent.Serializer.func_240643_a_((String)str);
    }

    public CompoundNBT getInventoryData() {
        return this.inventoryData;
    }

    @Nullable
    public ITextComponent getCustomName() {
        return this.customName;
    }

    private String getCustomNameString() {
        return this.customName == null ? NULL_STRING : ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName);
    }

    public int getPortalColor() {
        return this.portalColor;
    }
}

