/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.util;

import mrp_v2.versatileportals.block.PortalBlock;
import mrp_v2.versatileportals.block.PortalControllerBlock;
import mrp_v2.versatileportals.block.PortalFrameBlock;
import mrp_v2.versatileportals.common.capabilities.PortalDataStorage;
import mrp_v2.versatileportals.inventory.container.PortalControllerContainer;
import mrp_v2.versatileportals.item.EmptyExistingWorldControlItem;
import mrp_v2.versatileportals.item.ExistingWorldControlItem;
import mrp_v2.versatileportals.item.PortalLighter;
import mrp_v2.versatileportals.particles.PortalControllerParticleData;
import mrp_v2.versatileportals.particles.PortalParticleData;
import mrp_v2.versatileportals.tileentity.PortalControllerTileEntity;
import mrp_v2.versatileportals.village.PortalPointOfInterestType;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="versatileportals")
public class ObjectHolder {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"versatileportals");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"versatileportals");
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"versatileportals");
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"versatileportals");
    public static final DeferredRegister<PointOfInterestType> POIS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"versatileportals");
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"versatileportals");
    public static final RegistryObject<PortalBlock> PORTAL_BLOCK;
    public static final RegistryObject<PortalControllerBlock> PORTAL_CONTROLLER_BLOCK;
    public static final RegistryObject<PortalFrameBlock> PORTAL_FRAME_BLOCK;
    public static final RegistryObject<BlockItem> PORTAL_CONTROLLER_BLOCK_ITEM;
    public static final ItemGroup MAIN_ITEM_GROUP;
    public static final RegistryObject<BlockItem> PORTAL_FRAME_BLOCK_ITEM;
    public static final RegistryObject<PortalLighter> PORTAL_LIGHTER_ITEM;
    public static final RegistryObject<EmptyExistingWorldControlItem> EMPTY_EXISTING_WORLD_TELEPORT_ITEM;
    public static final RegistryObject<ExistingWorldControlItem> EXISTING_WORLD_TELEPORT_ITEM;
    public static final RegistryObject<ContainerType<PortalControllerContainer>> PORTAL_CONTROLLER_CONTAINER_TYPE;
    public static final RegistryObject<ParticleType<PortalParticleData>> PORTAL_PARTICLE_TYPE;
    public static final RegistryObject<ParticleType<PortalControllerParticleData>> PORTAL_CONTROLLER_PARTICLE_TYPE;
    public static final PortalDataStorage PORTAL_DATA_STORAGE;
    public static final RegistryObject<PortalPointOfInterestType> PORTAL_POINT_OF_INTEREST_TYPE;
    public static final RegistryObject<TileEntityType<PortalControllerTileEntity>> PORTAL_CONTROLLER_TILE_ENTITY_TYPE;

    public static void registerListeners(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        CONTAINERS.register(bus);
        PARTICLES.register(bus);
        POIS.register(bus);
        TILE_ENTITIES.register(bus);
    }

    public static BlockItem createBlockItem(Block block) {
        return new BlockItem(block, new Item.Properties().func_200916_a(MAIN_ITEM_GROUP));
    }

    static {
        MAIN_ITEM_GROUP = new ItemGroup("versatileportals"){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)PORTAL_CONTROLLER_BLOCK_ITEM.get());
            }
        };
        PORTAL_BLOCK = BLOCKS.register("portal", PortalBlock::new);
        PORTAL_CONTROLLER_BLOCK = BLOCKS.register("portal_controller", PortalControllerBlock::new);
        PORTAL_FRAME_BLOCK = BLOCKS.register("portal_frame", PortalFrameBlock::new);
        PORTAL_CONTROLLER_BLOCK_ITEM = ITEMS.register("portal_controller", () -> ObjectHolder.createBlockItem((Block)PORTAL_CONTROLLER_BLOCK.get()));
        PORTAL_FRAME_BLOCK_ITEM = ITEMS.register("portal_frame", () -> ObjectHolder.createBlockItem((Block)PORTAL_FRAME_BLOCK.get()));
        PORTAL_LIGHTER_ITEM = ITEMS.register("portal_lighter", PortalLighter::new);
        EMPTY_EXISTING_WORLD_TELEPORT_ITEM = ITEMS.register("empty_existing_world_control", EmptyExistingWorldControlItem::new);
        EXISTING_WORLD_TELEPORT_ITEM = ITEMS.register("existing_world_control", ExistingWorldControlItem::new);
        PORTAL_CONTROLLER_CONTAINER_TYPE = CONTAINERS.register("portal_controller", PortalControllerContainer.Type::new);
        PORTAL_PARTICLE_TYPE = PARTICLES.register("portal", PortalParticleData::createParticleType);
        PORTAL_CONTROLLER_PARTICLE_TYPE = PARTICLES.register("portal_controller", PortalControllerParticleData::createParticleType);
        PORTAL_DATA_STORAGE = new PortalDataStorage();
        PORTAL_POINT_OF_INTEREST_TYPE = POIS.register("portal", PortalPointOfInterestType::new);
        PORTAL_CONTROLLER_TILE_ENTITY_TYPE = TILE_ENTITIES.register("portal_controller", PortalControllerTileEntity::createTileEntity);
    }
}

