/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.util;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import mrp_v2.versatileportals.common.capabilities.CapabilityHandler;
import mrp_v2.versatileportals.common.capabilities.IPortalDataCapability;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class Util {
    public static final ImmutableMap<Direction.Axis, Pair<Direction.Axis, Direction.Axis>> OTHER_AXES_MAP = ImmutableMap.of((Object)Direction.Axis.X, Util.getOtherOxes(Direction.Axis.X), (Object)Direction.Axis.Y, Util.getOtherOxes(Direction.Axis.Y), (Object)Direction.Axis.Z, Util.getOtherOxes(Direction.Axis.Z));

    private static Pair<Direction.Axis, Direction.Axis> getOtherOxes(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return Pair.of((Object)Direction.Axis.Y, (Object)Direction.Axis.Z);
            }
            case Y: {
                return Pair.of((Object)Direction.Axis.X, (Object)Direction.Axis.Z);
            }
            case Z: {
                return Pair.of((Object)Direction.Axis.X, (Object)Direction.Axis.Y);
            }
        }
        throw new IllegalArgumentException();
    }

    public static int iGetColorR(int color) {
        return (color & 0xFF0000) >> 16;
    }

    public static int iGetColorG(int color) {
        return (color & 0xFF00) >> 8;
    }

    public static int iGetColorB(int color) {
        return color & 0xFF;
    }

    public static float fGetColorR(int color) {
        return (float)((color & 0xFF0000) >> 16) / 255.0f;
    }

    public static float fGetColorG(int color) {
        return (float)((color & 0xFF00) >> 8) / 255.0f;
    }

    public static float fGetColorB(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static int createColor(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    @Nullable
    public static IPortalDataCapability getPortalData(Entity entity) {
        return (IPortalDataCapability)entity.getCapability(CapabilityHandler.PORTAL_DATA_CAPABILITY).orElse(null);
    }

    @Nullable
    public static RegistryKey<World> createWorldKey(String worldID) {
        if (worldID.isEmpty()) {
            return null;
        }
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(worldID));
    }

    public static String getWorldID(World world) {
        return Util.getWorldID((RegistryKey<World>)world.func_234923_W_());
    }

    public static String getWorldID(RegistryKey<World> world) {
        return world.func_240901_a_().toString();
    }

    public static BlockPos[] getCollidingBlocks(AxisAlignedBB box) {
        int minX = (int)Math.floor(box.field_72340_a);
        int minY = (int)Math.floor(box.field_72338_b);
        int minZ = (int)Math.floor(box.field_72339_c);
        int maxX = (int)Math.ceil(box.field_72336_d);
        int maxY = (int)Math.ceil(box.field_72337_e);
        int maxZ = (int)Math.ceil(box.field_72334_f);
        int xSize = maxX - minX;
        int ySize = maxY - minY;
        int zSize = maxZ - minZ;
        BlockPos[] blocks = new BlockPos[xSize * ySize * zSize];
        for (int i = 0; i < xSize; ++i) {
            int x = i + minX;
            for (int j = 0; j < ySize; ++j) {
                int y = j + minY;
                for (int k = 0; k < zSize; ++k) {
                    int z = k + minZ;
                    blocks[(i * ySize + j) * zSize + k] = new BlockPos(x, y, z);
                }
            }
        }
        return blocks;
    }

    @SafeVarargs
    public static <T> T[] makeArray(T ... objects) {
        return objects;
    }

    @SafeVarargs
    public static <L, R> Pair<L, R>[] mergePairArrays(Pair<L, R>[] ... arrays) {
        int totalLength = 0;
        for (Pair<L, R>[] array : arrays) {
            totalLength += array.length;
        }
        Pair[] mergedArray = new Pair[totalLength];
        int i = 0;
        Pair<L, R>[][] pairArray = arrays;
        int n = pairArray.length;
        for (int j = 0; j < n; ++j) {
            Pair<L, R>[] array;
            for (Pair<L, R> obj : array = pairArray[j]) {
                mergedArray[i++] = obj;
            }
        }
        return mergedArray;
    }

    public static void sendMessage(ServerPlayerEntity player, ITextComponent message) {
        player.func_241151_a_(message, ChatType.GAME_INFO, net.minecraft.util.Util.field_240973_b_);
    }
}

