/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.world;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import mrp_v2.versatileportals.block.PortalBlock;
import mrp_v2.versatileportals.block.PortalControllerBlock;
import mrp_v2.versatileportals.block.PortalFrameBlock;
import mrp_v2.versatileportals.block.util.PortalSize;
import mrp_v2.versatileportals.common.capabilities.IPortalDataCapability;
import mrp_v2.versatileportals.item.ExistingWorldControlItem;
import mrp_v2.versatileportals.tileentity.PortalControllerTileEntity;
import mrp_v2.versatileportals.util.ObjectHolder;
import mrp_v2.versatileportals.util.Util;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.util.ITeleporter;
import org.apache.commons.lang3.tuple.Pair;

public class BasicWorldTeleporter
implements ITeleporter {
    protected final ServerWorld destinationWorld;
    protected final ServerWorld originWorld;
    protected final PortalSize originPortalSize;

    public BasicWorldTeleporter(ServerWorld destinationWorld, ServerWorld originWorld, PortalSize originPortalSize) {
        this.destinationWorld = destinationWorld;
        this.originWorld = originWorld;
        this.originPortalSize = originPortalSize;
    }

    @Nullable
    public Entity placeEntity(Entity entityIn, ServerWorld currentWorld, ServerWorld destinationWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        Entity repositionedEntity = repositionEntity.apply(false);
        IPortalDataCapability portalData = Util.getPortalData(repositionedEntity);
        portalData.setRemainingPortalCooldown(repositionedEntity.func_82147_ab());
        portalData.setInPortalTime(0);
        return repositionedEntity;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
        return this.getPortalInfo(entity);
    }

    @Nullable
    private PortalInfo getPortalInfo(Entity entity) {
        WorldBorder worldborder = this.destinationWorld.func_175723_af();
        double minX = Math.max(-2.9999872E7, worldborder.func_177726_b() + 16.0);
        double minZ = Math.max(-2.9999872E7, worldborder.func_177736_c() + 16.0);
        double maxX = Math.min(2.9999872E7, worldborder.func_177728_d() - 16.0);
        double maxZ = Math.min(2.9999872E7, worldborder.func_177733_e() - 16.0);
        double coordinateMultiplier = DimensionType.func_242715_a((DimensionType)entity.field_70170_p.func_230315_m_(), (DimensionType)this.destinationWorld.func_230315_m_());
        BlockPos pos = new BlockPos(MathHelper.func_151237_a((double)(entity.func_226277_ct_() * coordinateMultiplier), (double)minX, (double)maxX), entity.func_226278_cu_(), MathHelper.func_151237_a((double)(entity.func_226281_cx_() * coordinateMultiplier), (double)minZ, (double)maxZ));
        return this.getExistingPortal(pos, coordinateMultiplier).map(result -> this.convertTeleportResult((TeleportationRepositioner.Result)result, entity)).orElseGet(() -> this.makePortal(pos).map(result -> this.convertTeleportResult((TeleportationRepositioner.Result)result, entity)).orElse(null));
    }

    private PortalInfo convertTeleportResult(TeleportationRepositioner.Result result, Entity entity) {
        Direction.Axis axis = this.originPortalSize.getAxis();
        Vector3d vector3d = new Vector3d(0.5, 0.0, 0.0);
        return BasicWorldTeleporter.createPortalInfo(this.destinationWorld, result, axis, vector3d, entity.func_213305_a(entity.func_213283_Z()), entity.func_213322_ci(), entity.field_70177_z, entity.field_70125_A);
    }

    private static PortalInfo createPortalInfo(ServerWorld world, TeleportationRepositioner.Result result, Direction.Axis portalAxis, Vector3d offsetVector, EntitySize entitySize, Vector3d motion, float rotationYaw, float rotationPitch) {
        Vector3d adjustedPositionVector;
        Vector3d adjustedMotionVector;
        int yawAdjustment;
        BlockPos portalBlockPos = result.field_243679_a;
        BlockState portalBlockState = world.func_180495_p(portalBlockPos);
        Direction.Axis portalBlockAxis = (Direction.Axis)portalBlockState.func_177229_b((Property)BlockStateProperties.field_208148_A);
        double portalSizeA = result.field_243680_b;
        double portalSizeB = result.field_243681_c;
        if (portalAxis != portalBlockAxis) {
            if (portalAxis == Direction.Axis.Y || portalBlockAxis == Direction.Axis.Y) {
                yawAdjustment = 0;
                adjustedMotionVector = portalAxis == Direction.Axis.X || portalBlockAxis == Direction.Axis.X ? new Vector3d(motion.field_72448_b, motion.field_72449_c, motion.field_72450_a) : new Vector3d(motion.field_72449_c, motion.field_72450_a, motion.field_72448_b);
            } else {
                yawAdjustment = 90;
                adjustedMotionVector = new Vector3d(motion.field_72449_c, motion.field_72448_b, -motion.field_72450_a);
            }
        } else {
            yawAdjustment = 0;
            adjustedMotionVector = motion;
        }
        double portalCenterA = (double)entitySize.field_220315_a / 2.0 + (portalSizeA - (double)entitySize.field_220315_a) * offsetVector.func_82615_a();
        double portalCenterAB = (double)entitySize.field_220315_a / 2.0 + (portalSizeB - (double)entitySize.field_220315_a) * offsetVector.func_82615_a();
        double portalCenterB = (portalSizeB - (double)entitySize.field_220316_b) * offsetVector.func_82617_b();
        double portalCenterC = 0.5 + offsetVector.func_82616_c();
        switch (portalBlockAxis) {
            case X: {
                adjustedPositionVector = new Vector3d((double)portalBlockPos.func_177958_n() + portalCenterC, (double)portalBlockPos.func_177956_o() + portalCenterB, (double)portalBlockPos.func_177952_p() + portalCenterA);
                break;
            }
            case Y: {
                adjustedPositionVector = new Vector3d((double)portalBlockPos.func_177958_n() + portalCenterA, (double)portalBlockPos.func_177956_o() + portalCenterB, (double)portalBlockPos.func_177952_p() + portalCenterAB);
                break;
            }
            case Z: {
                adjustedPositionVector = new Vector3d((double)portalBlockPos.func_177958_n() + portalCenterA, (double)portalBlockPos.func_177956_o() + portalCenterB, (double)portalBlockPos.func_177952_p() + portalCenterC);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new PortalInfo(adjustedPositionVector, adjustedMotionVector, rotationYaw + (float)yawAdjustment, rotationPitch);
    }

    public Optional<TeleportationRepositioner.Result> getExistingPortal(BlockPos searchOrigin, double coordinateMultiplier) {
        PointOfInterestManager pointOfInterestManager = this.destinationWorld.func_217443_B();
        int i = coordinateMultiplier == 0.125 ? 16 : 128;
        pointOfInterestManager.func_226347_a_((IWorldReader)this.destinationWorld, searchOrigin, i);
        Optional<PointOfInterest> optionalPointOfInterest = pointOfInterestManager.func_226353_b_(pointOfInterestType -> pointOfInterestType == ObjectHolder.PORTAL_POINT_OF_INTEREST_TYPE.get(), searchOrigin, i, PointOfInterestManager.Status.ANY).sorted(Comparator.comparingDouble(pointOfInterest -> pointOfInterest.func_218261_f().func_177951_i((Vector3i)searchOrigin)).thenComparingInt(pointOfInterest -> pointOfInterest.func_218261_f().func_177956_o())).filter(pointOfInterest -> this.destinationWorld.func_180495_p(pointOfInterest.func_218261_f()).func_235901_b_((Property)BlockStateProperties.field_208148_A)).findFirst();
        return optionalPointOfInterest.map(pointOfInterest -> {
            BlockPos poiPos = pointOfInterest.func_218261_f();
            this.destinationWorld.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(poiPos), 3, (Object)poiPos);
            BlockState poiState = this.destinationWorld.func_180495_p(poiPos);
            Pair otherAxes = (Pair)Util.OTHER_AXES_MAP.get((Object)poiState.func_177229_b((Property)BlockStateProperties.field_208148_A));
            return TeleportationRepositioner.func_243676_a((BlockPos)poiPos, (Direction.Axis)((Direction.Axis)otherAxes.getLeft()), (int)21, (Direction.Axis)((Direction.Axis)otherAxes.getRight()), (int)21, lambdaPos -> this.destinationWorld.func_180495_p(lambdaPos) == poiState);
        });
    }

    public Optional<TeleportationRepositioner.Result> makePortal(BlockPos pos) {
        double availablePortalLocDistance = -1.0;
        BlockPos availablePortalLoc = null;
        double partiallyAvailablePortalLocDistance = -1.0;
        BlockPos partiallyAvailablePortalLoc = null;
        WorldBorder worldBorder = this.destinationWorld.func_175723_af();
        int maxPortalGenerationHeight = this.destinationWorld.func_234938_ad_() - 1;
        BlockPos.Mutable mutableOriginPos = pos.func_239590_i_();
        for (BlockPos.Mutable testPos : BlockPos.func_243514_a((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int maxPortalGenerationHeightForPos = Math.min(maxPortalGenerationHeight, this.destinationWorld.func_201676_a(Heightmap.Type.MOTION_BLOCKING, testPos.func_177958_n(), testPos.func_177952_p()));
            if (!worldBorder.func_177746_a((BlockPos)testPos) || !worldBorder.func_177746_a((BlockPos)testPos.func_189536_c(this.originPortalSize.getDirA()).func_189536_c(this.originPortalSize.getDirB()))) continue;
            testPos.func_189536_c(this.originPortalSize.getOppositeDirA()).func_189536_c(this.originPortalSize.getOppositeDirB());
            for (int availableYSpaceBottom = maxPortalGenerationHeightForPos; availableYSpaceBottom >= 0; --availableYSpaceBottom) {
                int availableYSpace;
                testPos.func_185336_p(availableYSpaceBottom);
                if (!this.destinationWorld.func_175623_d((BlockPos)testPos)) continue;
                int availableYSpaceTop = availableYSpaceBottom;
                while (availableYSpaceBottom > 0 && this.destinationWorld.func_175623_d((BlockPos)testPos.func_189536_c(Direction.DOWN))) {
                    --availableYSpaceBottom;
                }
                if (availableYSpaceBottom + this.originPortalSize.getSizeOnAxis(Direction.Axis.Y) + 1 > maxPortalGenerationHeight || (availableYSpace = availableYSpaceTop - availableYSpaceBottom) > 0 && availableYSpace < this.originPortalSize.getSizeA() + 1) continue;
                testPos.func_185336_p(availableYSpaceBottom);
                if (!this.checkRegionForPlacement((BlockPos)testPos, mutableOriginPos, Direction.func_211699_a((Direction.Axis)this.originPortalSize.getAxis(), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), 0)) continue;
                double distance = pos.func_177951_i((Vector3i)testPos);
                if (this.checkRegionForPlacement((BlockPos)testPos, mutableOriginPos, Direction.func_211699_a((Direction.Axis)this.originPortalSize.getAxis(), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), -1) && this.checkRegionForPlacement((BlockPos)testPos, mutableOriginPos, Direction.func_211699_a((Direction.Axis)this.originPortalSize.getAxis(), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), 1) && (availablePortalLocDistance == -1.0 || availablePortalLocDistance > distance)) {
                    availablePortalLocDistance = distance;
                    availablePortalLoc = testPos.func_185334_h();
                }
                if (availablePortalLocDistance != -1.0 || partiallyAvailablePortalLocDistance != -1.0 && !(partiallyAvailablePortalLocDistance > distance)) continue;
                partiallyAvailablePortalLocDistance = distance;
                partiallyAvailablePortalLoc = testPos.func_185334_h();
            }
        }
        if (availablePortalLocDistance == -1.0 && partiallyAvailablePortalLocDistance != -1.0) {
            availablePortalLoc = partiallyAvailablePortalLoc;
            availablePortalLocDistance = partiallyAvailablePortalLocDistance;
        }
        boolean floorWidth = true;
        if (availablePortalLocDistance == -1.0) {
            availablePortalLoc = new BlockPos(pos.func_177958_n(), MathHelper.func_76125_a((int)pos.func_177956_o(), (int)70, (int)(this.destinationWorld.func_234938_ad_() - 10)), pos.func_177952_p()).func_185334_h();
            Direction openPortalDir = Direction.func_211699_a((Direction.Axis)this.originPortalSize.getAxis(), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            if (!worldBorder.func_177746_a(availablePortalLoc)) {
                return Optional.empty();
            }
            BlockState airState = Blocks.field_150350_a.func_176223_P();
            if (this.originPortalSize.getAxis() != Direction.Axis.Y) {
                for (int floorXZ = -1; floorXZ <= 1; ++floorXZ) {
                    for (int portalXZ = 0; portalXZ < this.originPortalSize.getHorizontalSize(); ++portalXZ) {
                        for (int y = -1; y < this.originPortalSize.getVerticalSize(); ++y) {
                            BlockState blockState = y < 0 ? ((PortalFrameBlock)ObjectHolder.PORTAL_FRAME_BLOCK.get()).func_176223_P() : airState;
                            mutableOriginPos.func_239621_a_((Vector3i)availablePortalLoc, portalXZ * this.originPortalSize.getDirA().func_82601_c() + floorXZ * openPortalDir.func_82601_c(), y, portalXZ * this.originPortalSize.getDirA().func_82599_e() + floorXZ * openPortalDir.func_82599_e());
                            this.destinationWorld.func_175656_a((BlockPos)mutableOriginPos, blockState);
                        }
                    }
                }
            } else {
                int verticalAirSpace = 2;
                for (int y = -2; y <= 2; ++y) {
                    for (int x = 0; x < this.originPortalSize.getSizeOnAxis(Direction.Axis.X); ++x) {
                        for (int z = 0; z < this.originPortalSize.getSizeOnAxis(Direction.Axis.Z); ++z) {
                            mutableOriginPos.func_239621_a_((Vector3i)availablePortalLoc, x, y, z);
                            this.destinationWorld.func_175656_a((BlockPos)mutableOriginPos, airState);
                        }
                    }
                }
            }
        }
        int portalSizeA = this.originPortalSize.getSizeA();
        int portalSizeB = this.originPortalSize.getSizeB();
        for (int dirAOffset = -1; dirAOffset < portalSizeA + 1; ++dirAOffset) {
            for (int dirBOffset = -1; dirBOffset < portalSizeB + 1; ++dirBOffset) {
                if (!(dirAOffset == -1 | dirAOffset == portalSizeA) && dirBOffset != -1 && dirBOffset != portalSizeB) continue;
                Vector3i offsetVector = new Vector3i(dirAOffset * this.originPortalSize.getDirA().func_82601_c() + dirBOffset * this.originPortalSize.getDirB().func_82601_c(), dirAOffset * this.originPortalSize.getDirA().func_96559_d() + dirBOffset * this.originPortalSize.getDirB().func_96559_d(), dirAOffset * this.originPortalSize.getDirA().func_82599_e() + dirBOffset * this.originPortalSize.getDirB().func_82599_e());
                mutableOriginPos.func_239621_a_((Vector3i)availablePortalLoc, offsetVector.func_177958_n(), offsetVector.func_177956_o(), offsetVector.func_177952_p());
                if (this.originPortalSize.getPortalControllerRelativePos().equals((Object)new BlockPos(offsetVector))) {
                    this.destinationWorld.func_180501_a((BlockPos)mutableOriginPos, (BlockState)((PortalControllerBlock)ObjectHolder.PORTAL_CONTROLLER_BLOCK.get()).func_176223_P().func_206870_a(PortalControllerBlock.AXIS, (Comparable)this.originPortalSize.getAxis()), 3);
                    PortalControllerTileEntity portalControllerTileEntity = (PortalControllerTileEntity)this.destinationWorld.func_175625_s((BlockPos)mutableOriginPos);
                    portalControllerTileEntity.getInventory().insertItem(0, ExistingWorldControlItem.getItemForWorld((World)this.originWorld), false);
                    portalControllerTileEntity.setPortalColor(((PortalControllerTileEntity)((Object)this.originPortalSize.getPortalController((IBlockReader)this.originWorld).getLeft())).getPortalColor());
                    continue;
                }
                this.destinationWorld.func_180501_a((BlockPos)mutableOriginPos, ((PortalFrameBlock)ObjectHolder.PORTAL_FRAME_BLOCK.get()).func_176223_P(), 3);
            }
        }
        BlockState portalBlockState = (BlockState)((PortalBlock)ObjectHolder.PORTAL_BLOCK.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)this.originPortalSize.getAxis());
        for (int dirAOffset = 0; dirAOffset < portalSizeA; ++dirAOffset) {
            for (int dirBOffset = 0; dirBOffset < portalSizeB; ++dirBOffset) {
                Vector3i offsetVector = new Vector3i(dirAOffset * this.originPortalSize.getDirA().func_82601_c() + dirBOffset * this.originPortalSize.getDirB().func_82601_c(), dirAOffset * this.originPortalSize.getDirA().func_96559_d() + dirBOffset * this.originPortalSize.getDirB().func_96559_d(), dirAOffset * this.originPortalSize.getDirA().func_82599_e() + dirBOffset * this.originPortalSize.getDirB().func_82599_e());
                mutableOriginPos.func_239621_a_((Vector3i)availablePortalLoc, offsetVector.func_177958_n(), offsetVector.func_177956_o(), offsetVector.func_177952_p());
                this.destinationWorld.func_180501_a((BlockPos)mutableOriginPos, portalBlockState, 18);
            }
        }
        return Optional.of(new TeleportationRepositioner.Result(availablePortalLoc.func_185334_h(), portalSizeA, portalSizeB));
    }

    private boolean checkRegionForPlacement(BlockPos originalPos, BlockPos.Mutable offsetPos, Direction axis, int offsetScale) {
        Vector3i combinedOffsetVector = new Vector3i(this.originPortalSize.getDirA().func_82601_c() + this.originPortalSize.getDirB().func_82601_c(), this.originPortalSize.getDirA().func_96559_d() + this.originPortalSize.getDirB().func_96559_d(), this.originPortalSize.getDirA().func_82599_e() + this.originPortalSize.getDirB().func_82599_e());
        for (int i = -1; i < this.originPortalSize.getSizeA(); ++i) {
            for (int j = -1; j < this.originPortalSize.getSizeB(); ++j) {
                offsetPos.func_239621_a_((Vector3i)originalPos, combinedOffsetVector.func_177958_n() * i + axis.func_82601_c() * offsetScale, combinedOffsetVector.func_177956_o() * j + axis.func_96559_d() * offsetScale, combinedOffsetVector.func_177952_p() * i + axis.func_82599_e() * offsetScale);
                if (j < 0 && !this.destinationWorld.func_180495_p((BlockPos)offsetPos).func_185904_a().func_76220_a()) {
                    return false;
                }
                if (j < 0 || this.destinationWorld.func_175623_d((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }
}

