/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.versatileportals.world;

import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mrp_v2.versatileportals.block.util.PortalSize;
import mrp_v2.versatileportals.common.capabilities.IPortalDataCapability;
import mrp_v2.versatileportals.item.IPortalControlItem;
import mrp_v2.versatileportals.tileentity.PortalControllerTileEntity;
import mrp_v2.versatileportals.util.Util;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class EventHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final TranslationTextComponent noPortalController = new TranslationTextComponent("block.versatileportals.portal.message.noPortalController");
    public static final TranslationTextComponent noControlItem = new TranslationTextComponent("block.versatileportals.portal_controller.message.noControlItem");
    public static final TranslationTextComponent teleported = new TranslationTextComponent("block.versatileportals.portal_controller.message.teleported");
    public static final Function<Object[], TranslationTextComponent> teleportingInFunction = args -> new TranslationTextComponent("block.versatileportals.portal_controller.message.teleportingIn", args);

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.world instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.world;
            Set relevantEntities = world.getEntities().filter(entity -> entity != null && entity.func_70089_S()).collect(Collectors.toSet());
            for (Entity entity2 : relevantEntities) {
                IPortalDataCapability portalData = Util.getPortalData(entity2);
                if (portalData == null) {
                    LOGGER.debug("Could not get IPortalDataCapability for entity: " + entity2);
                    continue;
                }
                if (portalData.getInPortal()) {
                    portalData.setInPortal(false);
                    if (portalData.getRemainingPortalCooldown() > 0) {
                        portalData.setRemainingPortalCooldown(entity2.func_82147_ab());
                        return;
                    }
                    if (portalData.incrementInPortalTime() < entity2.func_82145_z()) {
                        if (entity2.func_82145_z() <= 1 || !(entity2 instanceof ServerPlayerEntity)) continue;
                        int remainingInPortalTime = entity2.func_82145_z() - portalData.getInPortalTime();
                        Util.sendMessage((ServerPlayerEntity)entity2, (ITextComponent)teleportingInFunction.apply(new Object[]{Math.ceil((float)remainingInPortalTime / 2.0f) / 10.0}));
                        continue;
                    }
                    PortalSize portalSize = new PortalSize((IBlockReader)world, portalData.getPortalPos(), (Direction.Axis)world.func_180495_p(portalData.getPortalPos()).func_177229_b((Property)BlockStateProperties.field_208148_A));
                    PortalControllerTileEntity controller = (PortalControllerTileEntity)((Object)portalSize.getPortalController((IBlockReader)world).getLeft());
                    if (controller == null) {
                        if (entity2 instanceof ServerPlayerEntity) {
                            Util.sendMessage((ServerPlayerEntity)entity2, (ITextComponent)noPortalController);
                        }
                        return;
                    }
                    ItemStack portalControlItemStack = controller.getControlItemStack();
                    IPortalControlItem portalControlItem = null;
                    if (!portalControlItemStack.func_190926_b() && portalControlItemStack.func_77973_b() instanceof IPortalControlItem) {
                        portalControlItem = (IPortalControlItem)portalControlItemStack.func_77973_b();
                    }
                    if (portalControlItem == null) {
                        if (entity2 instanceof ServerPlayerEntity) {
                            Util.sendMessage((ServerPlayerEntity)entity2, (ITextComponent)noControlItem);
                        }
                        return;
                    }
                    Entity teleportedEntity = portalControlItem.teleportEntity(entity2, world, portalSize, portalControlItemStack);
                    if (!(teleportedEntity instanceof ServerPlayerEntity)) continue;
                    Util.sendMessage((ServerPlayerEntity)teleportedEntity, (ITextComponent)teleported);
                    continue;
                }
                portalData.decrementRemainingPortalCooldown();
                portalData.setInPortalTime(0);
            }
        }
    }
}

