/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.mrplibrary.datagen.providers;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import mrp_v2.mrplibrary.util.IModLocProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.IResource;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TextureProvider
implements IDataProvider,
IModLocProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static int ALPHA_MASK = -16777216;
    public final String modId;
    protected final ExistingFileHelper existingFileHelper;
    protected final DataGenerator generator;
    protected final Map<ResourceLocation, BufferedImage> providedTextures;
    protected final Map<ResourceLocation, TextureMetaBuilder> providedTextureMetas;

    public TextureProvider(DataGenerator generator, ExistingFileHelper existingFileHelper, String modId) {
        this.generator = generator;
        this.existingFileHelper = existingFileHelper;
        this.modId = modId;
        this.providedTextures = new HashMap<ResourceLocation, BufferedImage>();
        this.providedTextureMetas = new HashMap<ResourceLocation, TextureMetaBuilder>();
    }

    public static int color(int r, int g, int b) {
        Preconditions.checkArgument((r < 256 && r >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((g < 256 && g >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((b < 256 && b >= 0 ? 1 : 0) != 0);
        return TextureProvider.color(255, r, g, b);
    }

    public static int color(int a, int r, int g, int b) {
        Preconditions.checkArgument((a < 256 && a >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((r < 256 && r >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((g < 256 && g >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((b < 256 && b >= 0 ? 1 : 0) != 0);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void adjustLevels(BufferedImage texture, double levelAdjustment) {
        TextureProvider.adjustLevels(texture, texture.getMinTileX(), texture.getMinTileY(), texture.getTileWidth(), texture.getTileHeight(), levelAdjustment);
    }

    public static void adjustLevels(BufferedImage texture, int startX, int startY, int w, int h, double levelAdjustment) {
        TextureProvider.adjustLevels(texture, startX, startY, w, h, levelAdjustment, 0, 255, 0, 255);
    }

    public static void adjustLevels(BufferedImage texture, int startX, int startY, int w, int h, double levelAdjustment, int inLow, int inHigh, int outLow, int outHigh) {
        Preconditions.checkArgument((levelAdjustment > 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((inLow >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((inHigh <= 255 ? 1 : 0) != 0);
        Preconditions.checkArgument((inLow < inHigh ? 1 : 0) != 0);
        Preconditions.checkArgument((outLow >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((outHigh <= 255 ? 1 : 0) != 0);
        Preconditions.checkArgument((outLow < outHigh ? 1 : 0) != 0);
        for (int x = startX; x < startX + w; ++x) {
            for (int y = startY; y < startY + h; ++y) {
                int color = texture.getRGB(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                r = TextureProvider.adjustLevel(r, levelAdjustment, inLow, inHigh, outLow, outHigh);
                g = TextureProvider.adjustLevel(g, levelAdjustment, inLow, inHigh, outLow, outHigh);
                b = TextureProvider.adjustLevel(b, levelAdjustment, inLow, inHigh, outLow, outHigh);
                color = color & ALPHA_MASK | r << 16 | g << 8 | b;
                texture.setRGB(x, y, color);
            }
        }
    }

    protected static int adjustLevel(int i, double levelAdjustment, int inLow, int inHigh, int outLow, int outHigh) {
        if ((i -= inLow) < 0) {
            return outLow;
        }
        if (i + inLow >= inHigh) {
            return outHigh;
        }
        return TextureProvider.clampToByte((double)outLow + (double)(outHigh - outLow) * Math.pow((double)i / (double)(inHigh - inLow), levelAdjustment));
    }

    public static int clampToByte(double value) {
        return (int)Math.max(0.0, Math.min(255.0, value));
    }

    protected static int adjustLevel(int i, double levelAdjustment) {
        return TextureProvider.adjustLevel(i, levelAdjustment, 0, 255, 0, 255);
    }

    public static void adjustLevels(BufferedImage texture, double levelAdjustment, int inLow, int inHigh, int outLow, int outHigh) {
        TextureProvider.adjustLevels(texture, texture.getMinTileX(), texture.getMinTileY(), texture.getTileWidth(), texture.getTileHeight(), levelAdjustment, inLow, inHigh, outLow, outHigh);
    }

    public static void makeGrayscale(BufferedImage texture) {
        TextureProvider.makeGrayscale(texture, texture.getMinTileX(), texture.getMinTileY(), texture.getTileWidth(), texture.getTileHeight());
    }

    public static void makeGrayscale(BufferedImage texture, int startX, int startY, int w, int h) {
        for (int x = startX; x < startX + w; ++x) {
            for (int y = startY; y < startY + h; ++y) {
                int color = texture.getRGB(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int gray = (int)Math.round((double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114);
                color = color & ALPHA_MASK | gray << 16 | gray << 8 | gray;
                texture.setRGB(x, y, color);
            }
        }
    }

    public static void adjustHSB(BufferedImage texture, int hueChange, int saturation, int brightnessChange) {
        TextureProvider.adjustHSB(texture, texture.getMinTileX(), texture.getMinTileY(), texture.getTileWidth(), texture.getTileHeight(), hueChange, saturation, brightnessChange);
    }

    public static void adjustHSB(BufferedImage texture, int startX, int startY, int w, int h, int hueChange, int saturation, int brightnessChange) {
        float hueShift = (float)hueChange / 360.0f;
        int saturationFactor = saturation * 1024 / 100;
        int bWeight = Math.abs(brightnessChange) * 255 / 100;
        int cWeight = 255 - bWeight;
        int weightedB = (brightnessChange > 0 ? 255 : 0) * bWeight;
        for (int x = startX; x < startX + w; ++x) {
            for (int y = startY; y < startY + h; ++y) {
                Color color = new Color(texture.getRGB(x, y), true);
                int alpha = color.getAlpha();
                int intensity = TextureProvider.clampToByte(color.getRed() * 19595 + color.getGreen() * 38470 + color.getBlue() * 7471 >> 16);
                int r = TextureProvider.adjustSaturation(color.getRed(), intensity, saturationFactor);
                int g = TextureProvider.adjustSaturation(color.getGreen(), intensity, saturationFactor);
                int b = TextureProvider.adjustSaturation(color.getBlue(), intensity, saturationFactor);
                float[] hsb = Color.RGBtoHSB(r, g, b, null);
                hsb[0] = hsb[0] + hueShift;
                int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
                color = new Color(rgb);
                r = TextureProvider.adjustBrightness(color.getRed(), cWeight, weightedB);
                g = TextureProvider.adjustBrightness(color.getGreen(), cWeight, weightedB);
                b = TextureProvider.adjustBrightness(color.getBlue(), cWeight, weightedB);
                color = new Color(r, g, b, alpha);
                texture.setRGB(x, y, color.getRGB());
            }
        }
    }

    public static int clampToByte(int value) {
        return Math.max(0, Math.min(255, value));
    }

    protected static int adjustSaturation(int i, int intensity, int saturationFactor) {
        return TextureProvider.clampToByte(intensity * 1024 + (i - intensity) * saturationFactor >> 10);
    }

    protected static int adjustBrightness(int i, int iWeight, int weightedB) {
        return (i * iWeight + weightedB) / 256;
    }

    public static int[] color(int color, int length) {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = color;
        }
        return array;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    public void func_200398_a(final DirectoryCache cache) {
        this.addTextures(new FinishedTextureConsumer(){

            @Override
            void accept(Texture texture, ResourceLocation id) {
                BufferedImage immutableTexture = TextureProvider.copyTexture(texture.texture);
                if (TextureProvider.this.providedTextures.put(id, immutableTexture) != null) {
                    throw new IllegalStateException("Duplicate texture " + id);
                }
                TextureProvider.this.saveTexture(cache, immutableTexture, TextureProvider.this.getTexturePath(id));
                if (texture.textureMetaBuilder != null) {
                    TextureMetaBuilder immutableMetaData = texture.textureMetaBuilder.copy();
                    if (TextureProvider.this.providedTextureMetas.put(id, immutableMetaData) != null) {
                        throw new IllegalStateException("Duplicate texture metadata " + id);
                    }
                    TextureProvider.this.saveTextureMeta(cache, immutableMetaData, TextureProvider.this.getTextureMetaPath(id));
                }
            }
        });
    }

    public String func_200397_b() {
        return "Textures: " + this.modId;
    }

    protected abstract void addTextures(FinishedTextureConsumer var1);

    protected void saveTextureMeta(DirectoryCache cache, TextureMetaBuilder metaBuilder, Path path) {
        String json = GSON.toJson((JsonElement)metaBuilder.toJson());
        String hash = field_208307_a.hashUnencodedChars((CharSequence)json).toString();
        if (!Objects.equals(cache.func_208323_a(path), hash) || !Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException ioException) {
                LOGGER.error("Couldn't create directory for texture {}", (Object)path, (Object)ioException);
            }
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                bufferedWriter.write(json);
            }
            catch (IOException ioException) {
                LOGGER.error("Couldn't save metadata for texture {}", (Object)path, (Object)ioException);
            }
        }
        cache.func_208316_a(path, hash);
    }

    protected Path getTexturePath(ResourceLocation texture) {
        return this.generator.func_200391_b().resolve("assets/" + texture.func_110624_b() + "/textures/" + texture.func_110623_a() + ".png");
    }

    protected void saveTexture(DirectoryCache cache, BufferedImage texture, Path path) {
        Hasher hasher = field_208307_a.newHasher();
        for (int i : texture.getRGB(0, 0, texture.getWidth(), texture.getHeight(), null, 0, texture.getWidth())) {
            hasher.putInt(i);
        }
        String hash = hasher.hash().toString();
        if (!Objects.equals(cache.func_208323_a(path), hash) || !Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException ioException) {
                LOGGER.error("Couldn't create directory for texture {}", (Object)path, (Object)ioException);
            }
            try {
                ImageIO.write((RenderedImage)texture, "png", path.toFile());
            }
            catch (IOException ioException) {
                LOGGER.error("Couldn't save texture {}", (Object)path, (Object)ioException);
            }
        }
        cache.func_208316_a(path, hash);
    }

    protected static BufferedImage copyTexture(BufferedImage texture) {
        ColorModel colorModel = texture.getColorModel();
        boolean isAlphaPremultiplied = colorModel.isAlphaPremultiplied();
        WritableRaster raster = texture.copyData(texture.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(colorModel, raster, isAlphaPremultiplied, null);
    }

    protected Path getTextureMetaPath(ResourceLocation texture) {
        return this.generator.func_200391_b().resolve("assets/" + texture.func_110624_b() + "/textures/" + texture.func_110623_a() + ".png.mcmeta");
    }

    public void finish(Texture texture, ResourceLocation id, FinishedTextureConsumer consumer) {
        consumer.accept(texture, id);
    }

    public Texture getTexture(ResourceLocation textureLoc) {
        return new Texture(this.getRawTexture(textureLoc), this.tryGetTextureMeta(textureLoc));
    }

    public Optional<TextureMetaBuilder> tryGetTextureMeta(ResourceLocation textureLoc) {
        if (this.providedTextureMetas.containsKey(textureLoc)) {
            return Optional.of(this.providedTextureMetas.get(textureLoc).copy());
        }
        ResourceLocation loc = new ResourceLocation(textureLoc.func_110624_b(), "textures/" + textureLoc.func_110623_a() + ".png.mcmeta");
        if (this.existingFileHelper.exists(loc, ResourcePackType.CLIENT_RESOURCES)) {
            try {
                IResource resource = this.existingFileHelper.getResource(loc, ResourcePackType.CLIENT_RESOURCES);
                return Optional.of(TextureMetaBuilder.fromInputStream(resource.func_199027_b()));
            }
            catch (IOException ioException) {
                LOGGER.error(String.format("Couldn't read texture metadata %s", textureLoc), (Throwable)ioException);
            }
        }
        return Optional.empty();
    }

    protected BufferedImage getRawTexture(ResourceLocation textureLoc) {
        if (this.providedTextures.containsKey(textureLoc)) {
            return TextureProvider.copyTexture(this.providedTextures.get(textureLoc));
        }
        ResourceLocation loc = new ResourceLocation(textureLoc.func_110624_b(), "textures/" + textureLoc.func_110623_a() + ".png");
        Preconditions.checkArgument((boolean)this.existingFileHelper.exists(loc, ResourcePackType.CLIENT_RESOURCES), (String)"Texture %s does not exist in any known resource pack", (Object)loc);
        try {
            IResource resource = this.existingFileHelper.getResource(loc, ResourcePackType.CLIENT_RESOURCES);
            return ImageIO.read(resource.func_199027_b());
        }
        catch (IOException ioException) {
            throw new RuntimeException(String.format("Error while reading texture %s", textureLoc), ioException);
        }
    }

    public void promiseGeneration(ResourceLocation texture) {
        this.existingFileHelper.trackGenerated(texture, ResourcePackType.CLIENT_RESOURCES, ".png", "textures");
    }

    public static abstract class FinishedTextureConsumer {
        abstract void accept(Texture var1, ResourceLocation var2);
    }

    public static class TextureMetaBuilder {
        protected Optional<Boolean> interpolate = Optional.empty();
        protected Optional<Integer> frameTime = Optional.empty();
        protected Optional<int[]> frames = Optional.empty();

        @Nullable
        public static TextureMetaBuilder fromInputStream(InputStream inputStream) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            JsonObject json = JSONUtils.func_151210_l((JsonElement)((JsonElement)JSONUtils.func_193839_a((Gson)GSON, (Reader)bufferedReader, JsonElement.class)), (String)"top element");
            if (json.has("animation")) {
                JsonObject animationJson = json.getAsJsonObject("animation");
                TextureMetaBuilder metaBuilder = new TextureMetaBuilder();
                if (animationJson.has("interpolate")) {
                    metaBuilder.interpolate = Optional.of(animationJson.get("interpolate").getAsBoolean());
                }
                if (animationJson.has("frametime")) {
                    metaBuilder.frameTime = Optional.of(animationJson.get("frametime").getAsInt());
                }
                if (animationJson.has("frames")) {
                    JsonArray framesJson = animationJson.getAsJsonArray("frames");
                    int[] framesArray = new int[framesJson.size()];
                    int i = 0;
                    for (JsonElement element : framesJson) {
                        framesArray[i++] = element.getAsInt();
                    }
                    metaBuilder.frames = Optional.of(framesArray);
                }
                return metaBuilder;
            }
            return null;
        }

        public TextureMetaBuilder copy() {
            TextureMetaBuilder metaBuilder = new TextureMetaBuilder();
            metaBuilder.interpolate = this.interpolate;
            metaBuilder.frameTime = this.frameTime;
            metaBuilder.frames = this.frames;
            return metaBuilder;
        }

        public TextureMetaBuilder setInterpolate(boolean interpolate) {
            this.interpolate = Optional.of(interpolate);
            return this;
        }

        public TextureMetaBuilder setFrameTime(int frameTime) {
            this.frameTime = Optional.of(frameTime);
            return this;
        }

        public TextureMetaBuilder setFrames(int[] frames) {
            this.frames = Optional.of(frames);
            return this;
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            JsonObject animation = new JsonObject();
            json.add("animation", (JsonElement)animation);
            this.interpolate.ifPresent(interpolate -> animation.addProperty("interpolate", interpolate));
            this.frameTime.ifPresent(frameTime -> animation.addProperty("frametime", (Number)frameTime));
            this.frames.ifPresent(frames -> {
                JsonArray framesJson = new JsonArray();
                for (int frame : frames) {
                    framesJson.add((Number)frame);
                }
                animation.add("frames", (JsonElement)framesJson);
            });
            return json;
        }
    }

    public static class Texture {
        protected BufferedImage texture;
        @Nullable
        protected TextureMetaBuilder textureMetaBuilder;

        public Texture(BufferedImage texture, Optional<TextureMetaBuilder> textureMetaBuilder) {
            this(texture, (TextureMetaBuilder)textureMetaBuilder.orElse(null));
        }

        private Texture(BufferedImage texture, @Nullable TextureMetaBuilder textureMetaBuilder) {
            this.texture = texture;
            this.textureMetaBuilder = textureMetaBuilder;
        }

        public BufferedImage getTexture() {
            return this.texture;
        }

        public void setTexture(BufferedImage texture) {
            this.texture = texture;
        }

        public Texture copy() {
            return new Texture(TextureProvider.copyTexture(this.texture), this.textureMetaBuilder == null ? null : this.textureMetaBuilder.copy());
        }

        @Nullable
        public TextureMetaBuilder getTextureMetaBuilder() {
            return this.textureMetaBuilder;
        }

        public void setTextureMetaBuilder(@Nullable TextureMetaBuilder textureMetaBuilder) {
            this.textureMetaBuilder = textureMetaBuilder;
        }
    }
}

