/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.mrplibrary.datagen.providers.util;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class ModelJsonParser {
    private static final JsonParser PARSER = new JsonParser();
    BlockModelProvider models;

    public ModelJsonParser(BlockModelProvider models) {
        this.models = models;
    }

    @Nullable
    public ModelBuilder<BlockModelBuilder> buildBlockModel(ResourceLocation model, ResourceLocation newModel) {
        JsonElement json;
        model = new ResourceLocation(model.func_110624_b(), "models/block/" + model.func_110623_a() + ".json");
        Preconditions.checkArgument((boolean)this.models.existingFileHelper.exists(model, ResourcePackType.CLIENT_RESOURCES), (String)"Model %s does not exist in any known resource pack", (Object)model);
        try {
            IResource resource = this.models.existingFileHelper.getResource(model, ResourcePackType.CLIENT_RESOURCES);
            json = PARSER.parse((Reader)new InputStreamReader(resource.func_199027_b()));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error while reading model %s", model), e);
        }
        ModelBuilder modelBuilder = this.models.getBuilder(newModel.toString());
        this.consumeJson((ModelBuilder<BlockModelBuilder>)modelBuilder, json);
        return modelBuilder;
    }

    private void consumeJson(ModelBuilder<BlockModelBuilder> modelBuilder, JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject obj = jsonElement.getAsJsonObject();
            for (Map.Entry entry : obj.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "parent": {
                        modelBuilder.parent((ModelFile)this.models.getExistingFile(new ResourceLocation(((JsonElement)entry.getValue()).getAsString())));
                        break;
                    }
                    case "ambientocclusion": {
                        modelBuilder.ao(((JsonElement)entry.getValue()).getAsBoolean());
                        break;
                    }
                    case "display": {
                        this.consumeDisplayJson(modelBuilder.transforms(), ((JsonElement)entry.getValue()).getAsJsonObject());
                        break;
                    }
                    case "textures": {
                        this.consumeTexturesJson(modelBuilder, ((JsonElement)entry.getValue()).getAsJsonObject());
                        break;
                    }
                    case "elements": {
                        this.consumeElementsJson(modelBuilder, ((JsonElement)entry.getValue()).getAsJsonArray());
                    }
                }
            }
        }
    }

    private void consumeDisplayJson(ModelBuilder.TransformsBuilder modelDisplayBuilder, JsonObject displayJson) {
        for (Map.Entry entry : displayJson.entrySet()) {
            ModelBuilder.Perspective perspective = null;
            switch ((String)entry.getKey()) {
                case "thirdperson_righthand": {
                    perspective = ModelBuilder.Perspective.THIRDPERSON_RIGHT;
                    break;
                }
                case "thirdperson_lefthand": {
                    perspective = ModelBuilder.Perspective.THIRDPERSON_LEFT;
                    break;
                }
                case "firstperson_righthand": {
                    perspective = ModelBuilder.Perspective.FIRSTPERSON_RIGHT;
                    break;
                }
                case "firstperson_lefthand": {
                    perspective = ModelBuilder.Perspective.FIRSTPERSON_LEFT;
                    break;
                }
                case "head": {
                    perspective = ModelBuilder.Perspective.HEAD;
                    break;
                }
                case "gui": {
                    perspective = ModelBuilder.Perspective.GUI;
                    break;
                }
                case "ground": {
                    perspective = ModelBuilder.Perspective.GROUND;
                    break;
                }
                case "fixed": {
                    perspective = ModelBuilder.Perspective.FIXED;
                }
            }
            this.consumeDisplayTransformJson(modelDisplayBuilder.transform(perspective), ((JsonElement)entry.getValue()).getAsJsonObject());
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private void consumeDisplayTransformJson(ModelBuilder.TransformsBuilder.TransformVecBuilder modelDisplayTransformBuilder, JsonObject displayTransformJson) {
        for (Map.Entry entry : displayTransformJson.entrySet()) {
            JsonArray jsonArray = ((JsonElement)entry.getValue()).getAsJsonArray();
            switch ((String)entry.getKey()) {
                case "rotation": {
                    modelDisplayTransformBuilder.rotation(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat());
                    break;
                }
                case "translation": {
                    modelDisplayTransformBuilder.translation(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat());
                    break;
                }
                case "scale": {
                    modelDisplayTransformBuilder.scale(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat());
                }
            }
        }
    }

    private void consumeTexturesJson(ModelBuilder<BlockModelBuilder> modelBuilder, JsonObject texturesJson) {
        for (Map.Entry entry : texturesJson.entrySet()) {
            modelBuilder.texture((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
    }

    private void consumeElementsJson(ModelBuilder<BlockModelBuilder> modelBuilder, JsonArray elementsJson) {
        for (JsonElement elementElement : elementsJson) {
            ModelBuilder.ElementBuilder elementBuilder = modelBuilder.element();
            JsonObject elementJson = elementElement.getAsJsonObject();
            for (Map.Entry entry : elementJson.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "from": {
                        JsonArray jsonArray = ((JsonElement)entry.getValue()).getAsJsonArray();
                        elementBuilder.from(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat());
                        break;
                    }
                    case "to": {
                        JsonArray jsonArray = ((JsonElement)entry.getValue()).getAsJsonArray();
                        elementBuilder.to(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat());
                        break;
                    }
                    case "rotation": {
                        this.consumeElementRotationJson(elementBuilder.rotation(), ((JsonElement)entry.getValue()).getAsJsonObject());
                        break;
                    }
                    case "shade": {
                        elementBuilder.shade(((JsonElement)entry.getValue()).getAsBoolean());
                        break;
                    }
                    case "faces": {
                        this.consumeElementFacesJson(elementBuilder, ((JsonElement)entry.getValue()).getAsJsonObject());
                    }
                }
            }
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private void consumeElementRotationJson(ModelBuilder.ElementBuilder.RotationBuilder modelElementRotationBuilder, JsonObject elementRotationJson) {
        for (Map.Entry entry : elementRotationJson.entrySet()) {
            switch ((String)entry.getKey()) {
                case "origin": {
                    JsonArray jsonArray = ((JsonElement)entry.getValue()).getAsJsonArray();
                    modelElementRotationBuilder.origin(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat());
                    break;
                }
                case "axis": {
                    modelElementRotationBuilder.axis(Direction.Axis.valueOf((String)((JsonElement)entry.getValue()).getAsString()));
                    break;
                }
                case "angle": {
                    modelElementRotationBuilder.angle(((JsonElement)entry.getValue()).getAsFloat());
                    break;
                }
                case "rescale": {
                    modelElementRotationBuilder.rescale(((JsonElement)entry.getValue()).getAsBoolean());
                }
            }
        }
    }

    private void consumeElementFacesJson(ModelBuilder.ElementBuilder modelElementsBuilder, JsonObject elementFacesJson) {
        for (Map.Entry face : elementFacesJson.entrySet()) {
            ModelBuilder.ElementBuilder.FaceBuilder faceBuilder = modelElementsBuilder.face(Direction.func_176739_a((String)((String)face.getKey())));
            for (Map.Entry facePart : ((JsonElement)face.getValue()).getAsJsonObject().entrySet()) {
                switch ((String)facePart.getKey()) {
                    case "uv": {
                        JsonArray jsonArray = ((JsonElement)facePart.getValue()).getAsJsonArray();
                        faceBuilder.uvs(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat(), jsonArray.get(2).getAsFloat(), jsonArray.get(3).getAsFloat());
                        break;
                    }
                    case "texture": {
                        faceBuilder.texture(((JsonElement)facePart.getValue()).getAsString());
                        break;
                    }
                    case "cullface": {
                        faceBuilder.cullface(Direction.func_176739_a((String)((JsonElement)facePart.getValue()).getAsString()));
                        break;
                    }
                    case "rotation": {
                        ModelBuilder.FaceRotation rotation = null;
                        switch (((JsonElement)facePart.getValue()).getAsInt()) {
                            case 0: {
                                rotation = ModelBuilder.FaceRotation.ZERO;
                                break;
                            }
                            case 90: {
                                rotation = ModelBuilder.FaceRotation.CLOCKWISE_90;
                                break;
                            }
                            case 180: {
                                rotation = ModelBuilder.FaceRotation.UPSIDE_DOWN;
                                break;
                            }
                            case 270: {
                                rotation = ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90;
                            }
                        }
                        faceBuilder.rotation(rotation);
                        break;
                    }
                    case "tintindex": {
                        faceBuilder.tintindex(((JsonElement)facePart.getValue()).getAsInt());
                    }
                }
            }
        }
    }
}

