/*
 * Decompiled with CFR 0.152.
 */
package forge.genandnic.walljump.logic;

import dev.architectury.networking.NetworkManager;
import forge.genandnic.walljump.WallJump;
import forge.genandnic.walljump.config.WallJumpConfig;
import forge.genandnic.walljump.logic.Logic;
import forge.genandnic.walljump.registry.WallJumpKeyMappings;
import forge.genandnic.walljump.registry.WallJumpServerReceivers;
import forge.genandnic.walljump.util.IWallJumpAccessor;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.phys.Vec3;

public class WallJumpLogic
extends Logic
implements IWallJumpAccessor {
    private static double clingX;
    private static double clingZ;
    public static double lastJumpY;
    public static Set<Direction> walls;
    public static Set<Direction> staleWalls;

    public static void doWallJump() {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        assert (pl != null);
        int ticksKeyDown = 0;
        if (!IWallJumpAccessor.getWallJumpEligibility() || !WallJumpConfig.isModUsable(pl.m_9236_())) {
            return;
        }
        if (pl.m_20096_() || pl.m_150110_().f_35935_ || !pl.m_9236_().m_6425_(pl.m_20183_()).m_76178_() || pl.m_20159_()) {
            ticksWallClinged = 0;
            clingX = Double.NaN;
            clingZ = Double.NaN;
            lastJumpY = Double.MAX_VALUE;
            staleWalls.clear();
            return;
        }
        IWallJumpAccessor.updateWalls();
        if (WallJumpConfig.getConfigEntries().enableClassicWallCling) {
            ticksKeyDown = pl.f_108618_.f_108573_ ? ticksKeyDown + 1 : 0;
        } else {
            int n = ticksKeyDown = WallJumpKeyMappings.toggleWallJump ? ticksKeyDown + 1 : 0;
        }
        if (ticksWallClinged < 1) {
            if (ticksKeyDown > 0 && ticksKeyDown < 4 && !walls.isEmpty() && !pl.m_20096_() && IWallJumpAccessor.getWallClingEligibility()) {
                pl.f_20924_ = 2.5f;
                pl.f_20923_ = 2.5f;
                if (WallJumpConfig.getConfigEntries().enableAutoRotation) {
                    pl.m_146922_(IWallJumpAccessor.getWallClingDirection().m_122424_().m_122435_());
                    pl.f_19859_ = pl.m_146908_();
                }
                ticksWallClinged = 1;
                clingX = pl.m_20182_().f_82479_;
                clingZ = pl.m_20182_().f_82481_;
                IWallJumpAccessor.playHitSound(IWallJumpAccessor.getWallPos());
                IWallJumpAccessor.spawnWallParticle(IWallJumpAccessor.getWallPos());
            }
            return;
        }
        if (IWallJumpAccessor.getClassicWallJumpEligibility() || pl.m_20096_() || !pl.m_9236_().m_6425_(pl.m_20183_()).m_76178_() || walls.isEmpty() || pl.m_36324_().m_38702_() < 1) {
            ticksWallClinged = 0;
            if (!(pl.f_108618_.f_108567_ == 0.0f && pl.f_108618_.f_108566_ == 0.0f || pl.m_20096_() || walls.isEmpty())) {
                pl.m_183634_();
                FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
                packet.writeBoolean(true);
                NetworkManager.sendToServer((ResourceLocation)WallJump.WALL_JUMP_PACKET_ID, (FriendlyByteBuf)packet);
                WallJumpLogic.doWallClingJump((float)WallJumpConfig.getConfigEntries().heightWallJump);
                staleWalls = new HashSet<Direction>(walls);
            }
            return;
        }
        if (WallJumpConfig.getConfigEntries().enableAutoRotation) {
            pl.m_146922_(IWallJumpAccessor.getWallClingDirection().m_122424_().m_122435_());
            pl.f_19859_ = pl.m_146908_();
        }
        pl.m_6034_(clingX, pl.m_20182_().f_82480_, clingZ);
        double motionY = pl.m_20184_().f_82480_;
        if (motionY > 0.0) {
            motionY = 0.0;
        } else if (motionY < -0.6) {
            motionY += 0.2;
            IWallJumpAccessor.spawnWallParticle(IWallJumpAccessor.getWallPos());
        } else if (ticksWallClinged++ > WallJumpConfig.getConfigEntries().delayWallClingSlide) {
            motionY = -0.1;
            IWallJumpAccessor.spawnWallParticle(IWallJumpAccessor.getWallPos());
        } else {
            motionY = 0.0;
        }
        if (pl.f_19789_ > 2.0f) {
            pl.m_183634_();
            WallJumpServerReceivers.sendFallDistanceMessage(pl.f_19789_);
        }
        pl.m_20334_(0.0, motionY, 0.0);
    }

    private static void doWallClingJump(float up) {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        assert (pl != null);
        float strafe = Math.signum(pl.f_108618_.f_108566_) * up * up;
        float forward = Math.signum(pl.f_108618_.f_108567_) * up * up;
        float f = 1.0f / Mth.m_14116_((float)(strafe * strafe + up * up + forward * forward));
        strafe *= f;
        forward *= f;
        float f1 = Mth.m_14031_((float)(pl.m_6080_() * ((float)Math.PI / 180))) * 0.45f;
        float f2 = Mth.m_14089_((float)(pl.m_6080_() * ((float)Math.PI / 180))) * 0.45f;
        int jumpBoostLevel = 0;
        MobEffectInstance jumpBoostEffect = pl.m_21124_(MobEffects.f_19603_);
        if (jumpBoostEffect != null) {
            jumpBoostLevel = jumpBoostEffect.m_19564_() + 1;
        }
        Vec3 motion = pl.m_20184_();
        pl.m_20334_(motion.m_7096_() + (double)(strafe * f2 - forward * f1), (double)up + (double)jumpBoostLevel * 0.125, motion.m_7094_() + (double)(forward * f2 + strafe * f1));
        lastJumpY = pl.m_20182_().f_82480_;
        IWallJumpAccessor.playBreakSound(IWallJumpAccessor.getWallPos());
        IWallJumpAccessor.spawnWallParticle(IWallJumpAccessor.getWallPos());
    }

    static {
        lastJumpY = Double.MAX_VALUE;
        walls = new HashSet<Direction>();
        staleWalls = new HashSet<Direction>();
    }
}

