/*
 * Decompiled with CFR 0.152.
 */
package quilt.genandnic.walljump.registry;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import quilt.genandnic.walljump.WallJump;
import quilt.genandnic.walljump.config.WallJumpConfig;

public class WallJumpServerReceivers {
    public static boolean serverConfigSynced;

    public static void registerServerReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (class_2960)WallJump.WALL_JUMP_PACKET_ID, (buf, context) -> {
            class_1657 pl = context.getPlayer();
            boolean didWallJump = buf.readBoolean();
            if (didWallJump) {
                pl.method_7322((float)WallJumpConfig.getConfigEntries().exhaustionWallJump);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (class_2960)WallJump.DOUBLE_JUMP_PACKET_ID, (buf, context) -> {
            class_1657 pl = context.getPlayer();
            boolean didDoubleJump = buf.readBoolean();
            if (didDoubleJump) {
                pl.method_7322((float)WallJumpConfig.getConfigEntries().exhaustionDoubleJump * (float)WallJumpConfig.getConfigEntries().exhaustionDoubleJumpMultiplier);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (class_2960)WallJump.FALL_DISTANCE_PACKET_ID, (buf, context) -> {
            class_1657 pl = context.getPlayer();
            if (pl != null) {
                pl.field_6017 = buf.readFloat();
            }
        });
    }

    public static void registerClientReceivers() {
        IntFunction<List> i = x -> Collections.singletonList(Integer.toString(x));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)WallJump.SERVER_CONFIG_PACKET_ID, (buf, context) -> {
            WallJumpConfig.getConfigEntries().enableWallJump = buf.readBoolean();
            if (!WallJumpConfig.getConfigEntries().blockBlacklist.isEmpty()) {
                WallJumpConfig.getConfigEntries().blockBlacklist = (List)buf.method_34068(i, class_2540::method_19772);
            }
            WallJumpConfig.getConfigEntries().enableElytraWallCling = buf.readBoolean();
            WallJumpConfig.getConfigEntries().enableClassicWallCling = buf.readBoolean();
            WallJumpConfig.getConfigEntries().enableReclinging = buf.readBoolean();
            WallJumpConfig.getConfigEntries().enableAutoRotation = buf.readBoolean();
            WallJumpConfig.getConfigEntries().heightWallJump = buf.readDouble();
            WallJumpConfig.getConfigEntries().delayWallClingSlide = buf.readInt();
            WallJumpConfig.getConfigEntries().exhaustionWallJump = buf.readDouble();
            WallJumpConfig.getConfigEntries().enableDoubleJump = buf.readBoolean();
            WallJumpConfig.getConfigEntries().countDoubleJump = buf.readInt();
            WallJumpConfig.getConfigEntries().exhaustionDoubleJump = buf.readDouble();
            WallJumpConfig.getConfigEntries().exhaustionDoubleJumpMultiplier = buf.readDouble();
            WallJumpConfig.getConfigEntries().playFallingSound = buf.readBoolean();
            WallJumpConfig.getConfigEntries().minFallDistance = buf.readDouble();
            WallJumpConfig.getConfigEntries().elytraSpeedBoost = buf.readDouble();
            WallJumpConfig.getConfigEntries().sprintSpeedBoost = buf.readDouble();
            WallJumpConfig.getConfigEntries().enableStepAssist = buf.readBoolean();
            System.out.println("[Wall-Jump! UNOFFICIAL] Server Config has been received and synced on Client!");
            serverConfigSynced = true;
        });
    }

    public static void sendFallDistanceMessage(float f) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.writeFloat(f);
        NetworkManager.sendToServer((class_2960)WallJump.FALL_DISTANCE_PACKET_ID, (class_2540)packet);
    }
}

