/*
 * Decompiled with CFR 0.152.
 */
package forge.genandnic.walljump.util;

import forge.genandnic.walljump.config.WallJumpConfig;
import forge.genandnic.walljump.logic.Logic;
import forge.genandnic.walljump.logic.WallJumpLogic;
import forge.genandnic.walljump.registry.WallJumpEnchantments;
import forge.genandnic.walljump.registry.WallJumpKeyMappings;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface IWallJumpHelper {
    public static boolean getClassicWallJumpEligibility() {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        return WallJumpConfig.getConfigEntries().enableClassicWallCling ? !pl.f_108618_.f_108573_ : !WallJumpKeyMappings.toggleWallJump;
    }

    public static boolean getWallJumpEligibility() {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        if (WallJumpConfig.getConfigEntries().enableWallJump) {
            return true;
        }
        ItemStack stack = pl.m_6844_(EquipmentSlot.FEET);
        if (!stack.m_41619_()) {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
            return enchantments.containsKey((Object)WallJumpEnchantments.WALLJUMP_ENCHANTMENT);
        }
        return false;
    }

    public static boolean getWallClingEligibility() {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        boolean bl1 = pl.m_21255_() && !WallJumpConfig.getConfigEntries().enableElytraWallCling;
        boolean bl2 = pl.m_20145_() && !WallJumpConfig.getConfigEntries().enableInvisibleWallCling;
        BlockState blockState = pl.m_183503_().m_8055_(IWallJumpHelper.getWallPos());
        for (String block : WallJumpConfig.getConfigEntries().blockBlacklist) {
            if (!blockState.m_60734_().m_7705_().contains(block.toLowerCase())) continue;
            return false;
        }
        if (pl.m_6147_() || pl.m_20184_().f_82480_ > 0.1 || pl.m_36324_().m_38702_() < 1 || bl1 || bl2) {
            return false;
        }
        if (!pl.m_183503_().m_45772_(pl.m_142469_().m_82386_(0.0, -0.8, 0.0))) {
            return false;
        }
        if (WallJumpConfig.getConfigEntries().enableReclinging || pl.m_20182_().f_82480_ < WallJumpLogic.lastJumpY - 1.0) {
            return true;
        }
        return !WallJumpLogic.staleWalls.containsAll(WallJumpLogic.walls);
    }

    public static Direction getWallClingDirection() {
        return WallJumpLogic.walls.isEmpty() ? Direction.UP : WallJumpLogic.walls.iterator().next();
    }

    public static BlockPos getWallPos() {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        BlockPos clingPos = pl.m_142538_().m_142300_(IWallJumpHelper.getWallClingDirection());
        return pl.m_183503_().m_8055_(clingPos).m_60767_().m_76333_() ? clingPos : clingPos.m_142300_(Direction.UP);
    }

    public static void updateWalls() {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        AABB box = new AABB(pl.m_20185_() - 0.001, pl.m_20186_(), pl.m_20189_() - 0.001, pl.m_20185_() + 0.001, pl.m_20186_() + (double)pl.m_20192_(), pl.m_20189_() + 0.001);
        double dist = (double)(pl.m_20205_() / 2.0f) + (Logic.ticksWallClinged > 0 ? 0.1 : 0.06);
        AABB[] axes = new AABB[]{box.m_82363_(0.0, 0.0, dist), box.m_82363_(-dist, 0.0, 0.0), box.m_82363_(0.0, 0.0, -dist), box.m_82363_(dist, 0.0, 0.0)};
        int i = 0;
        WallJumpLogic.walls = new HashSet<Direction>();
        for (AABB axis : axes) {
            Direction direction = Direction.m_122407_((int)i++);
            if (pl.m_183503_().m_45772_(axis)) continue;
            WallJumpLogic.walls.add(direction);
            pl.f_19862_ = true;
        }
    }

    public static void spawnWallParticle(BlockPos blockPos) {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        BlockState blockState = pl.m_183503_().m_8055_(blockPos);
        if (blockState.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 pos = pl.m_20182_();
            Vec3i motion = IWallJumpHelper.getWallClingDirection().m_122436_();
            pl.m_183503_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)motion.m_123341_() * -1.0, -1.0, (double)motion.m_123343_() * -1.0);
        }
    }

    public static void playBreakSound(BlockPos blockPos) {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        BlockState blockState = pl.m_183503_().m_8055_(blockPos);
        SoundType soundType = blockState.m_60734_().m_49962_(blockState);
        pl.m_5496_(soundType.m_56779_(), soundType.m_56773_() * 0.5f, soundType.m_56774_());
    }

    public static void playHitSound(BlockPos blockPos) {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        BlockState blockState = pl.m_183503_().m_8055_(blockPos);
        SoundType soundType = blockState.m_60734_().m_49962_(blockState);
        pl.m_5496_(soundType.m_56778_(), soundType.m_56773_() * 0.25f, soundType.m_56774_());
    }

    public static int getEquipmentBoost(EquipmentSlot slot) {
        Map enchantments;
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        ItemStack stack = pl.m_6844_(slot);
        if (!stack.m_41619_() && (enchantments = EnchantmentHelper.m_44831_((ItemStack)stack)).containsKey((Object)WallJumpEnchantments.SPEEDBOOST_ENCHANTMENT)) {
            return (Integer)enchantments.get((Object)WallJumpEnchantments.SPEEDBOOST_ENCHANTMENT);
        }
        return 0;
    }

    public static int getJumpCount() {
        Map enchantments;
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        int jumpCount = 0;
        if (WallJumpConfig.getConfigEntries().enableDoubleJump) {
            jumpCount += WallJumpConfig.getConfigEntries().countDoubleJump;
        }
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        ItemStack stack = pl.m_6844_(EquipmentSlot.FEET);
        if (!stack.m_41619_() && (enchantments = EnchantmentHelper.m_44831_((ItemStack)stack)).containsKey((Object)WallJumpEnchantments.DOUBLEJUMP_ENCHANTMENT)) {
            jumpCount += ((Integer)enchantments.get((Object)WallJumpEnchantments.DOUBLEJUMP_ENCHANTMENT)).intValue();
        }
        return jumpCount;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

