/*
 * Decompiled with CFR 0.152.
 */
package forge.genandnic.walljump.config;

import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.world.item.enchantment.Enchantment;

@Config(name="walljump")
public class WallJumpConfigEntries
implements ConfigData {
    @Comment(value="Allows you to wall cling and wall jump.")
    public boolean enableWallJump = true;
    @Comment(value="If you disable Wall Jump, it enables the enchantment automagically, this option disables the enchantment.")
    @ConfigEntry.Gui.RequiresRestart
    public boolean enableWallJumpEnchantment = false;
    @Comment(value="The rarity for Wall-Jump! Enchant, i.e. how often it appears in enchanting table, etc.")
    @ConfigEntry.Gui.RequiresRestart
    public Enchantment.Rarity wallJumpEnchantmentRarity = Enchantment.Rarity.UNCOMMON;
    @Comment(value="Blacklists blocks inputted; can't Wall Jump off it, format is '(mod name or minecraft).(name)', use underscores as spaces")
    public List<String> blockBlacklist = List.of();
    @Comment(value="Enables Elytra Wall Cling: Clinging to the Wall with Elytra Deployed.")
    public boolean enableElytraWallCling = false;
    @Comment(value="Enables Invisible Wall Cling: Clinging to the Wall whilst Invisible.")
    public boolean enableInvisibleWallCling = false;
    @Comment(value="Classic Wall Cling which allows Crouch, the reason this can't be keybinded is because Fabric doesn't support Multi Mapping.")
    @ConfigEntry.Gui.RequiresRestart
    public boolean enableClassicWallCling = false;
    @Comment(value="Allows you to climb up without alternating walls.")
    public boolean enableReclinging = false;
    @Comment(value="Automagically turn the player when wall clinging.")
    public boolean enableAutoRotation = false;
    @Comment(value="Height of Wall Jumps")
    public double heightWallJump = 0.55;
    @Comment(value="Ticks wall clinged before starting wall slide.")
    public int delayWallClingSlide = 35;
    @Comment(value="Exhaustion gained per wall jump.")
    public double exhaustionWallJump = 0.8;
    @Comment(value="Allows you to jump in mid-air")
    public boolean enableDoubleJump = true;
    @Comment(value="The rarity for Double Jump Enchant, i.e. how often it appears in enchanting table, etc.")
    @ConfigEntry.Gui.RequiresRestart
    public boolean enableDoubleJumpEnchantment = false;
    @Comment(value="If you disable Wall Jump, it enables the enchantment automagically, this option disables the enchantment.")
    @ConfigEntry.Gui.RequiresRestart
    public Enchantment.Rarity doubleJumpEnchantmentRarity = Enchantment.Rarity.RARE;
    @Comment(value="Changes the Jump Count for Double Jump so you can instead have a Triple Jump or even a Quadruple Jump.")
    @ConfigEntry.Gui.RequiresRestart
    public int countDoubleJump = 1;
    @Comment(value="Exhaustion gained per jump of doublejump.")
    public double exhaustionDoubleJump = 1.2;
    @Comment(value="Multiplier for Exhaustion gained per jump of doublejump (ONLY IF YOU WANNA BE FREAKY).")
    public double exhaustionDoubleJumpMultiplier = 1.0;
    @Comment(value="Play a rush of wind as you fall to your doom.")
    public boolean playFallingSound = true;
    @Comment(value="Minimum distance for fall damage sound to play; set to 3.0 to disable.")
    public double minFallDistance = 7.5;
    @Comment(value="Elytra speed boost; set to 0.0 to disable.")
    public double elytraSpeedBoost = 0.0;
    @Comment(value="Sprint speed boost; set to 0.0 to disable.")
    public double sprintSpeedBoost = 0.0;
    @Comment(value="If you disable Speed Boost, it enables the enchantment automagically, this option disables the enchantment.")
    @ConfigEntry.Gui.RequiresRestart
    public boolean enableSpeedBoostEnchantment = false;
    @Comment(value="The rarity for Speedboost Enchant, i.e. how often it appears in enchanting table, etc.")
    @ConfigEntry.Gui.RequiresRestart
    public Enchantment.Rarity speedBoostEnchantmentRarity = Enchantment.Rarity.RARE;
    @Comment(value="Walk up steps even while airborne, also jump over fences.")
    public boolean enableStepAssist = true;
    @Comment(value="Alternative way of Wall-Jumping using Spacebar which requires Pressing Space while Clinged. (might be wonky on anything but Space)")
    public boolean spaceWallJumpAlt = false;
}

