/*
 * Decompiled with CFR 0.152.
 */
package forge.genandnic.walljump.registry;

import dev.architectury.registry.registries.DeferredRegister;
import forge.genandnic.walljump.enchantments.CustomEnchantment;
import forge.genandnic.walljump.enchantments.DoubleJumpEnchantment;
import forge.genandnic.walljump.enchantments.SpeedBoostEnchantment;
import forge.genandnic.walljump.enchantments.WallJumpEnchantment;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;

public class WallJumpEnchantments {
    private static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((String)"walljump", (ResourceKey)Registries.f_256762_);
    private static final Set<CustomEnchantment> enchantmentsToRegister = new HashSet<CustomEnchantment>();
    public static CustomEnchantment WALLJUMP_ENCHANTMENT = WallJumpEnchantments.addEnchantmentToRegistrySet(new WallJumpEnchantment());
    public static CustomEnchantment DOUBLEJUMP_ENCHANTMENT = WallJumpEnchantments.addEnchantmentToRegistrySet(new DoubleJumpEnchantment());
    public static CustomEnchantment SPEEDBOOST_ENCHANTMENT = WallJumpEnchantments.addEnchantmentToRegistrySet(new SpeedBoostEnchantment());

    private static <T extends CustomEnchantment> T addEnchantmentToRegistrySet(T enchantment) {
        if (enchantment.enableEnchantment()) {
            enchantmentsToRegister.add(enchantment);
        }
        return enchantment;
    }

    public static void registerEnchantments() {
        for (CustomEnchantment enchantment : enchantmentsToRegister) {
            ENCHANTMENTS.register(enchantment.getName(), () -> enchantment);
        }
        ENCHANTMENTS.register();
    }
}

