/*
 * Decompiled with CFR 0.152.
 */
package quilt.genandnic.walljump.util;

import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_746;
import quilt.genandnic.walljump.config.WallJumpConfig;
import quilt.genandnic.walljump.logic.Logic;
import quilt.genandnic.walljump.logic.WallJumpLogic;
import quilt.genandnic.walljump.registry.WallJumpEnchantments;
import quilt.genandnic.walljump.registry.WallJumpKeyMappings;

public interface IWallJumpHelper {
    public static boolean checkKeyBind() {
        class_746 pl = class_310.method_1551().field_1724;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        return WallJumpConfig.getConfigEntries().enableClassicWallCling ? !pl.field_3913.field_3903 : !WallJumpKeyMappings.toggleWallJump;
    }

    public static boolean getWallJumpEligibility() {
        class_746 pl = class_310.method_1551().field_1724;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        if (WallJumpConfig.getConfigEntries().enableWallJump) {
            return true;
        }
        class_1799 stack = pl.method_6118(class_1304.field_6166);
        if (!stack.method_7960()) {
            Map enchantments = class_1890.method_8222((class_1799)stack);
            return enchantments.containsKey((Object)WallJumpEnchantments.WALLJUMP_ENCHANTMENT);
        }
        return false;
    }

    public static boolean getWallClingEligibility() {
        class_746 pl = class_310.method_1551().field_1724;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        boolean bl1 = pl.method_6128() && !WallJumpConfig.getConfigEntries().enableElytraWallCling;
        boolean bl2 = pl.method_5767() && !WallJumpConfig.getConfigEntries().enableInvisibleWallCling;
        class_2680 blockState = pl.method_37908().method_8320(IWallJumpHelper.getWallPos());
        for (String block : WallJumpConfig.getConfigEntries().blockBlacklist) {
            if (!blockState.method_26204().method_9539().contains(block.toLowerCase())) continue;
            return false;
        }
        if (pl.method_6101() || pl.method_18798().field_1351 > 0.1 || pl.method_7344().method_7586() < 1 || bl1 || bl2) {
            return false;
        }
        if (!pl.method_37908().method_18026(pl.method_5829().method_989(0.0, -0.8, 0.0))) {
            return false;
        }
        if (WallJumpConfig.getConfigEntries().enableReclinging || pl.method_19538().field_1351 < WallJumpLogic.lastJumpY - 1.0) {
            return true;
        }
        return !WallJumpLogic.staleWalls.containsAll(WallJumpLogic.walls);
    }

    public static class_2350 getWallClingDirection() {
        return WallJumpLogic.walls.isEmpty() ? class_2350.field_11036 : WallJumpLogic.walls.iterator().next();
    }

    public static class_2338 getWallPos() {
        class_746 pl = class_310.method_1551().field_1724;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        class_2338 clingPos = pl.method_24515().method_10093(IWallJumpHelper.getWallClingDirection());
        return pl.method_37908().method_8320(clingPos).method_26207().method_15799() ? clingPos : clingPos.method_10093(class_2350.field_11036);
    }

    public static void updateWalls() {
        class_746 pl = class_310.method_1551().field_1724;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        class_238 box = new class_238(pl.method_23317() - 0.001, pl.method_23318(), pl.method_23321() - 0.001, pl.method_23317() + 0.001, pl.method_23318() + (double)pl.method_5751(), pl.method_23321() + 0.001);
        double dist = (double)(pl.method_17681() / 2.0f) + (Logic.ticksWallClinged > 0 ? 0.1 : 0.06);
        class_238[] axes = new class_238[]{box.method_1012(0.0, 0.0, dist), box.method_1012(-dist, 0.0, 0.0), box.method_1012(0.0, 0.0, -dist), box.method_1012(dist, 0.0, 0.0)};
        int i = 0;
        WallJumpLogic.walls = new HashSet<class_2350>();
        for (class_238 axis : axes) {
            class_2350 direction = class_2350.method_10139((int)i++);
            if (pl.method_37908().method_18026(axis)) continue;
            WallJumpLogic.walls.add(direction);
            pl.field_5976 = true;
        }
    }

    public static void spawnWallParticle(class_2338 blockPos) {
        class_746 pl = class_310.method_1551().field_1724;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        class_2680 blockState = pl.method_37908().method_8320(blockPos);
        if (blockState.method_26217() != class_2464.field_11455) {
            class_243 pos = pl.method_19538();
            class_2382 motion = IWallJumpHelper.getWallClingDirection().method_10163();
            pl.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), pos.field_1352, pos.field_1351, pos.field_1350, (double)motion.method_10263() * -1.0, -1.0, (double)motion.method_10260() * -1.0);
        }
    }

    public static void playBreakSound(class_2338 blockPos) {
        class_746 pl = class_310.method_1551().field_1724;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        class_2680 blockState = pl.method_37908().method_8320(blockPos);
        class_2498 soundType = blockState.method_26204().method_9573(blockState);
        pl.method_5783(soundType.method_10593(), soundType.method_10597() * 0.5f, soundType.method_10599());
    }

    public static void playHitSound(class_2338 blockPos) {
        class_746 pl = class_310.method_1551().field_1724;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        class_2680 blockState = pl.method_37908().method_8320(blockPos);
        class_2498 soundType = blockState.method_26204().method_9573(blockState);
        pl.method_5783(soundType.method_10596(), soundType.method_10597() * 0.25f, soundType.method_10599());
    }

    public static int getEquipmentBoost(class_1304 slot) {
        Map enchantments;
        class_746 pl = class_310.method_1551().field_1724;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        class_1799 stack = pl.method_6118(slot);
        if (!stack.method_7960() && (enchantments = class_1890.method_8222((class_1799)stack)).containsKey((Object)WallJumpEnchantments.SPEEDBOOST_ENCHANTMENT)) {
            return (Integer)enchantments.get((Object)WallJumpEnchantments.SPEEDBOOST_ENCHANTMENT);
        }
        return 0;
    }

    public static int getJumpCount() {
        Map enchantments;
        class_1799 stack;
        class_746 pl = class_310.method_1551().field_1724;
        if (!1.$assertionsDisabled && pl == null) {
            throw new AssertionError();
        }
        int jumpCount = 0;
        if (WallJumpConfig.getConfigEntries().enableDoubleJump) {
            jumpCount += WallJumpConfig.getConfigEntries().countDoubleJump;
        }
        if (!(stack = pl.method_6118(class_1304.field_6166)).method_7960() && (enchantments = class_1890.method_8222((class_1799)stack)).containsKey((Object)WallJumpEnchantments.DOUBLEJUMP_ENCHANTMENT)) {
            jumpCount += ((Integer)enchantments.get((Object)WallJumpEnchantments.DOUBLEJUMP_ENCHANTMENT)).intValue();
        }
        return jumpCount;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

