/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.internal;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.internal.NBTConverter;
import com.sk89q.worldedit.forge.internal.TileEntityUtils;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.block.BlockState;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerChunkProvider;

public class ForgeWorldNativeAccess
implements WorldNativeAccess<Chunk, net.minecraft.block.BlockState, BlockPos> {
    private static final int UPDATE = 1;
    private static final int NOTIFY = 2;
    private final WeakReference<World> world;
    private SideEffectSet sideEffectSet;

    public ForgeWorldNativeAccess(WeakReference<World> world) {
        this.world = world;
    }

    private World getWorld() {
        return (World)Objects.requireNonNull(this.world.get(), "The reference to the world was lost");
    }

    @Override
    public void setCurrentSideEffectSet(SideEffectSet sideEffectSet) {
        this.sideEffectSet = sideEffectSet;
    }

    @Override
    public Chunk getChunk(int x, int z) {
        return this.getWorld().func_212866_a_(x, z);
    }

    @Override
    public net.minecraft.block.BlockState toNative(BlockState state) {
        int stateId = BlockStateIdAccess.getBlockStateId(state);
        return BlockStateIdAccess.isValidInternalId(stateId) ? Block.func_196257_b((int)stateId) : ForgeAdapter.adapt(state);
    }

    @Override
    public net.minecraft.block.BlockState getBlockState(Chunk chunk, BlockPos position) {
        return chunk.func_180495_p(position);
    }

    @Override
    @Nullable
    public net.minecraft.block.BlockState setBlockState(Chunk chunk, BlockPos position, net.minecraft.block.BlockState state) {
        return chunk.func_177436_a(position, state, false);
    }

    @Override
    public net.minecraft.block.BlockState getValidBlockForPosition(net.minecraft.block.BlockState block, BlockPos position) {
        return Block.func_199770_b((net.minecraft.block.BlockState)block, (IWorld)this.getWorld(), (BlockPos)position);
    }

    @Override
    public BlockPos getPosition(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @Override
    public void updateLightingForBlock(BlockPos position) {
        this.getWorld().func_72863_F().func_212863_j_().func_215568_a(position);
    }

    @Override
    public boolean updateTileEntity(BlockPos position, CompoundTag tag) {
        CompoundNBT nativeTag = NBTConverter.toNative(tag);
        return TileEntityUtils.setTileEntity(this.getWorld(), position, nativeTag);
    }

    @Override
    public void notifyBlockUpdate(BlockPos position, net.minecraft.block.BlockState oldState, net.minecraft.block.BlockState newState) {
        this.getWorld().func_184138_a(position, oldState, newState, 3);
    }

    @Override
    public boolean isChunkTicking(Chunk chunk) {
        return chunk.func_217321_u().func_219065_a(ChunkHolder.LocationType.TICKING);
    }

    @Override
    public void markBlockChanged(BlockPos position) {
        ((ServerChunkProvider)this.getWorld().func_72863_F()).func_217217_a(position);
    }

    @Override
    public void notifyNeighbors(BlockPos pos, net.minecraft.block.BlockState oldState, net.minecraft.block.BlockState newState) {
        World world = this.getWorld();
        if (this.sideEffectSet.shouldApply(SideEffect.EVENTS)) {
            world.func_195593_d(pos, oldState.func_177230_c());
        } else {
            Block block = oldState.func_177230_c();
            world.func_190524_a(pos.func_177976_e(), block, pos);
            world.func_190524_a(pos.func_177974_f(), block, pos);
            world.func_190524_a(pos.func_177977_b(), block, pos);
            world.func_190524_a(pos.func_177984_a(), block, pos);
            world.func_190524_a(pos.func_177978_c(), block, pos);
            world.func_190524_a(pos.func_177968_d(), block, pos);
        }
        if (newState.func_185912_n()) {
            world.func_175666_e(pos, newState.func_177230_c());
        }
    }

    @Override
    public void updateNeighbors(BlockPos pos, net.minecraft.block.BlockState oldState, net.minecraft.block.BlockState newState, int recursionLimit) {
        World world = this.getWorld();
        oldState.func_241483_b_((IWorld)world, pos, 2, recursionLimit);
        newState.func_241482_a_((IWorld)world, pos, 2, recursionLimit);
        newState.func_241483_b_((IWorld)world, pos, 2, recursionLimit);
    }

    @Override
    public void onBlockStateChange(BlockPos pos, net.minecraft.block.BlockState oldState, net.minecraft.block.BlockState newState) {
        this.getWorld().func_217393_a(pos, oldState, newState);
    }
}

