/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.model.v2;

import com.google.gson.Gson;
import com.swdteam.model.v2.Cube;
import com.swdteam.model.v2.JSONModel;
import com.swdteam.model.v2.ModelData;
import com.swdteam.model.v2.ModelRenderer;
import com.swdteam.model.v2.ModelWrapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.util.ResourceLocation;

public class ModelLoader {
    private static Gson GSON = new Gson();
    private static Map<ResourceLocation, JSONModel> cache = new HashMap<ResourceLocation, JSONModel>();

    public static JSONModel loadModel(ResourceLocation rl) {
        if (cache.containsKey(rl)) {
            return cache.get(rl);
        }
        InputStream stream = Minecraft.func_71410_x().func_195551_G().func_199002_a(rl).func_199027_b();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder b = new StringBuilder();
            String s = null;
            while ((s = reader.readLine()) != null) {
                b.append(s);
            }
            ModelData model = (ModelData)GSON.fromJson(b.toString(), ModelData.class);
            if (model.parentModel != null && model.parentModel.length() > 0) {
                JSONModel md = new JSONModel(ModelLoader.loadModel(new ResourceLocation(model.parentModel)).getModel(), new ResourceLocation(model.texture));
                return md;
            }
            ModelWrapper mod = new ModelWrapper(model.textureWidth, model.textureHeight);
            for (ModelRenderer renderer : model.groups) {
                net.minecraft.client.renderer.model.ModelRenderer group = new net.minecraft.client.renderer.model.ModelRenderer((Model)mod);
                group.func_78793_a(renderer.getPivot()[0], renderer.getPivot()[1], renderer.getPivot()[2]);
                group.field_78795_f = renderer.rotateAngleX;
                group.field_78796_g = renderer.rotateAngleY;
                group.field_78808_h = renderer.rotateAngleZ;
                for (Cube cube : renderer.cubes) {
                    group.func_78784_a(cube.getUv()[0], cube.getUv()[1]).func_228303_a_(cube.getOrigin()[0], cube.getOrigin()[1], cube.getOrigin()[2], cube.getSize()[0], cube.getSize()[1], cube.getSize()[2], cube.getInflate(), cube.isMirrored());
                }
                ModelLoader.addChildren(mod, renderer, group);
                mod.renderList.add(group);
                mod.partsList.put(renderer.groupName, group);
            }
            JSONModel jsonModel = new JSONModel(mod, new ResourceLocation(model.texture));
            return jsonModel;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return null;
    }

    private static void addChildren(ModelWrapper wrapper, ModelRenderer mv2, net.minecraft.client.renderer.model.ModelRenderer model) {
        if (mv2.getChildren() != null && mv2.getChildren().size() > 0) {
            for (ModelRenderer m : mv2.getChildren()) {
                net.minecraft.client.renderer.model.ModelRenderer renderer = new net.minecraft.client.renderer.model.ModelRenderer((Model)wrapper);
                renderer.func_78793_a(m.getPivot()[0], m.getPivot()[1], m.getPivot()[2]);
                renderer.field_78795_f = m.rotateAngleX;
                renderer.field_78796_g = m.rotateAngleY;
                renderer.field_78808_h = m.rotateAngleZ;
                for (Cube cube : m.cubes) {
                    renderer.func_78784_a(cube.getUv()[0], cube.getUv()[1]).func_228303_a_(cube.getOrigin()[0], cube.getOrigin()[1], cube.getOrigin()[2], cube.getSize()[0], cube.getSize()[1], cube.getSize()[2], cube.getInflate(), cube.isMirrored());
                }
                ModelLoader.addChildren(wrapper, m, renderer);
                model.func_78792_a(renderer);
                wrapper.partsList.put(m.groupName, renderer);
            }
        }
    }

    public static Map<ResourceLocation, JSONModel> getCache() {
        return cache;
    }
}

