/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.block.tiles;

import com.swdteam.wotwmod.common.block.base.StandardModelBlock;
import com.swdteam.wotwmod.common.init.WOTWSounds;
import com.swdteam.wotwmod.common.init.WOTWTiles;
import com.swdteam.wotwmod.common.misc.WOTWConfig;
import com.swdteam.wotwmod.common.tilentity.BaseTileEntity;
import com.swdteam.wotwmod.common.tilentity.NukeTileEntity;
import com.swdteam.wotwmod.common.utils.ItemUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class NukeBlock
extends StandardModelBlock {
    protected static VoxelShape SHAPE_A = Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)WOTWTiles.NUKE.get()).func_200968_a();
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (!((Boolean)WOTWConfig.COMMON.nuke_enabled.get()).booleanValue()) {
            ItemUtils.addText(tooltip, "Nukes have been disabled by your server administrator", TextFormatting.RED);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return (Boolean)WOTWConfig.COMMON.nuke_enabled.get() != false;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_A;
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_A;
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_175625_s(pos) instanceof NukeTileEntity) {
            NukeTileEntity nuke = (NukeTileEntity)worldIn.func_175625_s(pos);
            if (!nuke.activated) {
                player.func_184185_a((SoundEvent)WOTWSounds.SOUND_NUKE_TRIGGER.get(), 0.5f, 1.0f);
                nuke.activated = true;
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, LivingEntity entity) {
        Vector3d vec = entity.func_213303_ch();
        return Direction.func_176737_a((float)((float)(vec.field_72450_a - (double)clickedBlock.func_177958_n())), (float)((float)(vec.field_72448_b - (double)clickedBlock.func_177956_o())), (float)((float)(vec.field_72449_c - (double)clickedBlock.func_177952_p())));
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer != null) {
            Direction d = NukeBlock.getFacingFromEntity(pos, placer).func_176734_d();
            if (d == Direction.DOWN) {
                d = Direction.NORTH;
            }
            if (d == Direction.UP) {
                d = Direction.UP;
            }
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)FACING, (Comparable)d));
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof BaseTileEntity) {
                // empty if block
            }
        }
    }
}

