/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.entity.martian.task;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.MathHelper;

public class FightingMachineAttack
extends Goal {
    private final MobEntity entityHost;
    private final IRangedAttackMob rangedAttackEntityHost;
    private LivingEntity attackTarget;
    private int rangedAttackTime = -1;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;

    public FightingMachineAttack(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
        this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
    }

    public FightingMachineAttack(IRangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
        if (!(attacker instanceof LivingEntity)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackEntityHost = attacker;
        this.entityHost = (MobEntity)attacker;
        this.attackIntervalMin = p_i1650_4_;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistanceIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.entityHost.func_70638_az();
        if (livingentity != null && livingentity.func_70089_S()) {
            this.attackTarget = livingentity;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        double d0 = this.entityHost.func_70092_e(this.attackTarget.func_226277_ct_(), this.attackTarget.func_226278_cu_(), this.attackTarget.func_226281_cx_());
        boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        if (flag) {
            // empty if block
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            if (!flag) {
                return;
            }
            float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
            this.rangedAttackEntityHost.func_82196_d(this.attackTarget, lvt_5_1_);
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.rangedAttackTime < 0) {
            float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }
}

