/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.entity.projectile;

import com.swdteam.wotwmod.common.block.base.OilBarrelBlock;
import com.swdteam.wotwmod.common.init.WOTWEntities;
import net.minecraft.block.BlockState;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ProjectileBaseEntity
extends ThrowableEntity {
    public LivingEntity shooter;
    public float explosionSize = 8.0f;
    protected DamageSource damageSource;
    private float damage = 1.0f;
    public float red = 1.0f;
    public float blue = 1.0f;
    public float green = 1.0f;
    public float alpha = 0.75f;
    public boolean emitsSmoke = true;
    public boolean goesThroughBlocks = false;

    public ProjectileBaseEntity(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ProjectileBaseEntity(World worldIn, LivingEntity shooter, float yOffset, float damage) {
        super((EntityType)WOTWEntities.ENTITY_MUSKET_BALL.get(), shooter, worldIn);
        this.setShooter(shooter);
        this.func_70107_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e() - (double)(0.15f + yOffset), shooter.func_226281_cx_());
        this.damage = damage;
        this.shooter = shooter;
        this.damageSource = new EntityDamageSource(shooter.func_70022_Q(), (Entity)shooter);
    }

    public void func_70030_z() {
        if (this.emitsSmoke && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.func_70030_z();
    }

    protected void func_70088_a() {
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public void setShooter(LivingEntity shooter) {
        this.shooter = shooter;
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        if (shooter instanceof LivingEntity) {
            this.shooter = (LivingEntity)shooter;
        }
        Vector3d vec3d = new Vector3d((double)f, (double)f1, (double)f2).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float fd = MathHelper.func_76133_a((double)ProjectileBaseEntity.func_213296_b((Vector3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)fd) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.func_213317_d(this.func_213322_ci().func_72441_c(shooter.func_213322_ci().field_72450_a, shooter.func_233570_aj_() ? 0.0 : shooter.func_213322_ci().field_72448_b, shooter.func_213322_ci().field_72449_c));
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void setEmitsSmoke(boolean emitsSmoke) {
        this.emitsSmoke = emitsSmoke;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult result1 = (EntityRayTraceResult)result;
                Entity entity = result1.func_216348_a();
                if (entity != null && entity != this.shooter && this.damageSource != null) {
                    LivingEntity entity1;
                    entity.func_70097_a(this.damageSource, this.damage);
                    if (this.shooter instanceof PlayerEntity && !this.field_70170_p.field_72995_K && entity instanceof LivingEntity && (entity1 = (LivingEntity)entity).func_110143_aJ() <= 0.0f) {
                        int val = 3;
                        for (int i = 0; i < val; ++i) {
                        }
                    }
                }
            } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)result;
                BlockState state = this.field_70170_p.func_180495_p(rayTraceResult.func_216350_a());
                if (state.func_177230_c() instanceof GlassBlock || state.func_177230_c() instanceof PaneBlock || state.func_177230_c() instanceof OilBarrelBlock) {
                    // empty if block
                }
                if (state.func_185904_a().func_76220_a() && !this.goesThroughBlocks) {
                    this.func_174812_G();
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 160 == 0) {
            this.func_174812_G();
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity entity = result.func_216348_a();
        if (entity != null) {
            entity.func_70097_a(this.damageSource, this.damage);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setDamageSource(DamageSource sauce) {
        this.damageSource = sauce;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setGoesThroughBlocks(boolean goesThroughBlocks) {
        this.goesThroughBlocks = goesThroughBlocks;
    }
}

