/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.misc;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="wotwmod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WOTWConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Common COMMON;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading event) {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue dev_overlay;
        public final ForgeConfigSpec.BooleanValue title_screen;
        public final ForgeConfigSpec.BooleanValue item_overlay;
        public final ForgeConfigSpec.BooleanValue red_fog_effect;
        public final ForgeConfigSpec.BooleanValue gun_overlay;
        public final ForgeConfigSpec.BooleanValue block_tooltips;
        public final ForgeConfigSpec.BooleanValue title_screen_music;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("War of the Worlds Mod Config (Client-Side)").push("WOTWMod");
            this.dev_overlay = builder.comment("Enable Developer Mode (Default: False)").translation("wotwmod.config.devui").worldRestart().define("dev_ui", false);
            this.title_screen = builder.comment("Enable or disable the custom title screen (Default: True)").translation("wotwmod.config.title").worldRestart().define("titleScreen", true);
            this.item_overlay = builder.comment("Enable or disable the custom item display at the top right (Default: True)").translation("wotwmod.config.item_overlay").worldRestart().define("item_overlay", true);
            this.red_fog_effect = builder.comment("Red Mist in the overworld (Default: True)").translation("wotwmod.config.red_mist").worldRestart().define("red_fog_effect", true);
            this.gun_overlay = builder.comment("Ammo counter when holding gun (Default: True)").translation("wotwmod.config.gun_overlay").worldRestart().define("gun_overlay", true);
            this.block_tooltips = builder.comment("Tooltips when looking at certain blocks (Default: True)").translation("wotwmod.config.block_tooltips").worldRestart().define("block_tooltips", true);
            this.title_screen_music = builder.comment("Music on the title screen (Default: True)").translation("wotwmod.config.title_screen_music").worldRestart().define("title_screen_music", true);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue redweed_spread_enabled;
        public final ForgeConfigSpec.BooleanValue molotov_enabled;
        public final ForgeConfigSpec.BooleanValue martian_mining_laser_enabled;
        public final ForgeConfigSpec.BooleanValue rpg_enabled;
        public final ForgeConfigSpec.BooleanValue nuke_enabled;
        public final ForgeConfigSpec.BooleanValue vanilla_mobs;
        public final ForgeConfigSpec.BooleanValue tree_fell;
        public final ForgeConfigSpec.BooleanValue destruction;
        public final ForgeConfigSpec.BooleanValue scalper_pickup;
        public final ForgeConfigSpec.IntValue dynamite_radius;
        public final ForgeConfigSpec.IntValue redweed_rarity;
        public final ForgeConfigSpec.DoubleValue martian_light_level_spawn;
        public final ForgeConfigSpec.IntValue martian_explosion_radius;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("War Of The Worlds Mod (Common Config)");
            builder.comment("War of the Worlds Mod Config").push("WOTWMod [General]");
            this.redweed_spread_enabled = builder.comment("Enables and disables the spreading of all redweed blocks (Default: True)").translation("wotwmod.config.redwedspread").worldRestart().define("redweed_spread", true);
            this.redweed_rarity = builder.comment("The higher this value, the slower redweed spreads (Default: 1000)").translation("wotwmod.config.redweed_spread").worldRestart().defineInRange("redweedspread", 1000, 30, 100000);
            this.martian_light_level_spawn = builder.comment("Configures the light level martians can spawn in 0.5 is daylight (Default: 0.5)").translation("wotwmod.config.redwedspread").worldRestart().defineInRange("martian_light_level_spawn", 0.5, 0.0, 1.0);
            this.vanilla_mobs = builder.comment("Configures whether hostile vanilla mobs will spawn naturally (Default: True)").translation("wotwmod.config.vanilla_mobs").worldRestart().define("vanilla_mobs", true);
            this.tree_fell = builder.comment("Tree capitator style tree cutting (only on y axis) off by default (Default: False)").translation("wotwmod.config.tree_fell").worldRestart().define("tree_fell", false);
            builder.pop();
            builder.comment("War of the Worlds Mod Config").push("WOTWMod [Greifing]");
            this.molotov_enabled = builder.comment("Enables and disables Molotovs (Default: True)").translation("wotwmod.config.molotov").worldRestart().define("molotov_enabled", true);
            this.martian_mining_laser_enabled = builder.comment("Enables and disables the martian mining laser (Default: True)").translation("wotwmod.config.martian_mining_laser").worldRestart().define("martian_mining_laser_enabled", true);
            this.rpg_enabled = builder.comment("Enables and disables the rpg (Default: True)").translation("wotwmod.config.rpg_enabled").worldRestart().define("rpg_enabled", true);
            this.dynamite_radius = builder.comment("Changes the blast radius of miners tnt (Default: 5)").translation("wotwmod.config.tnt_radius").worldRestart().defineInRange("mining_tnt_radius", 5, 0, 30);
            this.nuke_enabled = builder.comment("Enables and disables the nuke block (Default: True)").translation("wotwmod.config.nuke_enabled").worldRestart().define("nuke_enabled", true);
            builder.pop();
            builder.comment("War of the Worlds Mod Config").push("WOTWMod [Difficulty]");
            this.martian_explosion_radius = builder.comment("Changes the blast radius of martian laser impacts (Default: 1)").translation("wotwmod.config.martian_explosion_radius").worldRestart().defineInRange("martian_explosion_radius", 1, 1, 100);
            this.destruction = builder.comment("Toggles martians actually blowing stuff up (Default: True)").translation("wotwmod.config.destruction").worldRestart().define("destruction", true);
            this.scalper_pickup = builder.comment("Toggle if scalpers can actually pickup blocks (Default: True)").translation("wotwmod.config.destruction").worldRestart().define("scalper_pickup", true);
            builder.pop();
        }
    }
}

