/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.wotwmod.common.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.swdteam.wotwmod.common.structure.AshDenStructure;
import com.swdteam.wotwmod.common.structure.CasinoStructure;
import com.swdteam.wotwmod.common.structure.DesertHouseStructure;
import com.swdteam.wotwmod.common.structure.FoHouseStructure;
import com.swdteam.wotwmod.common.structure.GermLabStructure;
import com.swdteam.wotwmod.common.structure.LabStructure;
import com.swdteam.wotwmod.common.structure.LooterDenStructure;
import com.swdteam.wotwmod.common.structure.LooterShrineStructure;
import com.swdteam.wotwmod.common.structure.LooterTowerStructure;
import com.swdteam.wotwmod.common.structure.MarsChimneyStructure;
import com.swdteam.wotwmod.common.structure.MarsRuinsStructure;
import com.swdteam.wotwmod.common.structure.MartianPodStructure;
import com.swdteam.wotwmod.common.structure.MartianRoomStructure;
import com.swdteam.wotwmod.common.structure.MinefieldStructure;
import com.swdteam.wotwmod.common.structure.NiceHouseStructure;
import com.swdteam.wotwmod.common.structure.RuinsOneStructure;
import com.swdteam.wotwmod.common.structure.RuinsZeroStructure;
import com.swdteam.wotwmod.common.structure.SlaveMinesStructure;
import com.swdteam.wotwmod.common.structure.TexacoStructure;
import com.swdteam.wotwmod.common.structure.TruckStructure;
import com.swdteam.wotwmod.common.structure.USBunkerStructure;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class WOTWStructures {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"wotwmod");
    public static final RegistryObject<Structure<NoFeatureConfig>> NICE_HOUSE = WOTWStructures.registerStructure("nice_house", () -> new NiceHouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> LOOTER_TOWER = WOTWStructures.registerStructure("looter_tower", () -> new LooterTowerStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> RUINS_ZERO = WOTWStructures.registerStructure("ruins_zero", () -> new RuinsZeroStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> RUINS_ONE = WOTWStructures.registerStructure("ruins_one", () -> new RuinsOneStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> DESERTHOUSE = WOTWStructures.registerStructure("deserthouse", () -> new DesertHouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> MARTIANPOD = WOTWStructures.registerStructure("martianpod", () -> new MartianPodStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> LOOTER_DEN = WOTWStructures.registerStructure("looter_den", () -> new LooterDenStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> MARTIAN_ROOM = WOTWStructures.registerStructure("martian_room", () -> new MartianRoomStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> LOOTER_SHRINE = WOTWStructures.registerStructure("looter_shrine", () -> new LooterShrineStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> LAB = WOTWStructures.registerStructure("lab", () -> new LabStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> MINEFIELD = WOTWStructures.registerStructure("minefield", () -> new MinefieldStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> ASH_DEN = WOTWStructures.registerStructure("ash_den", () -> new AshDenStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> SLAVE_MINES = WOTWStructures.registerStructure("slavemines", () -> new SlaveMinesStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> MARS_CHIMNEY = WOTWStructures.registerStructure("mars_chimney", () -> new MarsChimneyStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> CASINO = WOTWStructures.registerStructure("casino", () -> new CasinoStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> MARS_RUINS = WOTWStructures.registerStructure("marsruins", () -> new MarsRuinsStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> US_BUNKER = WOTWStructures.registerStructure("usbunker", () -> new USBunkerStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> TEXACO = WOTWStructures.registerStructure("texaco", () -> new TexacoStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> FO_HOUSE = WOTWStructures.registerStructure("fo_house", () -> new FoHouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> TRUCK = WOTWStructures.registerStructure("truck", () -> new TruckStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> GERM_LAB = WOTWStructures.registerStructure("germ_lab", () -> new GermLabStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    private static <T extends Structure<?>> RegistryObject<T> registerStructure(String name, Supplier<T> structure) {
        return DEFERRED_REGISTRY_STRUCTURE.register(name, structure);
    }

    public static void setupStructures() {
        WOTWStructures.setupMapSpacingAndLand((Structure)NICE_HOUSE.get(), new StructureSeparationSettings(40, 5, 1234567890), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)LOOTER_TOWER.get(), new StructureSeparationSettings(60, 20, 1234567121), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)RUINS_ZERO.get(), new StructureSeparationSettings(60, 5, 9211221), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)RUINS_ONE.get(), new StructureSeparationSettings(60, 5, 32134521), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)DESERTHOUSE.get(), new StructureSeparationSettings(60, 5, 114312521), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)MARTIANPOD.get(), new StructureSeparationSettings(60, 20, 1146969420), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)LOOTER_DEN.get(), new StructureSeparationSettings(20, 10, 1156529420), false);
        WOTWStructures.setupMapSpacingAndLand((Structure)MARTIAN_ROOM.get(), new StructureSeparationSettings(30, 5, 1143212420), false);
        WOTWStructures.setupMapSpacingAndLand((Structure)LOOTER_SHRINE.get(), new StructureSeparationSettings(90, 40, 694206949), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)LAB.get(), new StructureSeparationSettings(40, 10, 6743221), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)MINEFIELD.get(), new StructureSeparationSettings(20, 10, 1229242069), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)ASH_DEN.get(), new StructureSeparationSettings(20, 10, 74328865), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)SLAVE_MINES.get(), new StructureSeparationSettings(20, 10, 263121319), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)MARS_CHIMNEY.get(), new StructureSeparationSettings(20, 10, 6683865), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)CASINO.get(), new StructureSeparationSettings(60, 30, 26042003), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)MARS_RUINS.get(), new StructureSeparationSettings(10, 5, 9900221), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)US_BUNKER.get(), new StructureSeparationSettings(40, 20, 5414221), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)TEXACO.get(), new StructureSeparationSettings(30, 20, 562231), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)FO_HOUSE.get(), new StructureSeparationSettings(30, 20, 42316645), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)TRUCK.get(), new StructureSeparationSettings(20, 10, 856332145), true);
        WOTWStructures.setupMapSpacingAndLand((Structure)GERM_LAB.get(), new StructureSeparationSettings(50, 10, 54652990), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
    }
}

