/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.OptionSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import org.lwjgl.glfw.GLFW;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.ModOptionWidget;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.widget.WidgetScreen;
import xaero.common.misc.Misc;
import xaero.common.settings.ModOptions;

public abstract class GuiSettings
extends ScreenBase
implements WidgetScreen {
    protected ModOptions[] options;
    protected String screenTitle;
    private static final CursorBox worldmapBox = new CursorBox("gui.xaero_uses_worldmap_value");

    public GuiSettings(IXaeroMinimap modMain, TextComponent title, Screen backScreen, Screen escScreen) {
        super(modMain, backScreen, escScreen, (ITextComponent)title);
    }

    public void init() {
        super.init();
        this.screenTitle = this.title.func_150254_d();
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 6 + 168, 200, 20, I18n.func_135052_a((String)"gui.xaero_back", (Object[])new Object[0]), b -> this.goBack()));
        int var8 = 0;
        if (this.options != null) {
            for (ModOptions option : this.options) {
                Widget optionWidget = option.getMcOption().func_216586_a(this.minecraft.field_71474_y, this.width / 2 - 205 + var8 % 2 * 210, this.height / 7 + 24 * (var8 >> 1), 200);
                this.addButton(optionWidget);
                ++var8;
            }
        }
        this.modMain.getWidgetScreenHandler().initialize(this, this.width, this.height);
    }

    public void render(int par1, int par2, float par3) {
        this.renderBackground();
        this.modMain.getWidgetScreenHandler().render(this, this.width, this.height, par1, par2, this.minecraft.field_195558_d.func_198100_s());
        this.drawCenteredString(this.font, this.screenTitle, this.width / 2, 5, 0xFFFFFF);
        super.render(par1, par2, par3);
        this.modMain.getWidgetScreenHandler().renderTooltips(this, this.width, this.height, par1, par2, this.minecraft.field_195558_d.func_198100_s());
        for (int k = 0; k < this.buttons.size(); ++k) {
            boolean mousePressed;
            Widget b = (Widget)this.buttons.get(k);
            boolean bl = mousePressed = GLFW.glfwGetMouseButton((long)this.minecraft.field_195558_d.func_198092_i(), (int)0) == 1;
            if (!(b instanceof ModOptionWidget) || b instanceof OptionSlider && mousePressed) continue;
            ModOptionWidget optionWidget = (ModOptionWidget)b;
            if (par1 < b.x || par2 < b.y || par1 >= b.x + b.getWidth() || par2 >= b.y + b.getHeight()) continue;
            if (optionWidget.getModOption().getTooltip() != null) {
                optionWidget.getModOption().getTooltip().drawBox(par1, par2, this.width, this.height);
                continue;
            }
            if (!this.modMain.getSettings().usesWorldMapValue(optionWidget.getModOption())) continue;
            worldmapBox.drawBox(par1, par2, this.width, this.height);
        }
    }

    public void restoreFocus(int index) {
        if (index != -1) {
            try {
                IGuiEventListener child = (IGuiEventListener)this.children.get(index);
                this.setFocused(child);
                child.changeFocus(true);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public int getIndex(IGuiEventListener child) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != child) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addButtonVisible(Widget button) {
        this.addButton(button);
    }

    @Override
    public <S extends Screen> S getScreen() {
        return (S)this;
    }

    @Override
    protected void onExit(Screen screen) {
        try {
            this.modMain.getSettings().saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.onExit(screen);
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        if (!super.keyPressed(par1, par2, par3)) {
            if (Misc.inputMatchesKeyBinding(InputMappings.Type.KEYSYM, par1, (KeyBinding)this.modMain.getSettingsKey())) {
                this.onClose();
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.modMain.getWidgetScreenHandler().handleClick(this, this.width, this.height, (int)p_mouseClicked_1_, (int)p_mouseClicked_3_, this.minecraft.field_195558_d.func_198100_s());
        if (!super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
            if (Misc.inputMatchesKeyBinding(InputMappings.Type.MOUSE, p_mouseClicked_5_, (KeyBinding)this.modMain.getSettingsKey())) {
                this.goBack();
                return true;
            }
            return false;
        }
        return true;
    }
}

