/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;

public class GuiTransfer
extends ScreenBase
implements IDropDownCallback {
    private MySmallButton transferButton;
    private ArrayList<GuiDropDown> dropDowns = new ArrayList();
    private GuiWaypointContainers containers1;
    private GuiWaypointWorlds worlds1;
    private GuiWaypointContainers containers2;
    private GuiWaypointWorlds worlds2;
    private GuiDropDown containers1DD;
    private GuiDropDown worlds1DD;
    private GuiDropDown containers2DD;
    private GuiDropDown worlds2DD;
    private XaeroMinimapSession minimapSession;
    private WaypointsManager waypointsManager;
    private final String frozenAutoContainerID;
    private final String frozenAutoWorldID;
    private boolean dropped = false;

    public GuiTransfer(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1, Screen escapeScreen) {
        super(modMain, par1, escapeScreen, (ITextComponent)new TranslationTextComponent("gui.xaero_transfer_all", new Object[0]));
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.frozenAutoContainerID = this.waypointsManager.getAutoContainerID();
        this.frozenAutoWorldID = this.waypointsManager.getAutoWorldID();
        String currentContainer = this.waypointsManager.getCurrentContainerID(this.frozenAutoContainerID).split("/")[0];
        this.containers1 = new GuiWaypointContainers(modMain, this.waypointsManager, currentContainer, this.frozenAutoContainerID);
        this.containers2 = new GuiWaypointContainers(modMain, this.waypointsManager, currentContainer, this.frozenAutoContainerID);
        String currentWorld = this.waypointsManager.getCurrentContainerAndWorldID(this.frozenAutoContainerID, this.frozenAutoWorldID);
        this.worlds1 = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers1.getCurrentKey()), this.waypointsManager, currentWorld, this.frozenAutoContainerID, this.frozenAutoWorldID);
        this.worlds2 = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers2.getCurrentKey()), this.waypointsManager, currentWorld, this.frozenAutoContainerID, this.frozenAutoWorldID);
    }

    public void init() {
        super.init();
        this.transferButton = new MySmallButton(5, this.width / 2 - 155, this.height / 7 + 120, I18n.func_135052_a((String)"gui.xaero_transfer", (Object[])new Object[0]), b -> this.transfer());
        this.addButton((Widget)this.transferButton);
        this.transferButton.active = false;
        this.addButton((Widget)new MySmallButton(6, this.width / 2 + 5, this.height / 7 + 120, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.openParent()));
        this.dropDowns.clear();
        this.worlds1DD = new GuiDropDown(this.worlds1.options, this.width / 2 + 2, this.height / 7 + 20, 200, this.worlds1.current, this);
        this.dropDowns.add(this.worlds1DD);
        this.worlds2DD = new GuiDropDown(this.worlds2.options, this.width / 2 + 2, this.height / 7 + 50, 200, this.worlds2.current, this);
        this.dropDowns.add(this.worlds2DD);
        this.containers1DD = new GuiDropDown(this.containers1.options, this.width / 2 - 202, this.height / 7 + 20, 200, this.containers1.current, this);
        this.dropDowns.add(this.containers1DD);
        this.containers2DD = new GuiDropDown(this.containers2.options, this.width / 2 - 202, this.height / 7 + 50, 200, this.containers2.current, this);
        this.dropDowns.add(this.containers2DD);
    }

    private void openParent() {
        if (this.parent instanceof GuiWaypoints) {
            this.minecraft.func_147108_a((Screen)new GuiWaypoints(this.modMain, this.minimapSession, ((GuiWaypoints)this.parent).parent, this.escape));
        } else {
            this.goBack();
        }
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown((int)par1, (int)par2, this.height)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.height);
                return true;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown((int)par1, (int)par2, this.height)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.height);
                return true;
            }
            d.setClosed(true);
        }
        if (this.dropped) {
            return true;
        }
        return super.mouseClicked(par1, par2, par3);
    }

    public boolean mouseReleased(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased((int)par1, (int)par2, par3, this.height);
        }
        return super.mouseReleased(par1, par2, par3);
    }

    public void transfer() {
        try {
            String[] keys1 = this.worlds1.getCurrentKeys();
            String[] keys2 = this.worlds2.getCurrentKeys();
            WaypointWorld from = this.waypointsManager.getWorld(keys1[0], keys1[1]);
            WaypointWorld to = this.waypointsManager.getWorld(keys2[0], keys2[1]);
            Object[] keys = from.getSets().keySet().toArray();
            Object[] values = from.getSets().values().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String setName = (String)keys[i];
                WaypointSet fromSet = (WaypointSet)values[i];
                WaypointSet toSet = to.getSets().get(setName);
                if (toSet == null) {
                    toSet = new WaypointSet(setName);
                }
                ArrayList<Waypoint> list = fromSet.getList();
                for (int j = 0; j < list.size(); ++j) {
                    Waypoint w = list.get(j);
                    Waypoint copy = new Waypoint(w.getX(), w.getY(), w.getZ(), w.getName(), w.getSymbol(), w.getColor(), w.getType());
                    copy.setRotation(w.isRotation());
                    copy.setDisabled(w.isDisabled());
                    copy.setYaw(w.getYaw());
                    toSet.getList().add(copy);
                }
                to.getSets().put(setName, toSet);
            }
            if (keys2[0] != null && !keys2[0].equals(this.waypointsManager.getCustomContainerID())) {
                this.waypointsManager.setCustomContainerID(keys2[0]);
            }
            if (keys2[1] != null && !keys2[1].equals(this.waypointsManager.getCustomWorldID())) {
                this.waypointsManager.setCustomWorldID(keys2[1]);
            }
            this.waypointsManager.updateWaypoints();
            this.openParent();
            this.modMain.getSettings().saveWaypoints(to);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(int par1, int par2, float par3) {
        int k;
        super.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 5, 0xFFFFFF);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"gui.xaero_from", (Object[])new Object[0]).replace("\u00a7\u00a7", ":") + ":", this.width / 2, this.height / 7 + 10, 0xFFFFFF);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"gui.xaero_to", (Object[])new Object[0]).replace("\u00a7\u00a7", ":") + ":", this.width / 2, this.height / 7 + 40, 0xFFFFFF);
        if (this.dropped) {
            super.render(0, 0, par3);
        } else {
            super.render(par1, par2, par3);
        }
        this.dropped = false;
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) {
                this.dropDowns.get(k).drawButton(par1, par2, this.height);
                continue;
            }
            this.dropped = true;
        }
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) continue;
            this.dropDowns.get(k).drawButton(par1, par2, this.height);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / Minecraft.func_71410_x().field_195558_d.func_198100_s());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / Minecraft.func_71410_x().field_195558_d.func_198100_s());
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.height)) continue;
                d.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, this.height);
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, wheel);
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selected) {
        if (menu == this.containers1DD) {
            this.containers1.current = selected;
            this.worlds1 = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers1.getCurrentKey()), this.waypointsManager, this.waypointsManager.getCurrentContainerAndWorldID(this.frozenAutoContainerID, this.frozenAutoWorldID), this.frozenAutoContainerID, this.frozenAutoWorldID);
            this.worlds1DD = new GuiDropDown(this.worlds1.options, this.width / 2 + 2, this.height / 7 + 20, 200, this.worlds1.current, this);
            this.dropDowns.set(0, this.worlds1DD);
        } else if (menu == this.containers2DD) {
            this.containers2.current = selected;
            this.worlds2 = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers2.getCurrentKey()), this.waypointsManager, this.waypointsManager.getCurrentContainerAndWorldID(this.frozenAutoContainerID, this.frozenAutoWorldID), this.frozenAutoContainerID, this.frozenAutoWorldID);
            this.worlds2DD = new GuiDropDown(this.worlds2.options, this.width / 2 + 2, this.height / 7 + 50, 200, this.worlds2.current, this);
            this.dropDowns.set(1, this.worlds2DD);
        } else if (menu == this.worlds1DD) {
            this.worlds1.current = selected;
        } else if (menu == this.worlds2DD) {
            this.worlds2.current = selected;
        }
        this.transferButton.active = this.containers1.current != this.containers2.current || this.worlds1.current != this.worlds2.current;
        return true;
    }
}

