/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiWaypointsOptions;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.settings.ModSettings;

public class GuiWorldTpCommand
extends ScreenBase {
    private MySmallButton confirmButton;
    private TextFieldWidget commandTextField;
    private boolean usingDefault;
    private String command;
    private WaypointWorldRootContainer rootContainer;

    public GuiWorldTpCommand(IXaeroMinimap modMain, Screen parent, Screen escape, WaypointWorld waypointWorld) {
        super(modMain, parent, escape, (ITextComponent)new TranslationTextComponent("gui.xaero_world_teleport_command", new Object[0]));
        this.rootContainer = waypointWorld.getContainer().getRootContainer();
        this.command = this.rootContainer.getTeleportCommand() == null ? modMain.getSettings().waypointTPCommand : this.rootContainer.getTeleportCommand();
        this.usingDefault = this.rootContainer.isUsingDefaultTeleportCommand();
    }

    public void init() {
        super.init();
        this.parent.resize(this.minecraft, this.width, this.height);
        this.commandTextField = new TextFieldWidget(this.font, this.width / 2 - 100, this.height / 7 + 68, 200, 20, I18n.func_135052_a((String)"gui.xaero_world_teleport_command", (Object[])new Object[0])){

            public void func_146191_b(String textToWrite) {
                if (this.active) {
                    super.func_146191_b(textToWrite);
                }
            }

            public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                if (this.active) {
                    return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
                }
                return false;
            }
        };
        this.commandTextField.active = !this.usingDefault;
        this.commandTextField.func_146180_a(this.command);
        this.children.add(this.commandTextField);
        this.confirmButton = new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            if (this.command.equals(this.modMain.getSettings().waypointTPCommand)) {
                this.usingDefault = true;
                this.command = null;
            }
            this.rootContainer.setUsingDefaultTeleportCommand(this.usingDefault);
            this.rootContainer.setTeleportCommand(this.command);
            this.rootContainer.saveConfig();
            this.goBack();
        });
        this.addButton((Widget)this.confirmButton);
        this.addButton((Widget)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.goBack()));
        this.addButton((Widget)new MySmallButton(202, this.width / 2 - 75, this.height / 7 + 28, I18n.func_135052_a((String)"gui.xaero_use_default", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.usingDefault), b -> {
            this.usingDefault = !this.usingDefault;
            this.commandTextField.active = !this.usingDefault;
            b.setMessage(I18n.func_135052_a((String)"gui.xaero_use_default", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.usingDefault));
        }));
        this.minecraft.field_195559_v.func_197967_a(true);
    }

    public void render(int mouseX, int mouseY, float partial) {
        if (this.parent instanceof GuiWaypointsOptions) {
            ((GuiWaypointsOptions)this.parent).parent.render(0, 0, partial);
        }
        this.renderBackground();
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, 0xFFFFFF);
        super.render(mouseX, mouseY, partial);
        if (this.usingDefault) {
            this.commandTextField.func_146180_a("\u00a78" + this.modMain.getSettings().waypointTPCommand);
        }
        this.commandTextField.render(mouseX, mouseY, partial);
        if (this.usingDefault) {
            this.commandTextField.func_146180_a(this.command);
        }
    }

    public void tick() {
        this.commandTextField.func_146178_a();
        this.command = this.commandTextField.func_146179_b();
        this.confirmButton.active = this.command != null && this.command.length() > 0;
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        if (this.commandTextField.isFocused() && par1 == 257 && this.command != null && this.command.length() > 0) {
            ((Widget)this.buttons.get(0)).onClick(0.0, 0.0);
        }
        return super.keyPressed(par1, par2, par3);
    }
}

