/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.lang.reflect.Method;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.client.renderer.entity.model.BatModel;
import net.minecraft.client.renderer.entity.model.CodModel;
import net.minecraft.client.renderer.entity.model.DolphinModel;
import net.minecraft.client.renderer.entity.model.EnderDragonModel;
import net.minecraft.client.renderer.entity.model.EndermiteModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.GhastModel;
import net.minecraft.client.renderer.entity.model.GuardianModel;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.entity.model.LlamaModel;
import net.minecraft.client.renderer.entity.model.MagmaCubeModel;
import net.minecraft.client.renderer.entity.model.PandaModel;
import net.minecraft.client.renderer.entity.model.PhantomModel;
import net.minecraft.client.renderer.entity.model.PufferFishBigModel;
import net.minecraft.client.renderer.entity.model.PufferFishMediumModel;
import net.minecraft.client.renderer.entity.model.PufferFishSmallModel;
import net.minecraft.client.renderer.entity.model.RavagerModel;
import net.minecraft.client.renderer.entity.model.SalmonModel;
import net.minecraft.client.renderer.entity.model.SilverfishModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.client.renderer.entity.model.SquidModel;
import net.minecraft.client.renderer.entity.model.TropicalFishAModel;
import net.minecraft.client.renderer.entity.model.TropicalFishBModel;
import net.minecraft.client.renderer.entity.model.WitherModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.util.ResourceLocation;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;

public class EntityIconDefinitions {
    private static Method entityTextureMethod;
    static ImmutableList<String> HEAD_HARDCODED_NAMES;
    static ImmutableList<String> HEAD_PARTS_HARDCODED_NAMES;
    static float slimeSquishBU;
    private static StringBuilder VARIANT_STRING_BUILDER;

    static void customTransformation(EntityModel em, Entity entity, EntityIconPrerenderer prerenderer) {
        if (em instanceof CodModel || em instanceof SalmonModel) {
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (em instanceof TropicalFishAModel || em instanceof TropicalFishBModel) {
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (em instanceof BatModel) {
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (em instanceof HorseModel) {
            GlStateManager.rotatef((float)65.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)0.7f, (float)0.7f, (float)0.7f);
        } else if (em instanceof DolphinModel) {
            GlStateManager.scalef((float)0.7f, (float)0.7f, (float)0.7f);
        } else if (em instanceof GuardianModel || em instanceof SquidModel) {
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (em instanceof LlamaModel) {
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (entity instanceof SlimeEntity) {
            SlimeEntity slime = (SlimeEntity)entity;
            slimeSquishBU = slime.field_70811_b;
            slime.field_70811_b = 0.0f;
        } else if (em instanceof GhastModel || em instanceof RavagerModel || em instanceof EnderDragonModel) {
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (em instanceof WitherModel) {
            GlStateManager.scalef((float)0.35f, (float)0.35f, (float)0.35f);
        } else if (em instanceof PhantomModel) {
            GlStateManager.scalef((float)0.3f, (float)0.3f, (float)0.3f);
            GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (em instanceof PandaModel) {
            GlStateManager.scalef((float)0.7f, (float)0.7f, (float)0.7f);
        }
    }

    public static void customPostRenderTransformation(EntityModel entityModel, Entity entity) {
        if (entity instanceof SlimeEntity) {
            SlimeEntity slime = (SlimeEntity)entity;
            slime.field_70811_b = slimeSquishBU;
        }
    }

    static boolean fullModelIcon(EntityModel em) {
        return em instanceof CodModel || em instanceof TropicalFishAModel || em instanceof TropicalFishBModel || em instanceof EndermiteModel || em instanceof MagmaCubeModel || em instanceof SlimeModel || em instanceof PufferFishBigModel || em instanceof PufferFishMediumModel || em instanceof PufferFishSmallModel || em instanceof SilverfishModel || em instanceof WitherModel;
    }

    public static EntityIconCustomRenderer getCustomLayer(EntityRenderer entityRenderer, Entity entity) {
        return null;
    }

    public static void buildVariantIdString(StringBuilder stringBuilder, EntityRenderer entityRenderer, Entity entity) {
        ResourceLocation entityTexture = EntityIconDefinitions.getEntityTexture(entityRenderer, entity);
        if (entityTexture == null) {
            return;
        }
        stringBuilder.append(entityTexture);
        if (entityRenderer instanceof VillagerRenderer || entityRenderer instanceof ZombieVillagerRenderer) {
            VillagerData villagerdata = ((IVillagerDataHolder)entity).func_213700_eh();
            IVillagerType villagertype = villagerdata.func_221129_a();
            VillagerProfession villagerprofession = villagerdata.func_221130_b();
            int villagerprofessionlevel = villagerdata.func_221132_c();
            stringBuilder.append("%").append(((LivingEntity)entity).func_70631_g_()).append("%").append(villagertype).append("%").append(villagerprofession).append("%").append(villagerprofessionlevel);
        } else if (entityRenderer instanceof CatRenderer) {
            stringBuilder.append("%").append(((CatEntity)entity).func_70909_n());
        } else if (entityRenderer instanceof WolfRenderer) {
            stringBuilder.append("%").append(((WolfEntity)entity).func_70909_n());
        } else if (entityRenderer instanceof LlamaRenderer) {
            LlamaEntity llama = (LlamaEntity)entity;
            stringBuilder.append("%").append(llama.func_213800_eB()).append("%").append(llama.func_190704_dO());
        } else if (entityRenderer instanceof PigRenderer) {
            PigEntity pig = (PigEntity)entity;
            stringBuilder.append("%").append(pig.func_70901_n());
        } else if (entityRenderer instanceof TropicalFishRenderer) {
            TropicalFishEntity fish = (TropicalFishEntity)entity;
            stringBuilder.append("%").append(fish.func_204221_dB());
        }
    }

    public static String getVariantString(EntityRenderer entityRenderer, Entity entity) {
        StringBuilder stringBuilder = VARIANT_STRING_BUILDER;
        stringBuilder.setLength(0);
        EntityIconDefinitions.buildVariantIdString(stringBuilder, entityRenderer, entity);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceLocation getEntityTexture(EntityRenderer entityRenderer, Entity e) {
        boolean accessibleBU = entityTextureMethod.isAccessible();
        try {
            entityTextureMethod.setAccessible(true);
            try {
                ResourceLocation resourceLocation = (ResourceLocation)entityTextureMethod.invoke((Object)entityRenderer, e);
                return resourceLocation;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                ResourceLocation resourceLocation = null;
                entityTextureMethod.setAccessible(accessibleBU);
                return resourceLocation;
            }
        }
        finally {
            entityTextureMethod.setAccessible(accessibleBU);
        }
    }

    static {
        HEAD_HARDCODED_NAMES = ImmutableList.of((Object)"net.minecraft.client.renderer.entity.model.BatModel;batHead", (Object)"net.minecraft.client.renderer.entity.model.BatModel;field_82895_a", (Object)"net.minecraft.client.renderer.entity.model.BlazeModel;blazeHead", (Object)"net.minecraft.client.renderer.entity.model.BlazeModel;field_78105_b", (Object)"net.minecraft.client.renderer.entity.model.SpiderModel;spiderHead", (Object)"net.minecraft.client.renderer.entity.model.SpiderModel;field_78209_a", (Object)"net.minecraft.client.renderer.entity.model.CodModel;headFront", (Object)"net.minecraft.client.renderer.entity.model.CodModel;field_203726_d", (Object)"net.minecraft.client.renderer.entity.model.CreeperModel;head", (Object)"net.minecraft.client.renderer.entity.model.CreeperModel;field_78135_a", (Object)"net.minecraft.client.renderer.entity.model.ParrotModel;head", (Object)"net.minecraft.client.renderer.entity.model.ParrotModel;field_192768_e", (Object[])new String[]{"net.minecraft.client.renderer.entity.model.PhantomModel;body", "net.minecraft.client.renderer.entity.model.PhantomModel;field_203070_a", "net.minecraft.client.renderer.entity.model.RabbitModel;rabbitHead", "net.minecraft.client.renderer.entity.model.RabbitModel;field_178704_h", "net.minecraft.client.renderer.entity.model.RavagerModel;head", "net.minecraft.client.renderer.entity.model.RavagerModel;field_217168_a", "net.minecraft.client.renderer.entity.model.SquidModel;body", "net.minecraft.client.renderer.entity.model.SquidModel;field_78202_a", "", "net.minecraft.client.renderer.entity.model.StriderModel;field_239120_f_", "net.minecraft.client.renderer.entity.model.IronGolemModel;ironGolemHead", "net.minecraft.client.renderer.entity.model.IronGolemModel;field_78178_a", "net.minecraft.client.renderer.entity.model.SnowManModel;head", "net.minecraft.client.renderer.entity.model.SnowManModel;field_78195_c", "net.minecraft.client.renderer.entity.model.EnderDragonModel;head", "net.minecraft.client.renderer.entity.model.EnderDragonModel;field_78221_a", "", "net.minecraft.client.renderer.entity.model.SalmonModel;field_203762_b", "", "net.minecraft.client.renderer.entity.model.OcelotModel;field_78156_g", "", "net.minecraft.client.renderer.entity.model.ChickenModel;field_78142_a", "", "net.minecraft.client.renderer.entity.model.DolphinModel;field_205082_b", "", "net.minecraft.client.renderer.entity.model.GuardianModel;field_178710_a", "", "net.minecraft.client.renderer.entity.model.HorseModel;field_217128_b", "", "net.minecraft.client.renderer.entity.model.MagmaCubeModel;field_78108_b", "", "net.minecraft.client.renderer.entity.model.FoxModel;field_217115_a", "", "net.minecraft.client.renderer.entity.model.WolfModel;field_78185_a", "", "net.minecraft.client.renderer.entity.model.GhastModel;field_78128_a", "net.minecraft.client.renderer.entity.model.ShulkerModel;head", "net.minecraft.client.renderer.entity.model.ShulkerModel;field_187066_a"});
        HEAD_PARTS_HARDCODED_NAMES = ImmutableList.of((Object)"net.minecraft.client.renderer.entity.model.RabbitModel;rabbitRightEar", (Object)"net.minecraft.client.renderer.entity.model.RabbitModel;field_178705_i", (Object)"net.minecraft.client.renderer.entity.model.RabbitModel;rabbitLeftEar", (Object)"net.minecraft.client.renderer.entity.model.RabbitModel;field_178702_j", (Object)"net.minecraft.client.renderer.entity.model.RabbitModel;rabbitNose", (Object)"net.minecraft.client.renderer.entity.model.RabbitModel;field_178700_l", (Object)"", (Object)"net.minecraft.client.renderer.entity.model.SalmonModel;field_203761_a", (Object)"", (Object)"net.minecraft.client.renderer.entity.model.SalmonModel;field_203763_c", (Object)"", (Object)"net.minecraft.client.renderer.entity.model.SalmonModel;field_203767_g", (Object[])new String[]{"", "net.minecraft.client.renderer.entity.model.SalmonModel;field_203768_h", "", "net.minecraft.client.renderer.entity.model.ChickenModel;field_78137_g", "", "net.minecraft.client.renderer.entity.model.ChickenModel;field_78143_h"});
        VARIANT_STRING_BUILDER = new StringBuilder();
        try {
            entityTextureMethod = EntityRenderer.class.getDeclaredMethod("func_110775_a", Entity.class);
        }
        catch (Exception e) {
            try {
                entityTextureMethod = EntityRenderer.class.getDeclaredMethod("getEntityTexture", Entity.class);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
    }
}

