/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.opengl.GL11;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;

public class EntityIconManager {
    private EntityIconPrerenderer prerenderer;
    private Map<ResourceLocation, EntityIconDefinition> iconDefinitions;
    private Map<String, Integer> cachedTextures;
    private Map<String, Integer> cachedResourceTextures;
    private boolean canPrerender;
    private Gson gson;
    private StringBuilder entityStringBuilder;
    private EntityIconModelConfig defaultModelConfig;

    public EntityIconManager(EntityIconPrerenderer prerenderer) {
        this.prerenderer = prerenderer;
        this.iconDefinitions = new HashMap<ResourceLocation, EntityIconDefinition>();
        this.cachedTextures = new HashMap<String, Integer>();
        this.cachedResourceTextures = new HashMap<String, Integer>();
        this.gson = new Gson();
        this.resetResources();
        this.entityStringBuilder = new StringBuilder();
        this.defaultModelConfig = new EntityIconModelConfig();
    }

    public <T extends Entity> int getEntityHeadTexture(T entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, boolean[] spriteBased, boolean debug, boolean debugEntityVariantIds) {
        LivingEntity livingEntity;
        ItemStack headItemStack;
        ResourceLocation entityId = EntityType.func_200718_a((EntityType)entity.func_200600_R());
        EntityIconDefinition iconDefinition = this.iconDefinitions.get(entityId);
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        EntityRenderer entityRenderer = renderManager.func_78713_a(entity);
        StringBuilder entityStringBuilder = this.entityStringBuilder;
        entityStringBuilder.setLength(0);
        boolean variantIdAppended = false;
        if (iconDefinition != null) {
            Method variantIdBuilderMethod = iconDefinition.getVariantIdBuilderMethod();
            if (variantIdBuilderMethod != null) {
                try {
                    variantIdBuilderMethod.invoke(null, entityStringBuilder, entityRenderer, entity);
                    variantIdAppended = true;
                }
                catch (Exception e) {
                    System.out.println("Exception while using the variant builder ID method " + iconDefinition.getVariantIdBuilderMethodString() + " defined for " + entityId);
                    e.printStackTrace();
                    iconDefinition.setVariantIdBuilderMethod(null);
                }
            } else {
                Method variantOldIdMethod = iconDefinition.getOldVariantIdMethod();
                if (variantOldIdMethod != null) {
                    try {
                        String entityVariantString = (String)variantOldIdMethod.invoke(null, entityRenderer, entity);
                        entityStringBuilder.append(entityVariantString);
                        variantIdAppended = true;
                    }
                    catch (Exception e) {
                        System.out.println("Exception while using the variant ID method " + iconDefinition.getOldVariantIdMethodString() + " defined for " + entityId);
                        e.printStackTrace();
                        iconDefinition.setOldVariantIdMethod(null);
                    }
                }
            }
        }
        if (!variantIdAppended) {
            EntityIconDefinitions.buildVariantIdString(entityStringBuilder, entityRenderer, entity);
        }
        String entityVariantString = entityStringBuilder.toString();
        entityStringBuilder.append("%").append(entity.func_70022_Q());
        if (entity instanceof LivingEntity && (headItemStack = (livingEntity = (LivingEntity)entity).func_184582_a(EquipmentSlotType.HEAD)) != null && headItemStack != ItemStack.field_190927_a) {
            entityStringBuilder.append("%").append(headItemStack.func_77973_b().getRegistryName());
        }
        String cacheKey = entityStringBuilder.toString();
        Integer cachedValue = this.cachedTextures.get(cacheKey);
        spriteBased[0] = false;
        if (cachedValue == null) {
            cachedValue = this.cachedResourceTextures.get(cacheKey);
            if (cachedValue == null) {
                ResourceLocation iconType;
                if (debugEntityVariantIds) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent(entityVariantString));
                }
                String variantMapKey = entityVariantString;
                if (iconDefinition != null) {
                    iconType = iconDefinition.getVariantType(variantMapKey);
                    if (iconType == null) {
                        variantMapKey = "default";
                        iconType = iconDefinition.getVariantType(variantMapKey);
                    }
                } else {
                    iconType = EntityIconDefinition.MODEL_TYPE;
                }
                if (iconType == EntityIconDefinition.MODEL_TYPE) {
                    if (this.canPrerender) {
                        EntityIconModelConfig variantModelConfig;
                        EntityIconModelConfig modelConfig = this.defaultModelConfig;
                        EntityIconModelConfig entityIconModelConfig = variantModelConfig = iconDefinition == null ? null : iconDefinition.getModelConfig(variantMapKey);
                        if (variantModelConfig != null) {
                            modelConfig = variantModelConfig;
                        }
                        cachedValue = this.prerenderer.prerender(entityRenderer, entity, defaultFramebuffer, helper, scale, modelConfig, debug);
                        this.cachedTextures.put(cacheKey, cachedValue);
                        if (cachedValue != -1) {
                            this.canPrerender = false;
                        }
                    } else {
                        cachedValue = -1;
                    }
                } else if (iconType == EntityIconDefinition.DOT_TYPE) {
                    cachedValue = -1;
                    this.cachedTextures.put(cacheKey, cachedValue);
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(iconType);
                    GL11.glTexParameteri((int)3553, (int)33085, (int)3);
                    GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                    GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
                    GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9985);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
                    GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
                    this.prerenderer.generateMipmaps();
                    cachedValue = GL11.glGetInteger((int)32873);
                    this.cachedResourceTextures.put(cacheKey, cachedValue);
                    spriteBased[0] = true;
                }
            } else {
                spriteBased[0] = true;
            }
        }
        return cachedValue;
    }

    public void reset() {
        for (Integer value : this.cachedTextures.values()) {
            if (value == null || value <= 0) continue;
            GlStateManager.deleteTexture((int)value);
        }
        this.cachedTextures.clear();
        System.out.println("Entity icon manager reset!");
    }

    public void resetResources() {
        System.out.println("Reloading entity icon resources...");
        Set entityIds = ForgeRegistries.ENTITIES.getKeys();
        Gson gson = this.gson;
        int attempts = 5;
        for (int i = 0; i < attempts; ++i) {
            try {
                this.resetResourcesAttempt(gson, entityIds);
                break;
            }
            catch (IOException ioe) {
                if (i != attempts - 1) continue;
                throw new RuntimeException(ioe);
            }
        }
        System.out.println("Done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetResourcesAttempt(Gson gson, Set<ResourceLocation> entityIds) throws IOException {
        this.cachedResourceTextures.clear();
        this.iconDefinitions.clear();
        for (ResourceLocation id : entityIds) {
            InputStream resourceInput = null;
            BufferedReader reader = null;
            String entityDefinitionJson = null;
            IResource resource = null;
            try {
                resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("xaerominimap", "entity/icon/definition/" + id.func_110624_b() + "/" + id.func_110623_a() + ".json"));
            }
            catch (FileNotFoundException fnfe) {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                if (resource == null) continue;
                resourceInput = resource.func_199027_b();
                reader = new BufferedReader(new InputStreamReader(resourceInput));
                StringBuilder stringBuilder = new StringBuilder();
                reader.lines().forEach(line -> {
                    stringBuilder.append((String)line);
                    stringBuilder.append('\n');
                });
                entityDefinitionJson = stringBuilder.toString();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                EntityIconDefinition entityIconDefinition = (EntityIconDefinition)gson.fromJson(entityDefinitionJson, EntityIconDefinition.class);
                entityIconDefinition.onConstruct(id);
                this.iconDefinitions.put(id, entityIconDefinition);
            }
            catch (JsonSyntaxException jse) {
                System.out.println("Json syntax exception when loading the entity icon definition for " + id + ".");
                jse.printStackTrace();
            }
        }
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }

    public void onModelPartRenderDetection(RendererModel modelRenderer) {
        this.prerenderer.onModelPartRenderDetection(modelRenderer);
    }
}

