/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.mojang.blaze3d.platform.GlStateManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.QuadrupedModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.ModelBox;
import org.lwjgl.opengl.GL11;
import xaero.common.minimap.render.radar.ModelPartRenderDetectionInfo;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;

public class EntityIconModelPartsRenderer {
    public Field quadrupedHeadField;
    private Field cubeListField;
    private Field childModelsField;

    public EntityIconModelPartsRenderer() {
        try {
            this.quadrupedHeadField = QuadrupedModel.class.getDeclaredField("field_78150_a");
        }
        catch (NoSuchFieldException e) {
            try {
                this.quadrupedHeadField = QuadrupedModel.class.getDeclaredField("field_78150_a");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.cubeListField = RendererModel.class.getDeclaredField("field_78804_l");
        }
        catch (NoSuchFieldException e) {
            try {
                this.cubeListField = RendererModel.class.getDeclaredField("cubeList");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.childModelsField = RendererModel.class.getDeclaredField("field_78805_m");
        }
        catch (NoSuchFieldException e) {
            try {
                this.childModelsField = RendererModel.class.getDeclaredField("childModels");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ModelBox> getCubeList(RendererModel RendererModel2) {
        boolean accessibleBU = this.cubeListField.isAccessible();
        this.cubeListField.setAccessible(true);
        try {
            List list = (List)this.cubeListField.get(RendererModel2);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.cubeListField.setAccessible(accessibleBU);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RendererModel> getChildModels(RendererModel modelRenderer) {
        boolean accessibleBU = this.childModelsField.isAccessible();
        this.childModelsField.setAccessible(true);
        try {
            List list = (List)this.childModelsField.get(modelRenderer);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.childModelsField.setAccessible(accessibleBU);
        }
        return null;
    }

    private boolean hasCubes(RendererModel mr) {
        List<ModelBox> mrCubeList = this.getCubeList(mr);
        if (mrCubeList != null && !mrCubeList.isEmpty()) {
            return true;
        }
        List<RendererModel> mrChildren = this.getChildModels(mr);
        if (mrChildren != null) {
            for (RendererModel child : mrChildren) {
                if (!this.hasCubes(child)) continue;
                return true;
            }
        }
        return false;
    }

    public void renderPart(RendererModel mr, ArrayList<RendererModel> renderedModels, RendererModel mainModelPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (mr == null) {
            return;
        }
        if (renderedModels.contains(mr)) {
            return;
        }
        ModelPartRenderDetectionInfo renderInfo = mrde.getModelPartRenderInfo(mr);
        if (renderInfo == null) {
            return;
        }
        if (!this.hasCubes(mr)) {
            return;
        }
        float rotationPointBUX = mr.field_78800_c;
        float rotationPointBUY = mr.field_78797_d;
        float rotationPointBUZ = mr.field_78798_e;
        float rotateAngleBUX = mr.field_78795_f;
        float rotateAngleBUY = mr.field_78796_g;
        float rotateAngleBUZ = mr.field_78808_h;
        boolean showModelBU = mr.field_78806_j;
        boolean isHiddenBU = mr.field_78807_k;
        float centerPointX = mainModelPart.field_78800_c;
        float centerPointY = mainModelPart.field_78797_d;
        float centerPointZ = mainModelPart.field_78798_e;
        List<ModelBox> mainCubeList = this.getCubeList(mainModelPart);
        if (mainCubeList != null && !mainCubeList.isEmpty()) {
            ModelBox firstBox = mainCubeList.get(0);
            centerPointX += (firstBox.field_78248_d + firstBox.field_78252_a) / 2.0f;
            centerPointY += (firstBox.field_78249_e + firstBox.field_78250_b) / 2.0f;
            centerPointZ += (firstBox.field_78246_f + firstBox.field_78251_c) / 2.0f;
        }
        if (zeroRotation) {
            mr.field_78795_f = 0.0f;
            mr.field_78796_g = 0.0f;
            mr.field_78808_h = 0.0f;
        }
        mr.field_78806_j = true;
        mr.field_78807_k = false;
        GlStateManager.color4f((float)renderInfo.red, (float)renderInfo.green, (float)renderInfo.blue, (float)renderInfo.alpha);
        try {
            mr.func_78793_a(mr.field_78800_c - centerPointX, mr.field_78797_d - centerPointY, mr.field_78798_e - centerPointZ);
            mr.func_78785_a(0.0625f);
            renderedModels.add(mr);
        }
        catch (Throwable t) {
            System.out.println("Exception when rendering entity part. " + mr);
        }
        while (GL11.glGetError() != 0) {
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mr.field_78800_c = rotationPointBUX;
        mr.field_78797_d = rotationPointBUY;
        mr.field_78798_e = rotationPointBUZ;
        if (zeroRotation) {
            mr.field_78795_f = rotateAngleBUX;
            mr.field_78796_g = rotateAngleBUY;
            mr.field_78808_h = rotateAngleBUZ;
        }
        mr.field_78806_j = showModelBU;
        mr.field_78807_k = isHiddenBU;
    }

    public RendererModel renderDeclaredMethod(Method m, EntityModel entityModel, ArrayList<RendererModel> renderedModels, RendererModel mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Iterable<RendererModel> renderers = this.handleDeclaredMethod(m, entityModel);
        return this.renderPartsIterable(renderers, renderedModels, mainPart, zeroRotation, mrde);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<RendererModel> handleDeclaredMethod(Method m, EntityModel entityModel) {
        if (m != null) {
            boolean accessibleBU = m.isAccessible();
            m.setAccessible(true);
            try {
                Iterable iterable = (Iterable)m.invoke((Object)entityModel, new Object[0]);
                return iterable;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                m.setAccessible(accessibleBU);
            }
        }
        return null;
    }

    public RendererModel renderPartsIterable(Iterable<RendererModel> parts, ArrayList<RendererModel> renderedModels, RendererModel mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<RendererModel> partsIterator = parts.iterator();
        if (partsIterator.hasNext()) {
            if (mainPart == null) {
                mainPart = partsIterator.next();
                this.renderPart(mainPart, renderedModels, mainPart, zeroRotation, mrde);
            }
            while (partsIterator.hasNext()) {
                this.renderPart(partsIterator.next(), renderedModels, mainPart, zeroRotation, mrde);
            }
        }
        return mainPart;
    }
}

