/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.entity.model.QuadrupedModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import xaero.common.core.IXaeroMinimapModelRenderer;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconModelPartsRenderer;
import xaero.common.minimap.render.radar.LivingEntityRotationResetter;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;
import xaero.common.misc.Misc;

public class EntityIconPrerenderer {
    private static final RendererModel[] ONE_RENDERER_ARRAY = new RendererModel[1];
    private static final boolean TEST_ALL_FIELDS = false;
    private static ArrayList<String> failedFields = new ArrayList();
    private ImprovedFramebuffer modelRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer iconScaleFramebuffer;
    private EntityIconModelPartsRenderer entityModelPartsRenderer;
    private LivingEntityRotationResetter livingEntityRotationResetter;
    public static boolean DETECTING_MODEL_RENDERS;
    private EntityRenderer modelRenderDetectionEntityRenderer;
    private Class<?> modelRenderDetectionEntityModelClass;
    private List<ModelRenderDetectionElement> modelRenderDetectionList;
    private ModelRenderDetectionElement lastModelRenderDetected;
    private Field blendStateField;
    private Field colorMaskStateField;
    private Field depthStateField;
    private Field blendStateSrcFactorField;
    private Field blendStateDestFactorField;
    private Field blendStateAlphaSrcFactorField;
    private Field blendStateAlphaDestFactorField;
    private Field colorMaskStateRedField;
    private Field colorMaskStateGreenField;
    private Field colorMaskStateBlueField;
    private Field colorMaskStateAlphaField;
    private Field depthStateFuncField;
    private Field depthStateMaskField;
    private Field depthStateTestField;
    private Field booleanStateCurrentStateField;
    private Field cullStateField;
    private Field cullStateEnabledField;
    private Field cullStateModeField;
    private Field textureStatesField;
    private Field textureStateIdField;
    private Field activeTextureField;
    private Field colorStateField;
    private Field colorStateRedField;
    private Field colorStateGreenField;
    private Field colorStateBlueField;
    private Field colorStateAlphaField;

    public EntityIconPrerenderer() {
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.iconScaleFramebuffer = new ImprovedFramebuffer(64, 64, false);
        OpenGLException.checkGLError();
        GlStateManager.deleteTexture((int)this.iconScaleFramebuffer.getFramebufferTexture());
        OpenGLException.checkGLError();
        this.entityModelPartsRenderer = new EntityIconModelPartsRenderer();
        this.livingEntityRotationResetter = new LivingEntityRotationResetter();
        this.modelRenderFramebuffer.func_147612_c();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.texImage2D((int)3553, (int)0, (int)32856, (int)this.modelRenderFramebuffer.field_147621_c, (int)this.modelRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.bindTexture((int)0);
        this.iconRenderFramebuffer.func_147612_c();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        if (!GL.getCapabilities().OpenGL30) {
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.texImage2D((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_147621_c, (int)this.iconRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.bindTexture((int)0);
        this.modelRenderDetectionList = new ArrayList<ModelRenderDetectionElement>();
        this.blendStateField = Misc.getFieldReflection(GlStateManager.class, "field_225661_f_", "BLEND");
        this.colorMaskStateField = Misc.getFieldReflection(GlStateManager.class, "field_225674_v_", "COLOR_MASK");
        this.depthStateField = Misc.getFieldReflection(GlStateManager.class, "field_225662_g_", "DEPTH");
        this.textureStatesField = Misc.getFieldReflection(GlStateManager.class, "field_225671_s_", "TEXTURES");
        this.cullStateField = Misc.getFieldReflection(GlStateManager.class, "field_225664_i_", "CULL");
        try {
            Class<?> blendStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$BlendState");
            this.blendStateSrcFactorField = Misc.getFieldReflection(blendStateClass, "field_179211_b", "srcFactorRgb");
            this.blendStateDestFactorField = Misc.getFieldReflection(blendStateClass, "field_179212_c", "dstFactorRgb");
            this.blendStateAlphaSrcFactorField = Misc.getFieldReflection(blendStateClass, "field_179209_d", "srcFactorAlpha");
            this.blendStateAlphaDestFactorField = Misc.getFieldReflection(blendStateClass, "field_179210_e", "dstFactorAlpha");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> colorMaskStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$ColorMask");
            this.colorMaskStateRedField = Misc.getFieldReflection(colorMaskStateClass, "field_179188_a", "red");
            this.colorMaskStateGreenField = Misc.getFieldReflection(colorMaskStateClass, "field_179186_b", "green");
            this.colorMaskStateBlueField = Misc.getFieldReflection(colorMaskStateClass, "field_179187_c", "blue");
            this.colorMaskStateAlphaField = Misc.getFieldReflection(colorMaskStateClass, "field_179185_d", "alpha");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> depthStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$DepthState");
            this.depthStateTestField = Misc.getFieldReflection(depthStateClass, "field_179052_a", "test");
            this.depthStateFuncField = Misc.getFieldReflection(depthStateClass, "field_179051_c", "func");
            this.depthStateMaskField = Misc.getFieldReflection(depthStateClass, "field_179050_b", "mask");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> cullStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$CullState");
            this.cullStateEnabledField = Misc.getFieldReflection(cullStateClass, "field_179054_a", "cullFace");
            this.cullStateModeField = Misc.getFieldReflection(cullStateClass, "field_179053_b", "mode");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> booleanStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$BooleanState");
            this.booleanStateCurrentStateField = Misc.getFieldReflection(booleanStateClass, "field_179201_b", "currentState");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> textureStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$TextureState");
            this.textureStateIdField = Misc.getFieldReflection(textureStateClass, "field_179059_b", "field_179059_b");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.activeTextureField = Misc.getFieldReflection(GlStateManager.class, "field_225670_r_", "activeTexture");
        this.colorStateField = Misc.getFieldReflection(GlStateManager.class, "field_225675_w_", "COLOR");
        try {
            Class<?> colorStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$Color");
            this.colorStateRedField = Misc.getFieldReflection(colorStateClass, "field_179195_a", "field_179195_a");
            this.colorStateGreenField = Misc.getFieldReflection(colorStateClass, "field_179193_b", "field_179193_b");
            this.colorStateBlueField = Misc.getFieldReflection(colorStateClass, "field_179194_c", "field_179194_c");
            this.colorStateAlphaField = Misc.getFieldReflection(colorStateClass, "field_179192_d", "field_179192_d");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testField(ImmutableList<String> fields) throws NoSuchFieldException, SecurityException {
        boolean odd = true;
        boolean pairFirstFailed = false;
        String prevS = null;
        UnmodifiableIterator unmodifiableIterator = fields.iterator();
        while (unmodifiableIterator.hasNext()) {
            String s = (String)unmodifiableIterator.next();
            try {
                boolean bl = odd = !odd;
                if (!odd) {
                    pairFirstFailed = false;
                }
                boolean failed = false;
                if (!s.isEmpty()) {
                    String[] fieldArgs = s.split(";");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fieldArgs[0]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        System.out.println("Skipping testing a class: " + fieldArgs[0]);
                        prevS = s;
                        continue;
                    }
                    try {
                        c.getDeclaredField(fieldArgs[1]);
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    if (!odd) {
                        pairFirstFailed = true;
                    } else if (pairFirstFailed) {
                        failedFields.add(prevS);
                        failedFields.add(s);
                    }
                }
                prevS = s;
            }
            catch (Throwable throwable) {
                prevS = s;
                throw throwable;
            }
        }
        return;
    }

    public int prerender(EntityRenderer entityRenderer, Entity entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, EntityIconModelConfig modelConfig, boolean debug) {
        LivingEntity livingEntity;
        ImprovedFramebuffer modelRenderFramebuffer = this.modelRenderFramebuffer;
        ImprovedFramebuffer iconRenderFramebuffer = this.iconRenderFramebuffer;
        ImprovedFramebuffer iconScaleFramebuffer = this.iconScaleFramebuffer;
        int finalIconSize = iconScaleFramebuffer.field_147621_c;
        OpenGLException.checkGLError();
        modelRenderFramebuffer.func_147610_a(true);
        int farPlane = 500;
        this.setupMatrices(finalIconSize, farPlane);
        OpenGLException.checkGLError();
        GlStateManager.enableDepthTest();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DETECTING_MODEL_RENDERS = true;
        this.modelRenderDetectionEntityRenderer = entityRenderer;
        this.modelRenderDetectionEntityModelClass = null;
        this.modelRenderDetectionList.clear();
        this.lastModelRenderDetected = null;
        GlStateManager.disableCull();
        if (Minecraft.func_71410_x().func_175598_ae().field_217783_c != null) {
            GlStateManager.pushMatrix();
            try {
                entityRenderer.func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
                OpenGLException.checkGLError();
            }
            catch (Exception e) {
                this.modelRenderDetectionList.clear();
                System.out.println("Exception when calling the full entity renderer before rendering the icon. " + entity.func_70022_Q());
                e.printStackTrace();
            }
            GlStateManager.popMatrix();
            while (GL11.glGetError() != 0) {
            }
        } else {
            System.out.println("Render info was null for entity " + entity.func_70022_Q());
        }
        GlStateManager.disableDepthTest();
        GlStateManager.activeTexture((int)33985);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)33984);
        RenderHelper.func_74518_a();
        DETECTING_MODEL_RENDERS = false;
        EntityModel entityModel = this.getEntityRendererModel(entityRenderer);
        if (entityModel == null) {
            this.endModelRendering(modelRenderFramebuffer);
            defaultFramebuffer.func_147610_a(true);
            this.restoreMatrices(helper);
            return -1;
        }
        GlStateManager.disableAlphaTest();
        GlStateManager.disableBlend();
        GlStateManager.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.clear((int)16640, (boolean)Minecraft.field_142025_a);
        GlStateManager.enableBlend();
        GlStateManager.enableDepthTest();
        GlStateManager.disableCull();
        GlStateManager.depthFunc((int)515);
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        if (debug) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)10.0f, (float)-10.0f);
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
            AbstractGui.fill((int)0, (int)0, (int)9, (int)9, (int)-65536);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.popMatrix();
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(finalIconSize / 2), (double)(finalIconSize / 2), (double)-450.0);
        GlStateManager.translatef((float)modelConfig.offsetX, (float)(-modelConfig.offsetY), (float)0.0f);
        int mainScale = finalIconSize / 2;
        GlStateManager.scalef((float)mainScale, (float)(-mainScale), (float)(-mainScale));
        if (scale < 1.0f) {
            GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        }
        GlStateManager.scalef((float)modelConfig.baseScale, (float)modelConfig.baseScale, (float)modelConfig.baseScale);
        EntityIconDefinitions.customTransformation(entityModel, entity, this);
        GlStateManager.rotatef((float)modelConfig.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)modelConfig.rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)modelConfig.rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
        LivingEntity livingEntity2 = livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity != null) {
            this.livingEntityRotationResetter.rememberAndResetValues(livingEntity);
        }
        boolean renderedSomething = this.renderIcon(entityRenderer, entityModel, this.modelRenderDetectionList, (Entity)((LivingEntity)entity), modelConfig);
        if (livingEntity != null) {
            this.livingEntityRotationResetter.restore(livingEntity);
        }
        EntityIconDefinitions.customPostRenderTransformation(entityModel, entity);
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
        if (debug) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)9.0f, (float)10.0f, (float)-10.0f);
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
            AbstractGui.fill((int)0, (int)0, (int)9, (int)9, (int)-16711936);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.popMatrix();
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        this.endModelRendering(modelRenderFramebuffer);
        int entityScaledIconTextureId = -1;
        if (renderedSomething) {
            iconRenderFramebuffer.func_147610_a(true);
            GlStateManager.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.clear((int)16384, (boolean)Minecraft.field_142025_a);
            GlStateManager.disableBlend();
            if (debug) {
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)18.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
                AbstractGui.fill((int)0, (int)0, (int)9, (int)9, (int)-16776961);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.popMatrix();
                GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            modelRenderFramebuffer.func_147612_c();
            GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
                for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                    if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                    helper.drawMyTexturedModalRect(shadowOffsetX, finalIconSize + shadowOffsetY, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
                }
            }
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            if (debug) {
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)27.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
                AbstractGui.fill((int)0, (int)0, (int)9, (int)9, (int)-16711681);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.popMatrix();
                GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.enableBlend();
            iconRenderFramebuffer.func_147609_e();
            iconRenderFramebuffer.func_147612_c();
            iconRenderFramebuffer.generateMipmaps();
            GlStateManager.bindTexture((int)0);
            entityScaledIconTextureId = GlStateManager.genTexture();
            OpenGLException.checkGLError();
            GlStateManager.bindTexture((int)entityScaledIconTextureId);
            EntityIconPrerenderer.setupIconTextureParams();
            OpenGLException.checkGLError();
            GlStateManager.texImage2D((int)3553, (int)0, (int)32856, (int)iconScaleFramebuffer.field_147621_c, (int)iconScaleFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
            GlStateManager.bindTexture((int)0);
            OpenGLException.checkGLError();
            iconScaleFramebuffer.func_147610_a(true);
            iconScaleFramebuffer.setFramebufferTexture(entityScaledIconTextureId);
            iconScaleFramebuffer.func_147611_b();
            iconRenderFramebuffer.func_147612_c();
            GlStateManager.disableAlphaTest();
            GlStateManager.disableBlend();
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            if (debug) {
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)36.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
                AbstractGui.fill((int)0, (int)0, (int)9, (int)9, (int)-256);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.popMatrix();
                GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.enableAlphaTest();
            GlStateManager.enableBlend();
            GlStateManager.bindTexture((int)0);
        }
        this.restoreMatrices(helper);
        iconScaleFramebuffer.func_147609_e();
        defaultFramebuffer.func_147610_a(true);
        return entityScaledIconTextureId;
    }

    private void setupMatrices(int finalIconSize, int farPlane) {
        GlStateManager.matrixMode((int)5889);
        GlStateManager.loadIdentity();
        GlStateManager.ortho((double)0.0, (double)finalIconSize, (double)0.0, (double)finalIconSize, (double)-1.0, (double)farPlane);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
    }

    private void restoreMatrices(MinimapRendererHelper helper) {
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5889);
        helper.defaultOrtho();
        GlStateManager.matrixMode((int)5888);
    }

    private void endModelRendering(ImprovedFramebuffer modelRenderFramebuffer) {
        modelRenderFramebuffer.func_147609_e();
        GlStateManager.enableBlend();
        RenderHelper.func_74519_b();
        RenderHelper.func_74518_a();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.0f);
    }

    public static void setupIconTextureParams() {
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    private RendererModel renderModel(EntityRenderer entityRenderer, EntityModel entityModel, Entity entity, EntityIconModelConfig modelConfig, RendererModel mainPart, ArrayList<RendererModel> renderedModels, int entityTexture, boolean forceFieldCheck, boolean fullModelIcon, ModelRenderDetectionElement mrde) {
        boolean isChildBU = entityModel.field_217114_e;
        entityModel.field_217114_e = false;
        if (entityTexture > 0) {
            this.setupModelRenderType(entityTexture, mrde);
            if (modelConfig.modelMainPartFieldAliases != null && !modelConfig.modelMainPartFieldAliases.isEmpty()) {
                mainPart = this.searchSuperclassFields(entityModel, renderedModels, mainPart, modelConfig.modelMainPartFieldAliases, true, modelConfig.modelPartsRotationReset, mrde);
            }
            if (!fullModelIcon && !forceFieldCheck && entityModel instanceof BipedModel) {
                RendererModel headRenderer = ((BipedModel)entityModel).field_78116_c;
                if (mainPart == null) {
                    mainPart = headRenderer;
                }
                RendererModel headWearRenderer = ((BipedModel)entityModel).field_178720_f;
                this.entityModelPartsRenderer.renderPart(headRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                this.entityModelPartsRenderer.renderPart(headWearRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
            } else if (!fullModelIcon && !forceFieldCheck && entityModel instanceof QuadrupedModel) {
                RendererModel headRenderer = null;
                try {
                    headRenderer = EntityIconPrerenderer.handleDeclaredField(this.entityModelPartsRenderer.quadrupedHeadField, entityModel, null)[0];
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (headRenderer != null) {
                    if (mainPart == null) {
                        mainPart = headRenderer;
                    }
                    this.entityModelPartsRenderer.renderPart(headRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
            } else {
                if (!forceFieldCheck && entityModel instanceof IHasHead) {
                    if (mainPart == null) {
                        mainPart = ((IHasHead)entityModel).func_205072_a();
                    }
                    this.entityModelPartsRenderer.renderPart(mainPart, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
                if (modelConfig.modelPartsFields == null) {
                    mainPart = this.searchSuperclassFields(entityModel, renderedModels, mainPart, (List<String>)EntityIconDefinitions.HEAD_HARDCODED_NAMES, true, modelConfig.modelPartsRotationReset, mrde);
                }
                Object headPartsFields = EntityIconDefinitions.HEAD_PARTS_HARDCODED_NAMES;
                if (fullModelIcon) {
                    headPartsFields = null;
                } else if (modelConfig.modelPartsFields != null) {
                    headPartsFields = modelConfig.modelPartsFields;
                }
                mainPart = this.searchSuperclassFields(entityModel, renderedModels, mainPart, (List<String>)headPartsFields, false, modelConfig.modelPartsRotationReset, mrde);
            }
            this.clearModelRenderType();
        }
        entityModel.field_217114_e = isChildBU;
        return mainPart;
    }

    private void setupModelRenderType(int entityTexture, ModelRenderDetectionElement mrde) {
        int blendAlphaSrcFactor = mrde.blendAlphaSrcFactor;
        int blendAlphaDestFactor = mrde.blendAlphaDestFactor;
        if (mrde.blendDestFactor == 1 && mrde.blendSrcFactor != 0) {
            blendAlphaSrcFactor = 0;
            blendAlphaDestFactor = 1;
        }
        GlStateManager.blendFuncSeparate((int)mrde.blendSrcFactor, (int)mrde.blendDestFactor, (int)blendAlphaSrcFactor, (int)blendAlphaDestFactor);
        GlStateManager.colorMask((boolean)mrde.colorMaskR, (boolean)mrde.colorMaskG, (boolean)mrde.colorMaskB, (boolean)mrde.colorMaskA);
        GlStateManager.enableDepthTest();
        GlStateManager.depthMask((boolean)mrde.depthMask);
        GlStateManager.depthFunc((int)(mrde.depthTest ? mrde.depthFunc : 519));
        if (mrde.cullFace) {
            GlStateManager.enableCull();
        }
        GlStateManager.cullFace((GlStateManager.CullFace)(mrde.cullMode == 1029 ? GlStateManager.CullFace.BACK : (mrde.cullMode == 1028 ? GlStateManager.CullFace.FRONT : GlStateManager.CullFace.FRONT_AND_BACK)));
        GlStateManager.bindTexture((int)entityTexture);
    }

    private void clearModelRenderType() {
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.depthFunc((int)515);
        GlStateManager.disableDepthTest();
        GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.disableCull();
        GlStateManager.bindTexture((int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RendererModel[] handleDeclaredField(Field f, EntityModel entityModel, String matchedFilterElement) throws IllegalArgumentException, IllegalAccessException {
        boolean accessibleBU = f.isAccessible();
        try {
            f.setAccessible(true);
            Object fieldValue = f.get(entityModel);
            if (fieldValue instanceof RendererModel[] || fieldValue instanceof Collection) {
                RendererModel[] collectionArray = null;
                if (fieldValue instanceof RendererModel[]) {
                    collectionArray = (RendererModel[])fieldValue;
                } else if (fieldValue instanceof Collection) {
                    Collection collection = (Collection)fieldValue;
                    try {
                        collectionArray = collection.toArray(ONE_RENDERER_ARRAY);
                    }
                    catch (ArrayStoreException ase) {
                        throw new IllegalArgumentException("Field " + f.getName() + " is not a collection of model parts (ModelRenderer on forge).", ase);
                    }
                }
                if (collectionArray.length > 0) {
                    if (matchedFilterElement != null && matchedFilterElement.endsWith("]")) {
                        int lastStartBracket = matchedFilterElement.lastIndexOf(91);
                        if (lastStartBracket == -1) {
                            throw new IllegalArgumentException("Model part field name " + matchedFilterElement + " ends with ] but is missing [!");
                        }
                        try {
                            String[] indicesString = matchedFilterElement.substring(lastStartBracket + 1, matchedFilterElement.length() - 1).split("[,;]");
                            RendererModel[] result = indicesString.length == 1 ? ONE_RENDERER_ARRAY : new RendererModel[indicesString.length];
                            for (int i = 0; i < indicesString.length; ++i) {
                                String indexString = indicesString[i];
                                int elementIndex = Integer.parseInt(indexString.trim());
                                result[i] = collectionArray[elementIndex];
                            }
                            RendererModel[] rendererModelArray = result;
                            return rendererModelArray;
                        }
                        catch (Exception nfe) {
                            throw new IllegalArgumentException("Invalid element index/indices in " + matchedFilterElement + "!", nfe);
                        }
                    }
                    RendererModel[] rendererModelArray = collectionArray;
                    return rendererModelArray;
                }
                throw new IllegalArgumentException("Empty collection referenced " + matchedFilterElement + "!");
            }
            EntityIconPrerenderer.ONE_RENDERER_ARRAY[0] = (RendererModel)fieldValue;
            RendererModel[] rendererModelArray = ONE_RENDERER_ARRAY;
            return rendererModelArray;
        }
        finally {
            f.setAccessible(accessibleBU);
        }
    }

    public RendererModel searchSuperclassFields(EntityModel entityModel, ArrayList<RendererModel> renderedModels, RendererModel mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Class<?> modelClass = entityModel.getClass();
        while (modelClass != EntityModel.class) {
            Field[] declaredModelFields = modelClass.getDeclaredFields();
            mainPart = this.handleFields(entityModel, declaredModelFields, renderedModels, mainPart, filter, justOne, zeroRotation, mrde);
            if ((!justOne || mainPart == null) && (modelClass = modelClass.getSuperclass()) != null) continue;
        }
        return mainPart;
    }

    public RendererModel handleFields(EntityModel entityModel, Field[] declaredModelFields, ArrayList<RendererModel> renderedModels, RendererModel mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        block9: for (Field f : declaredModelFields) {
            try {
                f.getType().asSubclass(RendererModel.class);
            }
            catch (ClassCastException cce) {
                try {
                    f.getType().asSubclass(RendererModel[].class);
                }
                catch (ClassCastException cce1) {
                    try {
                        f.getType().asSubclass(Collection.class);
                    }
                    catch (ClassCastException cce2) {
                        continue;
                    }
                }
            }
            try {
                RendererModel[] renderers;
                String comparisonName = f.getDeclaringClass().getName() + ";" + f.getName();
                String matchedFilterElement = null;
                if (filter != null && (matchedFilterElement = this.passesFilter(comparisonName, filter)) == null) continue;
                for (RendererModel mr : renderers = EntityIconPrerenderer.handleDeclaredField(f, entityModel, matchedFilterElement)) {
                    if (mainPart == null) {
                        mainPart = mr;
                    }
                    this.entityModelPartsRenderer.renderPart(mr, renderedModels, mainPart, zeroRotation, mrde);
                    if (justOne) break block9;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return mainPart;
    }

    private String passesFilter(String entry, List<String> filter) {
        for (String f : filter) {
            if (f.equals(entry)) {
                return f;
            }
            int indexOfBracket = f.lastIndexOf(91);
            if (indexOfBracket == -1 || !f.substring(0, indexOfBracket).equals(entry)) continue;
            return f;
        }
        return null;
    }

    public void generateMipmaps() {
        this.modelRenderFramebuffer.generateMipmaps();
    }

    private void onModelRenderDetection(EntityModel<?> model, float red, float green, float blue, float alpha) {
        Object[] TEXTURES = (Object[])Misc.getReflectFieldValue(null, this.textureStatesField);
        int textureId = (Integer)Misc.getReflectFieldValue(TEXTURES[(Integer)Misc.getReflectFieldValue(null, this.activeTextureField)], this.textureStateIdField);
        Object BLEND = Misc.getReflectFieldValue(null, this.blendStateField);
        Object DEPTH = Misc.getReflectFieldValue(null, this.depthStateField);
        Object COLOR_MASK = Misc.getReflectFieldValue(null, this.colorMaskStateField);
        Object CULL = Misc.getReflectFieldValue(null, this.cullStateField);
        int blendSrcFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateSrcFactorField);
        int blendDestFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateDestFactorField);
        int blendAlphaSrcFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateAlphaSrcFactorField);
        int blendAlphaDestFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateAlphaDestFactorField);
        int depthFunc = (Integer)Misc.getReflectFieldValue(DEPTH, this.depthStateFuncField);
        boolean depthTest = (Boolean)Misc.getReflectFieldValue(Misc.getReflectFieldValue(DEPTH, this.depthStateTestField), this.booleanStateCurrentStateField);
        boolean depthMask = (Boolean)Misc.getReflectFieldValue(DEPTH, this.depthStateMaskField);
        boolean colorMaskR = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateRedField);
        boolean colorMaskG = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateGreenField);
        boolean colorMaskB = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateBlueField);
        boolean colorMaskA = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateAlphaField);
        boolean cullFace = (Boolean)Misc.getReflectFieldValue(Misc.getReflectFieldValue(CULL, this.cullStateEnabledField), this.booleanStateCurrentStateField);
        int cullMode = (Integer)Misc.getReflectFieldValue(CULL, this.cullStateModeField);
        if (this.lastModelRenderDetected == null || !this.lastModelRenderDetected.hasProperties(model, textureId, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, cullFace, cullMode)) {
            this.lastModelRenderDetected = new ModelRenderDetectionElement(model, textureId, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, red, green, blue, alpha, cullFace, cullMode);
            this.modelRenderDetectionList.add(this.lastModelRenderDetected);
        }
    }

    public void onModelPartRenderDetection(RendererModel modelRenderer) {
        EntityModel model = (EntityModel)((IXaeroMinimapModelRenderer)modelRenderer).getXaero_model();
        if (this.modelRenderDetectionEntityModelClass == null) {
            EntityModel currentMainModel = this.getEntityRendererModel(this.modelRenderDetectionEntityRenderer);
            Class<?> clazz = this.modelRenderDetectionEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
        }
        if (this.modelRenderDetectionEntityModelClass != model.getClass()) {
            return;
        }
        Object COLOR = Misc.getReflectFieldValue(null, this.colorStateField);
        float red = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateRedField)).floatValue();
        float green = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateGreenField)).floatValue();
        float blue = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateBlueField)).floatValue();
        float alpha = ((Float)Misc.getReflectFieldValue(COLOR, this.colorStateAlphaField)).floatValue();
        this.onModelRenderDetection(model, red, green, blue, alpha);
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    private boolean renderIcon(EntityRenderer entityRenderer, EntityModel mainEntityModel, List<ModelRenderDetectionElement> detectedModels, Entity entity, EntityIconModelConfig modelConfig) {
        EntityIconCustomRenderer entityIconCustomRenderer;
        boolean forceFieldCheck;
        boolean bl = forceFieldCheck = (modelConfig.renderingFullModel == null || modelConfig.renderingFullModel == false) && modelConfig.modelPartsFields != null;
        boolean fullModelIcon = modelConfig.renderingFullModel == null ? !forceFieldCheck && EntityIconDefinitions.fullModelIcon(mainEntityModel) : modelConfig.renderingFullModel;
        RendererModel mainPart = null;
        boolean renderedSomething = false;
        ArrayList<RendererModel> mainRenderedModels = new ArrayList<RendererModel>();
        ResourceLocation mainEntityTexture = EntityIconDefinitions.getEntityTexture(entityRenderer, entity);
        if (detectedModels.isEmpty()) {
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            Object mainTextureObject = textureManager.func_110581_b(mainEntityTexture);
            if (mainTextureObject == null) {
                textureManager.func_110577_a(mainEntityTexture);
                mainTextureObject = textureManager.func_110581_b(mainEntityTexture);
            }
            detectedModels.add(new ModelRenderDetectionElement(mainEntityModel, mainTextureObject == null ? 0 : mainTextureObject.func_110552_b(), 770, 771, 1, 771, true, 515, true, true, true, true, true, 1.0f, 1.0f, 1.0f, 1.0f, false, 1029));
        }
        boolean allEmpty = true;
        for (ModelRenderDetectionElement modelRenderDetectionElement : detectedModels) {
            if (modelRenderDetectionElement.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            for (ModelRenderDetectionElement modelRenderDetectionElement : detectedModels) {
                modelRenderDetectionElement.allVisible = true;
            }
        }
        ModelRenderDetectionElement mainMrde = null;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            boolean mainPartsVisibility;
            if (mrde.isEmpty() || renderedSomething && !modelConfig.layersAllowed) continue;
            EntityModel<?> detectedModel = mrde.model;
            int detectedTexture = mrde.renderTexture;
            boolean mainModel = detectedModel == mainEntityModel;
            boolean bl2 = mainPartsVisibility = mainModel && mainMrde != null && mrde.sameVisibility(mainMrde);
            if (mainModel && !mainPartsVisibility) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                mainRenderedModels.clear();
                mainPart = this.renderModel(entityRenderer, detectedModel, entity, modelConfig, mainPart, mainRenderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde);
                mainMrde = mrde;
                renderedSomething = renderedSomething || !mainRenderedModels.isEmpty();
                continue;
            }
            if (!mainModel) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                ArrayList<RendererModel> renderedModels = new ArrayList<RendererModel>();
                mainPart = this.renderModel(entityRenderer, detectedModel, entity, modelConfig, mainPart, renderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde);
                renderedSomething = renderedSomething || !renderedModels.isEmpty();
                continue;
            }
            if (mainRenderedModels.isEmpty()) continue;
            this.setupModelRenderType(detectedTexture, mrde);
            this.entityModelPartsRenderer.renderPartsIterable(mainRenderedModels, new ArrayList<RendererModel>(), mainPart, modelConfig.modelPartsRotationReset, mrde);
            this.clearModelRenderType();
        }
        if (!mainRenderedModels.isEmpty() && modelConfig.layersAllowed && (entityIconCustomRenderer = EntityIconDefinitions.getCustomLayer(entityRenderer, entity)) != null) {
            mainPart = entityIconCustomRenderer.render(this, entityRenderer, entity, mainEntityModel, this.entityModelPartsRenderer, mainRenderedModels, mainPart, modelConfig, mainMrde);
        }
        return renderedSomething;
    }

    private boolean resetModelRotations(Entity entity, EntityModel model) {
        try {
            model.func_212843_a_(entity, 0.0f, 0.0f, 1.0f);
            model.func_212844_a_(entity, 0.0f, 0.0f, (float)entity.field_70173_aa, 0.0f, 0.0f, 0.0625f);
            OpenGLException.checkGLError();
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private EntityModel getEntityRendererModel(EntityRenderer entityRenderer) {
        if (entityRenderer instanceof LivingRenderer) {
            return ((LivingRenderer)entityRenderer).func_217764_d();
        }
        return null;
    }
}

