/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiMisc;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    public static final float DEFAULT_SCALE = 0.8f;
    public static final float MINECRAFT_SCALE = 0.02666667f;
    private IXaeroMinimap modMain;

    public WaypointsIngameRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
    }

    public void render(XaeroMinimapSession minimapSession, float partial) {
        if (this.modMain.getSettings().getShowIngameWaypoints()) {
            Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_BENEFICIAL) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL)) {
                return;
            }
            WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
            Entity entity = mc.func_175606_aa();
            ActiveRenderInfo activeRender = Minecraft.func_71410_x().field_71460_t.func_215316_n();
            double actualEntityX = entity.field_70165_t;
            double actualEntityY = entity.field_70163_u;
            double actualEntityZ = entity.field_70161_v;
            Vec3d cameraPos = activeRender.func_216785_c();
            double d3 = cameraPos.func_82615_a();
            double d4 = cameraPos.func_82617_b();
            double d5 = cameraPos.func_82616_c();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.disableCull();
            GlStateManager.pushMatrix();
            boolean lookingBack = mc.field_71474_y.field_74320_O == 2;
            float yaw = (float)(lookingBack ? 0 : 180) + entity.func_195046_g(partial);
            float pitch = (float)(lookingBack ? -1 : 1) * entity.func_195050_f(partial);
            GlStateManager.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            double fov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            int screenHeight = Minecraft.func_71410_x().field_195558_d.func_198091_l();
            float cameraAngleYaw = MathHelper.func_76142_g((float)(yaw - 180.0f));
            float cameraAnglePitch = MathHelper.func_76142_g((float)pitch);
            Vec3d lookVector = entity.func_70040_Z();
            if (lookingBack) {
                lookVector = lookVector.func_216371_e();
            }
            double clampDepth = this.modMain.getSettings().getWaypointsClampDepth(fov, screenHeight);
            double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
            if (waypointsManager.getWaypoints() != null) {
                if (this.modMain.getSettings().renderAllSets) {
                    HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                    for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                        this.renderWaypointsList(setEntry.getValue().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth);
                    }
                } else {
                    this.renderWaypointsList(waypointsManager.getWaypoints().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth);
                }
            }
            if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
                for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                    this.renderWaypointsList(modCustomWaypoints.values(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth);
                }
            }
            RenderHelper.func_74518_a();
            GlStateManager.enableDepthTest();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.popMatrix();
        }
    }

    private void renderWaypointsList(Collection<Waypoint> list, double d3, double d4, double d5, Entity entity, BufferBuilder bufferbuilder, Tessellator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, float yaw, float pitch, double fov, int screenHeight, float cameraAngleYaw, float cameraAnglePitch, Vec3d lookVector, double clampDepth) {
        for (Waypoint w : list) {
            this.renderWaypointIngame(cameraAngleYaw, cameraAnglePitch, lookVector, w, this.modMain, clampDepth, d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch);
        }
    }

    private void renderWaypointIngame(float cameraAngleYaw, float cameraAnglePitch, Vec3d lookVector, Waypoint w, IXaeroMinimap modMain, double depthClamp, double d3, double d4, double d5, Entity entity, BufferBuilder bufferBuilder, Tessellator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, float yaw, float pitch) {
        float offZ;
        float offY;
        if (w.isDisabled() || w.getType() == 1 && !modMain.getSettings().getDeathpoints()) {
            return;
        }
        float offX = (float)((double)w.getX(dimDiv) - d3) + 0.5f;
        double depth = (double)offX * lookVector.field_72450_a + (double)(offY = (float)((double)w.getY() - d4) + 1.0f) * lookVector.field_72448_b + (double)(offZ = (float)((double)w.getZ(dimDiv) - d5) + 0.5f) * lookVector.field_72449_c;
        if (depth < 0.0) {
            return;
        }
        double correctOffX = actualEntityX - (double)w.getX() - 0.5;
        double correctOffY = actualEntityY - (double)w.getY();
        double correctOffZ = actualEntityZ - (double)w.getZ() - 0.5;
        double correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + correctOffZ * correctOffZ);
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        float originalOffY = offY;
        double waypointsDistance = modMain.getSettings().getMaxWaypointsDistance();
        if (w.getType() == 0 && !w.isGlobal() && waypointsDistance != 0.0 && distance2D > waypointsDistance || modMain.getSettings().waypointsDistanceMin != 0.0 && distance2D < modMain.getSettings().waypointsDistanceMin) {
            return;
        }
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        FontRenderer fontrenderer = renderManager.func_78716_a();
        if (fontrenderer == null) {
            return;
        }
        GlStateManager.pushMatrix();
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        String distanceText = "";
        boolean showDistance = false;
        float zoomer2 = 1.0f;
        if (depth > depthClamp) {
            double maxDistance = (double)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0;
            if (depth > maxDistance) {
                zoomer2 = (float)(maxDistance / depthClamp);
                float zoomer = (float)(maxDistance / depth);
                offX *= zoomer;
                offY *= zoomer;
                offZ *= zoomer;
            } else {
                zoomer2 = (float)(depth / depthClamp);
            }
        }
        if (correctDistance > 20.0 || modMain.getSettings().alwaysShowDistance) {
            if (modMain.getSettings().distance == 1) {
                float offset;
                float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                if (offZ < 0.0f) {
                    angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                }
                boolean bl = showDistance = Math.abs(offset = MathHelper.func_76142_g((float)(angle - cameraAngleYaw))) < (float)modMain.getSettings().lookingAtAngle;
                if (modMain.getSettings().lookingAtAngleVertical != 180) {
                    float verticalAngle = (float)Math.toDegrees(Math.atan((double)(-originalOffY) / (distance2D == 0.0 ? 1.0E-5 : distance2D)));
                    showDistance = showDistance && Math.abs(verticalAngle - cameraAnglePitch) < (float)modMain.getSettings().lookingAtAngleVertical;
                }
            } else if (modMain.getSettings().distance == 2) {
                showDistance = true;
            }
            if (showDistance) {
                distanceText = GuiMisc.simpleFormat.format(correctDistance) + "m";
                if (!modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        GlStateManager.translatef((float)offX, (float)offY, (float)offZ);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)-0.02666667f, (float)-0.02666667f, (float)1.0f);
        GlStateManager.scalef((float)zoomer2, (float)zoomer2, (float)1.0f);
        GlStateManager.disableLighting();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.disableDepthTest();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GlStateManager.scalef((float)0.8f, (float)0.8f, (float)1.0f);
        this.drawIconInWorld(w, modMain.getSettings(), bufferBuilder, tessellator, fontrenderer, name, distanceText, textSize, showDistance);
        GlStateManager.enableLighting();
        GlStateManager.disableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    public void drawIconInWorld(Waypoint w, ModSettings settings, BufferBuilder vertexBuffer, Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance) {
        int t;
        double ingameScale = settings.waypointsIngameScale;
        double distanceScale = settings.waypointsDistanceScale;
        double nameScale = settings.waypointsNameScale;
        int ingameOpacity = settings.waypointOpacityIngame;
        GlStateManager.scaled((double)ingameScale, (double)ingameScale, (double)1.0);
        int addedFrame = 0;
        if (Minecraft.func_71410_x().func_211821_e()) {
            textSize *= 1.5f;
        }
        int c = ModSettings.COLORS[w.getColor()];
        float l = (float)(c >> 16 & 0xFF) / 255.0f;
        float i1 = (float)(c >> 8 & 0xFF) / 255.0f;
        float j1 = (float)(c & 0xFF) / 255.0f;
        if (w.getType() == 0) {
            GlStateManager.scalef((float)textSize, (float)textSize, (float)textSize);
            int s = fontrenderer.func_78256_a(w.getSymbol()) / 2;
            GlStateManager.disableTexture();
            GlStateManager.color4f((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)ingameOpacity / 100.0f) / 255.0f));
            addedFrame = this.renderColorBackground(vertexBuffer, tessellator, addedFrame, s);
            GlStateManager.enableTexture();
            fontrenderer.func_211126_b(w.getSymbol(), (float)(-s), -8.0f, -1);
        } else if (w.getType() == 1) {
            GlStateManager.color4f((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)ingameOpacity / 100.0f) / 255.0f));
            GlStateManager.disableTexture();
            addedFrame = this.renderColorBackground(vertexBuffer, tessellator, addedFrame, 4);
            GlStateManager.enableTexture();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            GlStateManager.color4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            this.renderTexturedIcon(vertexBuffer, tessellator, addedFrame, 0, 78);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!showDistance) {
                name = w.getLocalizedName();
            }
        }
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        boolean showingName = name.length() > 0;
        GlStateManager.translatef((float)0.0f, (float)(1 + addedFrame), (float)0.0f);
        if (w.getType() != 0) {
            GlStateManager.scalef((float)textSize, (float)textSize, (float)1.0f);
        }
        if (showingName) {
            GlStateManager.scaled((double)nameScale, (double)nameScale, (double)1.0);
            t = fontrenderer.func_78256_a(name) / 2;
            fontrenderer.func_211126_b(name, (float)(-t), 0.0f, -1);
            GlStateManager.translatef((float)0.0f, (float)10.0f, (float)0.0f);
            GlStateManager.scaled((double)(1.0 / nameScale), (double)(1.0 / nameScale), (double)1.0);
            GlStateManager.enableBlend();
        }
        if (distance.length() > 0) {
            GlStateManager.scaled((double)distanceScale, (double)distanceScale, (double)1.0);
            t = fontrenderer.func_78256_a(distance) / 2;
            GlStateManager.disableTexture();
            GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.27450982f);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            vertexBuffer.func_181662_b((double)(-t) - 1.0, 0.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(-t) - 1.0, 9.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, 9.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, 0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.enableTexture();
            fontrenderer.func_211126_b(distance, (float)(-t), 1.0f, -1);
        }
    }

    private int renderColorBackground(BufferBuilder vertexBuffer, Tessellator tessellator, int addedFrame, int s) {
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        if (s > 4) {
            addedFrame = s - 4;
        }
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_181675_d();
        tessellator.func_78381_a();
        return addedFrame;
    }

    private void renderTexturedIcon(BufferBuilder vertexBuffer, Tessellator tessellator, int addedFrame, int textureX, int textureY) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_187315_a((double)((float)textureX * f), (double)((float)textureY * f1)).func_181675_d();
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, (double)addedFrame, 0.0).func_187315_a((double)((float)textureX * f), (double)((float)(textureY + 9 + addedFrame * 2) * f1)).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, (double)addedFrame, 0.0).func_187315_a((double)((float)(textureX + 9 + addedFrame * 2) * f), (double)((float)(textureY + 9 + addedFrame * 2) * f1)).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_187315_a((double)((float)(textureX + 9 + addedFrame * 2) * f), (double)((float)textureY * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

