/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.world.chunk.Chunk;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.IScreenBase;

public class Misc {
    public static double getMouseX(Minecraft mc) {
        return mc.field_71417_B.func_198024_e() * (double)mc.field_195558_d.func_198109_k() / (double)mc.field_195558_d.func_198105_m();
    }

    public static double getMouseY(Minecraft mc) {
        return mc.field_71417_B.func_198026_f() * (double)mc.field_195558_d.func_198091_l() / (double)mc.field_195558_d.func_198083_n();
    }

    public static void minecraftOrtho(Minecraft mc) {
        MainWindow window = mc.field_195558_d;
        GlStateManager.loadIdentity();
        GlStateManager.ortho((double)0.0, (double)((double)window.func_198109_k() / window.func_198100_s()), (double)((double)window.func_198091_l() / window.func_198100_s()), (double)0.0, (double)1000.0, (double)3000.0);
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFromOnFail) throws IOException {
        Path backupPath = null;
        try {
            if (Files.exists(to, new LinkOption[0])) {
                backupPath = Misc.quickFileBackupMove(to);
            }
            Files.move(from, to, new CopyOption[0]);
        }
        catch (IOException ioe) {
            while (backupFromOnFail) {
                try {
                    if (!Files.exists(from, new LinkOption[0])) break;
                    Misc.quickFileBackupMove(from);
                    break;
                }
                catch (IOException ioe2) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            throw ioe;
        }
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static boolean inputMatchesKeyBinding(InputMappings.Type type, int code, KeyBinding kb) {
        return code != -1 && kb.getKey().func_197938_b() == type && kb.getKey().func_197937_c() == code;
    }

    public static boolean screenShouldSkipWorldRender(IXaeroMinimap modMain, Screen screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && modMain.getSupportMods().worldmap() && modMain.getSupportMods().worldmapSupport.screenShouldSkipWorldRender(screen);
    }

    public static long getChunkPosAsLong(Chunk chunk) {
        return chunk.func_76632_l().func_201841_a();
    }

    public static Field getFieldReflection(Class<?> c, String obfuscatedName, String name) {
        Field field = null;
        try {
            field = c.getDeclaredField(obfuscatedName);
        }
        catch (NoSuchFieldException e) {
            try {
                field = c.getDeclaredField(name);
            }
            catch (NoSuchFieldException e1) {
                throw new RuntimeException(e1);
            }
        }
        return field;
    }

    public static <A, B> B getReflectFieldValue(A parentObject, Field field) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(parentObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        field.setAccessible(accessibleBU);
        return (B)result;
    }

    public static void download(BufferedOutputStream output, InputStream input) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        input.close();
        output.close();
    }
}

