/*
 * Decompiled with CFR 0.152.
 */
package xaero.patreon;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import javax.crypto.Cipher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderPlayerEvent;
import xaero.patreon.PatreonMod4;
import xaero.patreon.decrypt.DecryptInputStream;

public class Patreon6 {
    public static HashMap<Integer, ArrayList<String>> patrons = new HashMap();
    public static boolean notificationDisplayed;
    public static boolean loaded;
    public static boolean showCapes;
    public static int patronPledge;
    public static String updateLocation;
    public static HashMap<String, PatreonMod4> mods;
    private static ArrayList<PatreonMod4> outdatedMods;
    public static Cipher cipher;
    public static int KEY_VERSION;
    public static String publicKeyString;
    public static File optionsFile;
    public static String rendersCapes;
    private static ResourceLocation cape1;
    private static ResourceLocation cape2;
    private static ResourceLocation cape3;
    private static ResourceLocation cape4;
    private static boolean pauseCapes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkPatreon() {
        HashMap<Integer, ArrayList<String>> hashMap = patrons;
        synchronized (hashMap) {
            if (loaded) {
                return;
            }
            Patreon6.loadSettings();
            String s = "http://data.chocolateminecraft.com/Versions_" + KEY_VERSION + "/Patreon.txt";
            s = s.replaceAll(" ", "%20");
            try {
                String[] args;
                String line;
                URL url = new URL(s);
                URLConnection conn = url.openConnection();
                conn.setReadTimeout(900);
                conn.setConnectTimeout(900);
                if (conn.getContentLengthLong() > 524288L) {
                    throw new IOException("Input too long to trust!");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(new DecryptInputStream(conn.getInputStream(), cipher)));
                int pledge = -1;
                while ((line = reader.readLine()) != null && !line.equals("LAYOUTS")) {
                    if (line.startsWith("PATREON")) {
                        pledge = Integer.parseInt(line.substring(7));
                        patrons.put(pledge, new ArrayList());
                        continue;
                    }
                    if (pledge == -1) continue;
                    args = line.split("\\t");
                    patrons.get(pledge).add(args[0]);
                    if (!args[0].equalsIgnoreCase(Minecraft.func_71410_x().func_110432_I().func_148256_e().getName())) continue;
                    patronPledge = pledge;
                }
                updateLocation = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    args = line.split("\\t");
                    mods.put(args[0], new PatreonMod4(args[0], args[1], args[2], args[3]));
                }
                reader.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
                patrons.clear();
                mods.clear();
            }
            finally {
                loaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOutdatedMod(PatreonMod4 mod) {
        ArrayList<PatreonMod4> arrayList = Patreon6.getOutdatedMods();
        synchronized (arrayList) {
            Patreon6.getOutdatedMods().add(mod);
        }
    }

    public static int getPatronPledge(String name) {
        Integer[] keys = patrons.keySet().toArray(new Integer[0]);
        for (int i = 0; i < keys.length; ++i) {
            if (!patrons.get(keys[i]).contains(name)) continue;
            return keys[i];
        }
        return -1;
    }

    public static void saveSettings() {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(optionsFile));
            writer.println("showCapes:" + showCapes);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadSettings() {
        try {
            String line;
            if (!optionsFile.exists()) {
                Patreon6.saveSettings();
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(optionsFile));
            while ((line = reader.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equalsIgnoreCase("showCapes")) continue;
                showCapes = args[1].equals("true");
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ResourceLocation getPlayerCape(String modID, AbstractClientPlayerEntity playerEntity) {
        if (!pauseCapes && showCapes && modID.equals(rendersCapes)) {
            ResourceLocation cape = null;
            int pledge = Patreon6.getPatronPledge(playerEntity.func_200200_C_().func_150254_d());
            if (pledge == 2) {
                cape = cape1;
            } else if (pledge == 5) {
                cape = cape2;
            } else if (pledge == 10) {
                cape = cape3;
            } else if (pledge == 50) {
                cape = cape4;
            }
            if (cape == null) {
                return null;
            }
            pauseCapes = true;
            ResourceLocation realCape = playerEntity.func_110303_q();
            boolean realIsWearing = playerEntity.func_175148_a(PlayerModelPart.CAPE);
            pauseCapes = false;
            if (realCape != null && realIsWearing) {
                return realCape;
            }
            return cape;
        }
        return null;
    }

    public static Boolean isWearingCape(String modID, AbstractClientPlayerEntity playerEntity) {
        if (!pauseCapes && showCapes && modID.equals(rendersCapes)) {
            pauseCapes = true;
            ResourceLocation realCape = playerEntity.func_110303_q();
            boolean realIsWearing = playerEntity.func_175148_a(PlayerModelPart.CAPE);
            pauseCapes = false;
            if (realIsWearing || realCape == null) {
                return realIsWearing;
            }
            int pledge = Patreon6.getPatronPledge(playerEntity.func_200200_C_().func_150254_d());
            return pledge >= 2;
        }
        return null;
    }

    public static void renderCapeFallback(String modID, RenderPlayerEvent.Post event) {
        if (!event.getPlayer().func_70089_S() || event.getPlayer().func_70608_bn() || event.getPlayer().func_203007_ba()) {
            return;
        }
        pauseCapes = true;
        ResourceLocation realCape = ((AbstractClientPlayerEntity)event.getPlayer()).func_110303_q();
        boolean realIsWearing = event.getPlayer().func_175148_a(PlayerModelPart.CAPE);
        pauseCapes = false;
        if (realCape != null && realIsWearing || realCape == null && !realIsWearing) {
            return;
        }
        ResourceLocation cape = Patreon6.getPlayerCape(modID, (AbstractClientPlayerEntity)event.getPlayer());
        if (cape == null) {
            return;
        }
        ItemStack itemstack = event.getPlayer().func_184582_a(EquipmentSlotType.CHEST);
        if (itemstack == null || itemstack.func_77973_b() != Items.field_185160_cR) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)event.getX(), (double)event.getY(), (double)event.getZ());
            GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translated((double)0.0, (double)(event.getEntityPlayer().func_70093_af() ? -1.3 : -1.4), (double)0.0);
            GlStateManager.rotatef((float)(event.getEntityPlayer().field_70760_ar + (event.getEntityPlayer().field_70761_aq - event.getEntityPlayer().field_70760_ar) * event.getPartialRenderTick()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.getRenderer().func_110776_a(cape);
            GlStateManager.translated((double)0.0, (double)0.0, (double)0.125);
            double d0 = event.getEntityPlayer().field_71091_bM + (event.getEntityPlayer().field_71094_bP - event.getEntityPlayer().field_71091_bM) * (double)event.getPartialRenderTick() - (event.getEntityPlayer().field_70169_q + (event.getEntityPlayer().field_70165_t - event.getEntityPlayer().field_70169_q) * (double)event.getPartialRenderTick());
            double d1 = event.getEntityPlayer().field_71096_bN + (event.getEntityPlayer().field_71095_bQ - event.getEntityPlayer().field_71096_bN) * (double)event.getPartialRenderTick() - (event.getEntityPlayer().field_70167_r + (event.getEntityPlayer().field_70163_u - event.getEntityPlayer().field_70167_r) * (double)event.getPartialRenderTick());
            double d2 = event.getEntityPlayer().field_71097_bO + (event.getEntityPlayer().field_71085_bR - event.getEntityPlayer().field_71097_bO) * (double)event.getPartialRenderTick() - (event.getEntityPlayer().field_70166_s + (event.getEntityPlayer().field_70161_v - event.getEntityPlayer().field_70166_s) * (double)event.getPartialRenderTick());
            float f = event.getEntityPlayer().field_70760_ar + (event.getEntityPlayer().field_70761_aq - event.getEntityPlayer().field_70760_ar) * event.getPartialRenderTick();
            double d3 = MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
            double d4 = -MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)150.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = MathHelper.func_76131_a((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = event.getEntityPlayer().field_71107_bF + (event.getEntityPlayer().field_71109_bG - event.getEntityPlayer().field_71107_bF) * event.getPartialRenderTick();
            f1 += MathHelper.func_76126_a((float)((event.getEntityPlayer().field_70141_P + (event.getEntityPlayer().field_70140_Q - event.getEntityPlayer().field_70141_P) * event.getPartialRenderTick()) * 6.0f)) * 32.0f * f4;
            if (event.getEntityPlayer().func_70093_af()) {
                f1 += 25.0f;
            }
            GlStateManager.rotatef((float)(6.0f + Math.min(90.0f, f2 / 2.0f) + f1), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)(f3 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)(-f3 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            ((PlayerModel)event.getRenderer().func_217764_d()).func_178728_c(0.0625f);
            GlStateManager.popMatrix();
        }
    }

    public static ArrayList<PatreonMod4> getOutdatedMods() {
        return outdatedMods;
    }

    public static boolean needsNotification() {
        return !notificationDisplayed && !outdatedMods.isEmpty();
    }

    static {
        loaded = false;
        showCapes = true;
        patronPledge = -1;
        mods = new HashMap();
        outdatedMods = new ArrayList();
        cipher = null;
        KEY_VERSION = 2;
        publicKeyString = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqg2aSbG53XaP+1b8kcP2x3hukI5WRWI6W+SzrLCIpAErFZGzzhkPuIPEwAie1hK0i6gBuGE4H47pF7dfaL8w53NzxSqVLzRbgzIcCf0VIhW4PfAmyBFsTQcrGJZESSWCxyj6aG5ERSqEualXycum6/v2d9Ux5tXTElnJDttEr/cBB37dJBisjJjlzQeVtnS7VMD2/WVGSVsI5MRzEZT4WEW6b81DaJT9Hoy0nJIEIYEAxPYRNwOhEJahfFiOXcx0YWYGqeuuyKpBeKkkGc7VnTaQNaZtoUJPo7a2Dp/XRhJ/vCzixbymMnaPT+OVlnGGfXxM5z9nb8pp9hQfoGidsQIDAQAB";
        try {
            cipher = Cipher.getInstance("RSA");
            KeyFactory factory = KeyFactory.getInstance("RSA");
            byte[] byteKey = Base64.getDecoder().decode(publicKeyString.getBytes());
            X509EncodedKeySpec X509publicKey = new X509EncodedKeySpec(byteKey);
            PublicKey publicKey = factory.generatePublic(X509publicKey);
            cipher.init(2, publicKey);
        }
        catch (Exception e) {
            cipher = null;
            e.printStackTrace();
        }
        optionsFile = new File("./config/xaeropatreon.txt");
        rendersCapes = null;
        cape1 = new ResourceLocation("xaeropatreon", "capes/cape1.png");
        cape2 = new ResourceLocation("xaeropatreon", "capes/cape2.png");
        cape3 = new ResourceLocation("xaeropatreon", "capes/cape3.png");
        cape4 = new ResourceLocation("xaeropatreon", "capes/cape4.png");
        pauseCapes = false;
    }
}

