/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.network.play.server.S22PacketMultiBlockChange;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.patreon.Patreon6;

public class XaeroMinimapCore {
    public static IXaeroMinimap modMain;
    public static Field chunkCleanField;
    public static XaeroMinimapSession currentSession;
    public static Method setupCameraTransformMethod;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = Chunk.class.getDeclaredField("xaero_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroMinimapCore.ensureField();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        Chunk chunk = world.func_72964_e(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(S21PacketChunkData packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_149273_e(), packetIn.func_149271_f());
    }

    public static void onBlockChange(S23PacketBlockChange packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_148879_d() >> 4, packetIn.func_148877_f() >> 4);
    }

    public static void onMultiBlockChange(S22PacketMultiBlockChange packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_148920_c().field_77276_a, packetIn.func_148920_c().field_77275_b);
    }

    public static ResourceLocation getPlayerCape(AbstractClientPlayer player) {
        return Patreon6.getPlayerCape(modMain.getFileLayoutID(), player);
    }

    public static Boolean isHiding(EntityPlayer player, int part) {
        if (part != 1 || !(player instanceof AbstractClientPlayer)) {
            return null;
        }
        Boolean moddedResult = Patreon6.isWearingCape(modMain.getFileLayoutID(), (AbstractClientPlayer)player);
        return moddedResult == null ? null : Boolean.valueOf(moddedResult == false);
    }

    public static void onPlayNetHandler(NetHandlerPlayClient netHandler) {
        try {
            XaeroMinimapSession minimapSession;
            IXaeroMinimapClientPlayNetHandler netHandlerAccess = (IXaeroMinimapClientPlayNetHandler)netHandler;
            if (netHandlerAccess.getXaero_minimapSession() != null) {
                return;
            }
            if (currentSession != null) {
                System.out.println("Previous minimap session still active. Probably using MenuMobs. Forcing it to end...");
                XaeroMinimapCore.cleanupCurrentSession();
            }
            currentSession = minimapSession = modMain.createSession();
            minimapSession.init();
            netHandlerAccess.setXaero_minimapSession(minimapSession);
        }
        catch (Throwable e) {
            if (currentSession != null) {
                XaeroMinimapCore.cleanupCurrentSession();
            }
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
            Minecraft.func_71410_x().field_71441_e.func_72882_A();
        }
    }

    private static void cleanupCurrentSession() {
        try {
            currentSession.cleanup();
        }
        catch (Throwable supressed) {
            supressed.printStackTrace();
        }
        finally {
            currentSession = null;
        }
    }

    public static void onPlayNetHandlerCleanup(NetHandlerPlayClient netHandler) {
        try {
            XaeroMinimapSession netHandlerSession = ((IXaeroMinimapClientPlayNetHandler)netHandler).getXaero_minimapSession();
            if (netHandlerSession == null) {
                return;
            }
            try {
                netHandlerSession.cleanup();
            }
            finally {
                if (netHandlerSession == currentSession) {
                    currentSession = null;
                }
                ((IXaeroMinimapClientPlayNetHandler)netHandler).setXaero_minimapSession(null);
            }
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
        }
    }

    public static void beforeRespawn(EntityPlayer player) {
        if (player == Minecraft.func_71410_x().field_71439_g) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().createDeathpoint(player);
        }
    }

    public static void beforeIngameGuiRender(float partialTicks) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null && Minecraft.func_71410_x().field_71441_e == minimapSession.getMinimapProcessor().mainWorld) {
            GL11.glMatrixMode((int)5889);
            XaeroMinimapCore.ensureCameraMethod();
            try {
                boolean cameraMethodBU = setupCameraTransformMethod.isAccessible();
                setupCameraTransformMethod.setAccessible(true);
                setupCameraTransformMethod.invoke((Object)Minecraft.func_71410_x().field_71460_t, Float.valueOf(partialTicks), 0);
                setupCameraTransformMethod.setAccessible(cameraMethodBU);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            GL11.glMatrixMode((int)5888);
            modMain.getInterfaces().getMinimapInterface().getWaypointsIngameRenderer().render(minimapSession, partialTicks);
            GL11.glMatrixMode((int)5889);
            Minecraft.func_71410_x().field_71460_t.func_78478_c();
            GL11.glMatrixMode((int)5888);
        }
    }

    private static void ensureCameraMethod() {
        if (setupCameraTransformMethod == null) {
            try {
                setupCameraTransformMethod = EntityRenderer.class.getDeclaredMethod("func_78479_a", Float.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException | SecurityException e) {
                try {
                    setupCameraTransformMethod = EntityRenderer.class.getDeclaredMethod("setupCameraTransform", Float.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException | SecurityException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    public static void onEntityIconsModelPartRenderDetection(ModelRenderer modelRenderer) {
        if (!EntityIconPrerenderer.DETECTING_MODEL_RENDERS || !modelRenderer.field_78806_j || modelRenderer.field_78807_k) {
            return;
        }
        modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().onEntityIconsModelPartRenderDetection(modelRenderer);
    }

    static {
        chunkCleanField = null;
        setupCameraTransformMethod = null;
    }
}

