/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;

public class GuiNewSet
extends ScreenBase {
    private TextFieldWidget nameTextField;
    private XaeroMinimapSession minimapSession;
    private WaypointsManager waypointsManager;
    private WaypointWorld waypointWorld;

    public GuiNewSet(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1GuiScreen, WaypointWorld waypointWorld) {
        this(modMain, minimapSession, par1GuiScreen, null, waypointWorld);
    }

    public GuiNewSet(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1GuiScreen, Screen escapeScreen, WaypointWorld waypointWorld) {
        super(modMain, par1GuiScreen, escapeScreen, (ITextComponent)new TranslationTextComponent("gui.xaero_create_set", new Object[0]));
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.waypointWorld = waypointWorld;
        this.canSkipWorldRender = true;
    }

    public void init() {
        super.init();
        this.nameTextField = new TextFieldWidget(this.font, this.width / 2 - 100, 60, 200, 20, I18n.func_135052_a((String)"gui.xaero_set_name", (Object[])new Object[0]));
        this.setFocused((IGuiEventListener)this.nameTextField);
        this.nameTextField.func_146195_b(true);
        this.children.add(this.nameTextField);
        this.addButton((Widget)new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            if (this.canConfirm()) {
                String setName = this.nameTextField.func_146179_b().replace(":", "\u00a7\u00a7");
                this.waypointWorld.setCurrent(setName);
                this.waypointWorld.addSet(setName);
                this.waypointsManager.updateWaypoints();
                try {
                    this.modMain.getSettings().saveWaypoints(this.waypointWorld);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.goBack();
            }
        }));
        this.addButton((Widget)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.goBack()));
        this.minecraft.field_195559_v.func_197967_a(true);
        this.updateConfirmButton();
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    private boolean canConfirm() {
        return this.nameTextField.func_146179_b().length() > 0 && this.waypointWorld.getSets().get(this.nameTextField.func_146179_b()) == null;
    }

    private void updateConfirmButton() {
        ((Button)this.buttons.get((int)0)).active = this.canConfirm();
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        boolean result = super.keyPressed(par1, par2, par3);
        if (par1 == 257 && this.canConfirm()) {
            ((Widget)this.buttons.get(0)).onClick(0.0, 0.0);
            return true;
        }
        return result;
    }

    public void tick() {
        this.updateConfirmButton();
        this.nameTextField.func_146178_a();
    }

    public void render(int par1, int par2, float par3) {
        this.renderEscapeScreen(par1, par2, par3);
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, 0xFFFFFF);
        this.nameTextField.render(par1, par2, par3);
        super.render(par1, par2, par3);
    }
}

