/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconModelPartsRenderer;
import xaero.common.minimap.render.radar.LivingEntityRotationResetter;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;
import xaero.common.misc.Misc;

public class EntityIconPrerenderer {
    private static final ModelRenderer[] ONE_RENDERER_ARRAY = new ModelRenderer[1];
    private static final boolean TEST_ALL_FIELDS = false;
    private static ArrayList<String> failedFields = new ArrayList();
    private ImprovedFramebuffer modelRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer iconScaleFramebuffer;
    private MatrixStack matrixStack;
    private EntityIconModelPartsRenderer entityModelPartsRenderer;
    private LivingEntityRotationResetter livingEntityRotationResetter;
    private IRenderTypeBuffer.Impl entityIconRenderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)new BufferBuilder(256));
    public static boolean DETECTING_MODEL_RENDERS;
    private EntityRenderer modelRenderDetectionEntityRenderer;
    private Class<?> modelRenderDetectionEntityModelClass;
    private List<ModelRenderDetectionElement> modelRenderDetectionList;
    private ModelRenderDetectionElement lastModelRenderDetected;
    private IRenderTypeBuffer.Impl modelRenderDetectionRenderTypeBuffer;
    private Field lastRenderTypeField;
    private Class<?> renderTypeTypeClass;
    private Field enderDragonModelField;
    private Field renderStateField;
    private Field renderStateTextureStateField;
    private Field renderStateTextureStateTextureField;
    private Field blendStateField;
    private Field colorMaskStateField;
    private Field depthStateField;
    private Field blendStateSrcFactorField;
    private Field blendStateDestFactorField;
    private Field blendStateAlphaSrcFactorField;
    private Field blendStateAlphaDestFactorField;
    private Field colorMaskStateRedField;
    private Field colorMaskStateGreenField;
    private Field colorMaskStateBlueField;
    private Field colorMaskStateAlphaField;
    private Field depthStateFuncField;
    private Field depthStateMaskField;
    private Field depthStateTestField;
    private Field booleanStateCurrentStateField;
    private Field cullStateField;
    private Field cullStateEnabledField;
    private Field cullStateModeField;

    public EntityIconPrerenderer() {
        this.modelRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.iconScaleFramebuffer = new ImprovedFramebuffer(64, 64, false);
        OpenGLException.checkGLError();
        GlStateManager.func_227758_s_((int)this.iconScaleFramebuffer.getFramebufferTexture());
        OpenGLException.checkGLError();
        this.matrixStack = new MatrixStack();
        this.entityModelPartsRenderer = new EntityIconModelPartsRenderer();
        this.livingEntityRotationResetter = new LivingEntityRotationResetter();
        this.modelRenderFramebuffer.func_147612_c();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_227647_a_((int)3553, (int)0, (int)32856, (int)this.modelRenderFramebuffer.field_147621_c, (int)this.modelRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_227760_t_((int)0);
        this.iconRenderFramebuffer.func_147612_c();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        if (!GL.getCapabilities().OpenGL30) {
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_227647_a_((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_147621_c, (int)this.iconRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_227760_t_((int)0);
        this.modelRenderDetectionList = new ArrayList<ModelRenderDetectionElement>();
        this.enderDragonModelField = Misc.getFieldReflection(EnderDragonRenderer.class, "field_229058_m_", "model");
        this.lastRenderTypeField = Misc.getFieldReflection(IRenderTypeBuffer.Impl.class, "field_228459_c_", "lastRenderType");
        try {
            this.renderTypeTypeClass = Class.forName("net.minecraft.client.renderer.RenderType$Type");
            this.renderStateField = Misc.getFieldReflection(this.renderTypeTypeClass, "field_228668_S_", "renderState");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.renderStateTextureStateField = Misc.getFieldReflection(RenderType.State.class, "field_228677_a_", "texture");
        this.renderStateTextureStateTextureField = Misc.getFieldReflection(RenderState.TextureState.class, "field_228602_Q_", "texture");
        this.blendStateField = Misc.getFieldReflection(GlStateManager.class, "field_225661_f_", "BLEND");
        this.colorMaskStateField = Misc.getFieldReflection(GlStateManager.class, "field_225674_v_", "COLOR_MASK");
        this.depthStateField = Misc.getFieldReflection(GlStateManager.class, "field_225662_g_", "DEPTH");
        this.cullStateField = Misc.getFieldReflection(GlStateManager.class, "field_225664_i_", "CULL");
        try {
            Class<?> blendStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$BlendState");
            this.blendStateSrcFactorField = Misc.getFieldReflection(blendStateClass, "field_179211_b", "srcFactorRgb");
            this.blendStateDestFactorField = Misc.getFieldReflection(blendStateClass, "field_179212_c", "dstFactorRgb");
            this.blendStateAlphaSrcFactorField = Misc.getFieldReflection(blendStateClass, "field_179209_d", "srcFactorAlpha");
            this.blendStateAlphaDestFactorField = Misc.getFieldReflection(blendStateClass, "field_179210_e", "dstFactorAlpha");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> colorMaskStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$ColorMask");
            this.colorMaskStateRedField = Misc.getFieldReflection(colorMaskStateClass, "field_179188_a", "red");
            this.colorMaskStateGreenField = Misc.getFieldReflection(colorMaskStateClass, "field_179186_b", "green");
            this.colorMaskStateBlueField = Misc.getFieldReflection(colorMaskStateClass, "field_179187_c", "blue");
            this.colorMaskStateAlphaField = Misc.getFieldReflection(colorMaskStateClass, "field_179185_d", "alpha");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> depthStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$DepthState");
            this.depthStateTestField = Misc.getFieldReflection(depthStateClass, "field_179052_a", "test");
            this.depthStateFuncField = Misc.getFieldReflection(depthStateClass, "field_179051_c", "func");
            this.depthStateMaskField = Misc.getFieldReflection(depthStateClass, "field_179050_b", "mask");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> cullStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$CullState");
            this.cullStateEnabledField = Misc.getFieldReflection(cullStateClass, "field_179054_a", "cullFace");
            this.cullStateModeField = Misc.getFieldReflection(cullStateClass, "field_179053_b", "mode");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> booleanStateClass = Class.forName("com.mojang.blaze3d.platform.GlStateManager$BooleanState");
            this.booleanStateCurrentStateField = Misc.getFieldReflection(booleanStateClass, "field_179201_b", "currentState");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testField(ImmutableList<String> fields) throws NoSuchFieldException, SecurityException {
        boolean odd = true;
        boolean pairFirstFailed = false;
        String prevS = null;
        UnmodifiableIterator unmodifiableIterator = fields.iterator();
        while (unmodifiableIterator.hasNext()) {
            String s = (String)unmodifiableIterator.next();
            try {
                boolean bl = odd = !odd;
                if (!odd) {
                    pairFirstFailed = false;
                }
                boolean failed = false;
                if (!s.isEmpty()) {
                    String[] fieldArgs = s.split(";");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fieldArgs[0]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        System.out.println("Skipping testing a class: " + fieldArgs[0]);
                        prevS = s;
                        continue;
                    }
                    try {
                        c.getDeclaredField(fieldArgs[1]);
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    if (!odd) {
                        pairFirstFailed = true;
                    } else if (pairFirstFailed) {
                        failedFields.add(prevS);
                        failedFields.add(s);
                    }
                }
                prevS = s;
            }
            catch (Throwable throwable) {
                prevS = s;
                throw throwable;
            }
        }
        return;
    }

    public int prerender(EntityRenderer entityRenderer, Entity entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, EntityIconModelConfig modelConfig, boolean debug) {
        LivingEntity livingEntity;
        ImprovedFramebuffer modelRenderFramebuffer = this.modelRenderFramebuffer;
        ImprovedFramebuffer iconRenderFramebuffer = this.iconRenderFramebuffer;
        ImprovedFramebuffer iconScaleFramebuffer = this.iconScaleFramebuffer;
        int finalIconSize = iconScaleFramebuffer.field_147621_c;
        OpenGLException.checkGLError();
        MatrixStack matrixStack = this.matrixStack;
        modelRenderFramebuffer.func_147610_a(true);
        int farPlane = 500;
        this.setupMatrices(finalIconSize, farPlane);
        OpenGLException.checkGLError();
        DETECTING_MODEL_RENDERS = true;
        this.modelRenderDetectionEntityRenderer = entityRenderer;
        this.modelRenderDetectionEntityModelClass = null;
        this.modelRenderDetectionList.clear();
        this.lastModelRenderDetected = null;
        GlStateManager.func_227605_A_();
        IRenderTypeBuffer.Impl renderTypeBuffer = this.modelRenderDetectionRenderTypeBuffer = this.entityIconRenderTypeBuffer;
        if (Minecraft.func_71410_x().func_175598_ae().field_217783_c != null) {
            MatrixStack.Entry matrixEntryToRestore = matrixStack.func_227866_c_();
            matrixStack.func_227860_a_();
            try {
                entityRenderer.func_225623_a_(entity, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, 0xF000F0);
                renderTypeBuffer.func_228461_a_();
                OpenGLException.checkGLError();
            }
            catch (Exception e) {
                this.modelRenderDetectionList.clear();
                System.out.println("Exception when calling the full entity renderer before rendering the icon. " + entity.func_70022_Q());
                e.printStackTrace();
            }
            while (matrixStack.func_227866_c_() != matrixEntryToRestore) {
                matrixStack.func_227865_b_();
            }
            while (GL11.glGetError() != 0) {
            }
        } else {
            System.out.println("Render info was null for entity " + entity.func_70022_Q());
        }
        DETECTING_MODEL_RENDERS = false;
        EntityModel entityModel = this.getEntityRendererModel(entityRenderer);
        if (entityModel == null) {
            this.endModelRendering(modelRenderFramebuffer);
            defaultFramebuffer.func_147610_a(true);
            this.restoreMatrices(helper);
            return -1;
        }
        GlStateManager.func_227700_d_();
        GlStateManager.func_227737_l_();
        GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_227658_a_((int)16640, (boolean)Minecraft.field_142025_a);
        GlStateManager.func_227740_m_();
        GlStateManager.func_227734_k_();
        GlStateManager.func_227605_A_();
        GlStateManager.func_227674_b_((int)515);
        RenderHelper.func_227783_c_();
        if (debug) {
            GlStateManager.func_227626_N_();
            GlStateManager.func_227688_c_((float)0.0f, (float)10.0f, (float)-10.0f);
            GlStateManager.func_227672_b_((float)1.0f, (float)-1.0f, (float)1.0f);
            AbstractGui.fill((int)0, (int)0, (int)9, (int)9, (int)-65536);
            GlStateManager.func_227627_O_();
            GlStateManager.func_227740_m_();
            GlStateManager.func_227644_a_((int)770, (int)771, (int)1, (int)771);
        }
        MatrixStack.Entry matrixEntryToRestore = matrixStack.func_227866_c_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(finalIconSize / 2), (double)(finalIconSize / 2), -450.0);
        matrixStack.func_227861_a_((double)modelConfig.offsetX, (double)(-modelConfig.offsetY), 0.0);
        int mainScale = finalIconSize / 2;
        matrixStack.func_227862_a_((float)mainScale, (float)(-mainScale), (float)(-mainScale));
        if (scale < 1.0f) {
            matrixStack.func_227862_a_(scale, scale, scale);
        }
        matrixStack.func_227862_a_(modelConfig.baseScale, modelConfig.baseScale, modelConfig.baseScale);
        EntityIconDefinitions.customTransformation(matrixStack, entityModel, entity, this);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(modelConfig.rotationY));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(modelConfig.rotationX));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(modelConfig.rotationZ));
        LivingEntity livingEntity2 = livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity != null) {
            this.livingEntityRotationResetter.rememberAndResetValues(livingEntity);
        }
        boolean renderedSomething = this.renderIcon(matrixStack, renderTypeBuffer, entityRenderer, entityModel, this.modelRenderDetectionList, (Entity)((LivingEntity)entity), modelConfig);
        if (livingEntity != null) {
            this.livingEntityRotationResetter.restore(livingEntity);
        }
        EntityIconDefinitions.customPostRenderTransformation(matrixStack, entityModel, entity);
        while (matrixStack.func_227866_c_() != matrixEntryToRestore) {
            matrixStack.func_227865_b_();
        }
        if (debug) {
            GlStateManager.func_227626_N_();
            GlStateManager.func_227688_c_((float)9.0f, (float)10.0f, (float)-10.0f);
            GlStateManager.func_227672_b_((float)1.0f, (float)-1.0f, (float)1.0f);
            AbstractGui.fill((int)0, (int)0, (int)9, (int)9, (int)-16711936);
            GlStateManager.func_227627_O_();
            GlStateManager.func_227644_a_((int)770, (int)771, (int)1, (int)771);
        }
        this.endModelRendering(modelRenderFramebuffer);
        int entityScaledIconTextureId = -1;
        if (renderedSomething) {
            iconRenderFramebuffer.func_147610_a(true);
            GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_227658_a_((int)16384, (boolean)Minecraft.field_142025_a);
            GlStateManager.func_227737_l_();
            if (debug) {
                GlStateManager.func_227626_N_();
                GlStateManager.func_227688_c_((float)18.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.func_227672_b_((float)1.0f, (float)-1.0f, (float)1.0f);
                AbstractGui.fill((int)0, (int)0, (int)9, (int)9, (int)-16776961);
                GlStateManager.func_227627_O_();
                GlStateManager.func_227644_a_((int)770, (int)771, (int)1, (int)771);
            }
            modelRenderFramebuffer.func_147612_c();
            GlStateManager.func_227702_d_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
                for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                    if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                    helper.drawMyTexturedModalRect(shadowOffsetX, finalIconSize + shadowOffsetY, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
                }
            }
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            if (debug) {
                GlStateManager.func_227626_N_();
                GlStateManager.func_227688_c_((float)27.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.func_227672_b_((float)1.0f, (float)-1.0f, (float)1.0f);
                AbstractGui.fill((int)0, (int)0, (int)9, (int)9, (int)-16711681);
                GlStateManager.func_227627_O_();
                GlStateManager.func_227644_a_((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.func_227740_m_();
            iconRenderFramebuffer.func_147609_e();
            iconRenderFramebuffer.func_147612_c();
            iconRenderFramebuffer.generateMipmaps();
            GlStateManager.func_227760_t_((int)0);
            entityScaledIconTextureId = GlStateManager.func_227622_J_();
            OpenGLException.checkGLError();
            GlStateManager.func_227760_t_((int)entityScaledIconTextureId);
            EntityIconPrerenderer.setupIconTextureParams();
            OpenGLException.checkGLError();
            GlStateManager.func_227647_a_((int)3553, (int)0, (int)32856, (int)iconScaleFramebuffer.field_147621_c, (int)iconScaleFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
            GlStateManager.func_227760_t_((int)0);
            OpenGLException.checkGLError();
            iconScaleFramebuffer.func_147610_a(true);
            iconScaleFramebuffer.setFramebufferTexture(entityScaledIconTextureId);
            iconScaleFramebuffer.func_147611_b();
            iconRenderFramebuffer.func_147612_c();
            GlStateManager.func_227700_d_();
            GlStateManager.func_227737_l_();
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            if (debug) {
                GlStateManager.func_227626_N_();
                GlStateManager.func_227688_c_((float)36.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.func_227672_b_((float)1.0f, (float)-1.0f, (float)1.0f);
                AbstractGui.fill((int)0, (int)0, (int)9, (int)9, (int)-256);
                GlStateManager.func_227627_O_();
                GlStateManager.func_227644_a_((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.func_227709_e_();
            GlStateManager.func_227740_m_();
            GlStateManager.func_227760_t_((int)0);
        }
        this.restoreMatrices(helper);
        iconScaleFramebuffer.func_147609_e();
        defaultFramebuffer.func_147610_a(true);
        return entityScaledIconTextureId;
    }

    private void setupMatrices(int finalIconSize, int farPlane) {
        GlStateManager.func_227768_x_((int)5889);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227633_a_((double)0.0, (double)finalIconSize, (double)0.0, (double)finalIconSize, (double)-1.0, (double)farPlane);
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227626_N_();
        GlStateManager.func_227625_M_();
    }

    private void restoreMatrices(MinimapRendererHelper helper) {
        GlStateManager.func_227627_O_();
        GlStateManager.func_227768_x_((int)5889);
        helper.defaultOrtho();
        GlStateManager.func_227768_x_((int)5888);
    }

    private void endModelRendering(ImprovedFramebuffer modelRenderFramebuffer) {
        modelRenderFramebuffer.func_147609_e();
        GlStateManager.func_227740_m_();
        RenderHelper.func_227784_d_();
        RenderHelper.func_74518_a();
        GlStateManager.func_227709_e_();
        GlStateManager.func_227639_a_((int)516, (float)0.0f);
    }

    public static void setupIconTextureParams() {
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    private ModelRenderer renderModel(MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffer, EntityRenderer entityRenderer, EntityModel entityModel, Entity entity, EntityIconModelConfig modelConfig, ModelRenderer mainPart, ArrayList<ModelRenderer> renderedModels, ResourceLocation entityTexture, boolean forceFieldCheck, boolean fullModelIcon, ModelRenderDetectionElement mrde) {
        boolean isChildBU = entityModel.field_217114_e;
        entityModel.field_217114_e = false;
        if (entityTexture != null) {
            IVertexBuilder vertexBuilder = this.setupModelRenderType(renderTypeBuffer, entityTexture, mrde);
            if (modelConfig.modelMainPartFieldAliases != null && !modelConfig.modelMainPartFieldAliases.isEmpty()) {
                mainPart = this.searchSuperclassFields(vertexBuilder, entityModel, renderedModels, mainPart, modelConfig.modelMainPartFieldAliases, true, modelConfig.modelPartsRotationReset, mrde);
            }
            if (!forceFieldCheck && entityModel instanceof AgeableModel) {
                if (entityModel instanceof BipedModel) {
                    ModelRenderer headRenderer = ((BipedModel)entityModel).field_78116_c;
                    if (mainPart == null) {
                        mainPart = headRenderer;
                    }
                    ModelRenderer headWearRenderer = ((BipedModel)entityModel).field_178720_f;
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headWearRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
                mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelHeadPartsMethod, entityModel, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                if (fullModelIcon) {
                    mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelBodyPartsMethod, entityModel, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
            } else if (!forceFieldCheck && entityModel instanceof SegmentedModel && fullModelIcon) {
                mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.segmentedModelPartsMethod, entityModel, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
            } else {
                if (!forceFieldCheck && entityModel instanceof IHasHead) {
                    if (mainPart == null) {
                        mainPart = ((IHasHead)entityModel).func_205072_a();
                    }
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, mainPart, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
                if (modelConfig.modelPartsFields == null) {
                    mainPart = this.searchSuperclassFields(vertexBuilder, entityModel, renderedModels, mainPart, (List<String>)EntityIconDefinitions.HEAD_HARDCODED_NAMES, true, modelConfig.modelPartsRotationReset, mrde);
                }
                Object headPartsFields = EntityIconDefinitions.HEAD_PARTS_HARDCODED_NAMES;
                if (fullModelIcon) {
                    headPartsFields = null;
                } else if (modelConfig.modelPartsFields != null) {
                    headPartsFields = modelConfig.modelPartsFields;
                }
                mainPart = this.searchSuperclassFields(vertexBuilder, entityModel, renderedModels, mainPart, (List<String>)headPartsFields, false, modelConfig.modelPartsRotationReset, mrde);
            }
            renderTypeBuffer.func_228461_a_();
        }
        entityModel.field_217114_e = isChildBU;
        return mainPart;
    }

    private IVertexBuilder setupModelRenderType(IRenderTypeBuffer.Impl renderTypeBuffer, ResourceLocation entityTexture, ModelRenderDetectionElement mrde) {
        int blendAlphaSrcFactor = mrde.blendAlphaSrcFactor;
        int blendAlphaDestFactor = mrde.blendAlphaDestFactor;
        if (mrde.blendDestFactor == 1 && mrde.blendSrcFactor != 0) {
            blendAlphaSrcFactor = 0;
            blendAlphaDestFactor = 1;
        }
        CustomRenderTypes.setDynamicBlendFunc(mrde.blendSrcFactor, mrde.blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor);
        CustomRenderTypes.setDynamicWriteMask(mrde.depthMask, mrde.colorMaskR, mrde.colorMaskG, mrde.colorMaskB, mrde.colorMaskA);
        CustomRenderTypes.setDynamicCull(mrde.cullFace, mrde.cullMode);
        return renderTypeBuffer.getBuffer(CustomRenderTypes.entityIconRenderType(entityTexture, mrde.depthTest ? mrde.depthFunc : 519));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelRenderer[] handleDeclaredField(Field f, EntityModel entityModel, String matchedFilterElement) throws IllegalArgumentException, IllegalAccessException {
        boolean accessibleBU = f.isAccessible();
        try {
            f.setAccessible(true);
            Object fieldValue = f.get(entityModel);
            if (fieldValue instanceof ModelRenderer[] || fieldValue instanceof Collection) {
                ModelRenderer[] collectionArray = null;
                if (fieldValue instanceof ModelRenderer[]) {
                    collectionArray = (ModelRenderer[])fieldValue;
                } else if (fieldValue instanceof Collection) {
                    Collection collection = (Collection)fieldValue;
                    try {
                        collectionArray = collection.toArray(ONE_RENDERER_ARRAY);
                    }
                    catch (ArrayStoreException ase) {
                        throw new IllegalArgumentException("Field " + f.getName() + " is not a collection of model parts (ModelRenderer on forge).", ase);
                    }
                }
                if (collectionArray.length > 0) {
                    if (matchedFilterElement != null && matchedFilterElement.endsWith("]")) {
                        int lastStartBracket = matchedFilterElement.lastIndexOf(91);
                        if (lastStartBracket == -1) {
                            throw new IllegalArgumentException("Model part field name " + matchedFilterElement + " ends with ] but is missing [!");
                        }
                        try {
                            String[] indicesString = matchedFilterElement.substring(lastStartBracket + 1, matchedFilterElement.length() - 1).split("[,;]");
                            ModelRenderer[] result = indicesString.length == 1 ? ONE_RENDERER_ARRAY : new ModelRenderer[indicesString.length];
                            for (int i = 0; i < indicesString.length; ++i) {
                                String indexString = indicesString[i];
                                int elementIndex = Integer.parseInt(indexString.trim());
                                result[i] = collectionArray[elementIndex];
                            }
                            ModelRenderer[] modelRendererArray = result;
                            return modelRendererArray;
                        }
                        catch (Exception nfe) {
                            throw new IllegalArgumentException("Invalid element index/indices in " + matchedFilterElement + "!", nfe);
                        }
                    }
                    ModelRenderer[] modelRendererArray = collectionArray;
                    return modelRendererArray;
                }
                throw new IllegalArgumentException("Empty collection referenced " + matchedFilterElement + "!");
            }
            EntityIconPrerenderer.ONE_RENDERER_ARRAY[0] = (ModelRenderer)fieldValue;
            ModelRenderer[] modelRendererArray = ONE_RENDERER_ARRAY;
            return modelRendererArray;
        }
        finally {
            f.setAccessible(accessibleBU);
        }
    }

    public ModelRenderer searchSuperclassFields(IVertexBuilder vertexBuilder, EntityModel entityModel, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Class<?> modelClass = entityModel.getClass();
        while (modelClass != EntityModel.class && modelClass != AgeableModel.class && modelClass != SegmentedModel.class) {
            Field[] declaredModelFields = modelClass.getDeclaredFields();
            mainPart = this.handleFields(vertexBuilder, entityModel, declaredModelFields, renderedModels, mainPart, filter, justOne, zeroRotation, mrde);
            if ((!justOne || mainPart == null) && (modelClass = modelClass.getSuperclass()) != null) continue;
        }
        return mainPart;
    }

    public ModelRenderer handleFields(IVertexBuilder vertexBuilder, EntityModel entityModel, Field[] declaredModelFields, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        block9: for (Field f : declaredModelFields) {
            try {
                f.getType().asSubclass(ModelRenderer.class);
            }
            catch (ClassCastException cce) {
                try {
                    f.getType().asSubclass(ModelRenderer[].class);
                }
                catch (ClassCastException cce1) {
                    try {
                        f.getType().asSubclass(Collection.class);
                    }
                    catch (ClassCastException cce2) {
                        continue;
                    }
                }
            }
            try {
                ModelRenderer[] renderers;
                String comparisonName = f.getDeclaringClass().getName() + ";" + f.getName();
                String matchedFilterElement = null;
                if (filter != null && (matchedFilterElement = this.passesFilter(comparisonName, filter)) == null) continue;
                for (ModelRenderer mr : renderers = EntityIconPrerenderer.handleDeclaredField(f, entityModel, matchedFilterElement)) {
                    if (mainPart == null) {
                        mainPart = mr;
                    }
                    this.entityModelPartsRenderer.renderPart(this.matrixStack, vertexBuilder, mr, renderedModels, mainPart, zeroRotation, mrde);
                    if (justOne) break block9;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return mainPart;
    }

    private String passesFilter(String entry, List<String> filter) {
        for (String f : filter) {
            if (f.equals(entry)) {
                return f;
            }
            int indexOfBracket = f.lastIndexOf(91);
            if (indexOfBracket == -1 || !f.substring(0, indexOfBracket).equals(entry)) continue;
            return f;
        }
        return null;
    }

    public void generateMipmaps() {
        this.modelRenderFramebuffer.generateMipmaps();
    }

    public void onModelRenderDetection(EntityModel<?> model, float red, float green, float blue, float alpha) {
        ResourceLocation texture;
        RenderState.TextureState renderTextureState;
        RenderType.State renderState;
        if (this.modelRenderDetectionEntityModelClass == null) {
            EntityModel currentMainModel = this.getEntityRendererModel(this.modelRenderDetectionEntityRenderer);
            Class<?> clazz = this.modelRenderDetectionEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
        }
        if (this.modelRenderDetectionEntityModelClass != model.getClass()) {
            return;
        }
        RenderType lastRenderType = this.getLastRenderType((IRenderTypeBuffer)this.modelRenderDetectionRenderTypeBuffer);
        if (lastRenderType != null && (renderState = this.getRenderState(lastRenderType)) != null && (renderTextureState = (RenderState.TextureState)Misc.getReflectFieldValue(renderState, this.renderStateTextureStateField)) != null && (texture = this.getRenderStateTextureStateTexture(renderTextureState)) != null) {
            lastRenderType.func_228547_a_();
            Object BLEND = Misc.getReflectFieldValue(null, this.blendStateField);
            Object DEPTH = Misc.getReflectFieldValue(null, this.depthStateField);
            Object COLOR_MASK = Misc.getReflectFieldValue(null, this.colorMaskStateField);
            Object CULL = Misc.getReflectFieldValue(null, this.cullStateField);
            int blendSrcFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateSrcFactorField);
            int blendDestFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateDestFactorField);
            int blendAlphaSrcFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateAlphaSrcFactorField);
            int blendAlphaDestFactor = (Integer)Misc.getReflectFieldValue(BLEND, this.blendStateAlphaDestFactorField);
            int depthFunc = (Integer)Misc.getReflectFieldValue(DEPTH, this.depthStateFuncField);
            boolean depthTest = (Boolean)Misc.getReflectFieldValue(Misc.getReflectFieldValue(DEPTH, this.depthStateTestField), this.booleanStateCurrentStateField);
            boolean depthMask = (Boolean)Misc.getReflectFieldValue(DEPTH, this.depthStateMaskField);
            boolean colorMaskR = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateRedField);
            boolean colorMaskG = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateGreenField);
            boolean colorMaskB = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateBlueField);
            boolean colorMaskA = (Boolean)Misc.getReflectFieldValue(COLOR_MASK, this.colorMaskStateAlphaField);
            boolean cullFace = (Boolean)Misc.getReflectFieldValue(Misc.getReflectFieldValue(CULL, this.cullStateEnabledField), this.booleanStateCurrentStateField);
            int cullMode = (Integer)Misc.getReflectFieldValue(CULL, this.cullStateModeField);
            lastRenderType.func_228549_b_();
            this.lastModelRenderDetected = new ModelRenderDetectionElement(model, texture, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, red, green, blue, alpha, cullFace, cullMode);
            this.modelRenderDetectionList.add(this.lastModelRenderDetected);
        }
    }

    public void onModelPartRenderDetection(ModelRenderer modelRenderer, float red, float green, float blue, float alpha) {
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    private RenderType getLastRenderType(IRenderTypeBuffer renderTypeBuffer) {
        if (renderTypeBuffer instanceof IRenderTypeBuffer.Impl) {
            Object lastRenderTypeObject = Misc.getReflectFieldValue(renderTypeBuffer, this.lastRenderTypeField);
            RenderType lastRenderType = null;
            lastRenderType = lastRenderTypeObject instanceof Optional ? (RenderType)((Optional)lastRenderTypeObject).get() : (RenderType)lastRenderTypeObject;
            return lastRenderType;
        }
        return null;
    }

    private RenderType.State getRenderState(RenderType renderType) {
        if (renderType.getClass() == this.renderTypeTypeClass) {
            RenderType.State renderState = (RenderType.State)Misc.getReflectFieldValue(renderType, this.renderStateField);
            return renderState;
        }
        return null;
    }

    private ResourceLocation getRenderStateTextureStateTexture(RenderState.TextureState textureState) {
        Object renderStateTextureObject = Misc.getReflectFieldValue(textureState, this.renderStateTextureStateTextureField);
        ResourceLocation renderStateTexture = null;
        renderStateTexture = renderStateTextureObject instanceof Optional ? (ResourceLocation)((Optional)renderStateTextureObject).get() : (ResourceLocation)renderStateTextureObject;
        return renderStateTexture;
    }

    private boolean renderIcon(MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffer, EntityRenderer entityRenderer, EntityModel mainEntityModel, List<ModelRenderDetectionElement> detectedModels, Entity entity, EntityIconModelConfig modelConfig) {
        EntityIconCustomRenderer entityIconCustomRenderer;
        boolean forceFieldCheck;
        boolean bl = forceFieldCheck = (modelConfig.renderingFullModel == null || modelConfig.renderingFullModel == false) && modelConfig.modelPartsFields != null;
        boolean fullModelIcon = modelConfig.renderingFullModel == null ? !forceFieldCheck && EntityIconDefinitions.fullModelIcon(mainEntityModel) : modelConfig.renderingFullModel;
        ModelRenderer mainPart = null;
        boolean renderedSomething = false;
        ArrayList<ModelRenderer> mainRenderedModels = new ArrayList<ModelRenderer>();
        ResourceLocation mainEntityTexture = entityRenderer.func_110775_a(entity);
        if (detectedModels.isEmpty()) {
            detectedModels.add(new ModelRenderDetectionElement(mainEntityModel, mainEntityTexture, 770, 771, 1, 771, true, 515, true, true, true, true, true, 1.0f, 1.0f, 1.0f, 1.0f, false, 1029));
        }
        boolean allEmpty = true;
        for (ModelRenderDetectionElement modelRenderDetectionElement : detectedModels) {
            if (modelRenderDetectionElement.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            for (ModelRenderDetectionElement modelRenderDetectionElement : detectedModels) {
                modelRenderDetectionElement.allVisible = true;
            }
        }
        ModelRenderDetectionElement mainMrde = null;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            boolean mainPartsVisibility;
            if (mrde.isEmpty() || renderedSomething && !modelConfig.layersAllowed) continue;
            EntityModel<?> detectedModel = mrde.model;
            ResourceLocation detectedTexture = mrde.renderTexture;
            boolean mainModel = detectedModel == mainEntityModel;
            boolean bl2 = mainPartsVisibility = mainModel && mainMrde != null && mrde.sameVisibility(mainMrde);
            if (mainModel && !mainPartsVisibility) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                mainRenderedModels.clear();
                mainPart = this.renderModel(matrixStack, renderTypeBuffer, entityRenderer, detectedModel, entity, modelConfig, mainPart, mainRenderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde);
                mainMrde = mrde;
                renderedSomething = renderedSomething || !mainRenderedModels.isEmpty();
                continue;
            }
            if (!mainModel) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                ArrayList<ModelRenderer> renderedModels = new ArrayList<ModelRenderer>();
                mainPart = this.renderModel(matrixStack, renderTypeBuffer, entityRenderer, detectedModel, entity, modelConfig, mainPart, renderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde);
                renderedSomething = renderedSomething || !renderedModels.isEmpty();
                continue;
            }
            if (mainRenderedModels.isEmpty()) continue;
            IVertexBuilder vertexBuilder = this.setupModelRenderType(renderTypeBuffer, detectedTexture, mrde);
            this.entityModelPartsRenderer.renderPartsIterable(mainRenderedModels, matrixStack, vertexBuilder, new ArrayList<ModelRenderer>(), mainPart, modelConfig.modelPartsRotationReset, mrde);
            renderTypeBuffer.func_228461_a_();
        }
        if (!mainRenderedModels.isEmpty() && modelConfig.layersAllowed && (entityIconCustomRenderer = EntityIconDefinitions.getCustomLayer(entityRenderer, entity)) != null) {
            mainPart = entityIconCustomRenderer.render(matrixStack, renderTypeBuffer, entityRenderer, entity, mainEntityModel, this.entityModelPartsRenderer, mainRenderedModels, mainPart, modelConfig, mainMrde);
        }
        return renderedSomething;
    }

    private boolean resetModelRotations(Entity entity, EntityModel model) {
        try {
            model.func_212843_a_(entity, 0.0f, 0.0f, 1.0f);
            model.func_225597_a_(entity, 0.0f, 0.0f, (float)entity.field_70173_aa, 0.0f, 0.0f);
            OpenGLException.checkGLError();
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private EntityModel getEntityRendererModel(EntityRenderer entityRenderer) {
        if (entityRenderer instanceof LivingRenderer) {
            return ((LivingRenderer)entityRenderer).func_217764_d();
        }
        if (entityRenderer instanceof EnderDragonRenderer) {
            return (EntityModel)Misc.getReflectFieldValue(entityRenderer, this.enderDragonModelField);
        }
        return null;
    }
}

