/*
 * Decompiled with CFR 0.152.
 */
package xaero.minimap;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapCommonBase;
import xaero.common.XaeroMinimapSession;
import xaero.common.controls.ControlsRegister;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.events.FMLEventHandler;
import xaero.common.events.ForgeEventHandler;
import xaero.common.events.ModCommonEvents;
import xaero.common.events.ModEvents;
import xaero.common.file.SimpleBackup;
import xaero.common.gui.GuiHelper;
import xaero.common.gui.widget.WidgetLoadingHandler;
import xaero.common.gui.widget.WidgetScreenHandler;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.message.LevelMapPropertiesCoder;
import xaero.common.message.LevelMapPropertiesConsumer;
import xaero.common.misc.Internet;
import xaero.common.mods.SupportMods;
import xaero.common.server.XaeroMinimapServer;
import xaero.common.server.core.XaeroMinimapServerCore;
import xaero.common.server.level.LevelMapProperties;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.common.validator.FieldValidatorHolder;
import xaero.common.validator.NumericFieldValidator;
import xaero.minimap.XaeroMinimapClient;
import xaero.minimap.XaeroMinimapStandaloneSession;
import xaero.minimap.controls.MinimapControlsRegister;
import xaero.minimap.gui.MinimapGuiHelper;
import xaero.minimap.interfaces.MinimapInterfaceLoader;
import xaero.patreon.Patreon6;
import xaero.patreon.PatreonMod4;

@Mod(value="xaerominimap")
public class XaeroMinimap
implements IXaeroMinimap {
    private static final boolean ENABLED = true;
    public static XaeroMinimap instance;
    private final Logger LOGGER = LogManager.getLogger();
    private static final String versionID_minecraft = "1.15.2";
    private static final String versionID_mod = "21.10.0.3";
    private static final boolean versionID_fair;
    public static final String versionID;
    private int newestUpdateID;
    private boolean isOutdated = true;
    private String fileLayoutID = versionID_fair ? "minimapfair" : "minimap";
    private String latestVersion;
    private String latestVersionMD5;
    private static final File old_optionsFile;
    private static final File oldConfigFile;
    private ModSettings settings;
    private String message = "";
    private ControlsRegister controlsRegister;
    private ForgeEventHandler events;
    protected InterfaceRenderer interfaceRenderer;
    protected InterfaceManager interfaces;
    private GuiHelper guiHelper;
    private FieldValidatorHolder fieldValidators;
    private SupportMods supportMods;
    private WidgetScreenHandler widgetScreenHandler;
    private WidgetLoadingHandler widgetLoader;
    private File modJAR = null;
    private File configFile;
    public File waypointsFile;
    public File waypointsFolder;
    private static final SimpleChannel network;

    public XaeroMinimap() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadCommon);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadServer);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModCommonEvents());
    }

    private void loadClient(FMLClientSetupEvent event) {
        try {
            SupportMods.checkForMinimapDuplicates();
            this.LOGGER.info("Loading Xaero's Minimap - Stage 1/2");
            ModOptions.init(this);
            String modId = this.getClass().getAnnotation(Mod.class).value();
            ModFile modFile = FMLLoader.getLoadingModList().getModFileById(modId).getFile();
            new XaeroMinimapClient().preInit(event, modId, this);
            String fileName = modFile.getFileName();
            if (fileName.endsWith(".jar")) {
                this.modJAR = modFile.getFilePath().toFile();
            }
            Path gameDir = FMLPaths.GAMEDIR.get();
            Path config = FMLPaths.CONFIGDIR.get();
            this.waypointsFile = config.resolve("xaerowaypoints.txt").toFile();
            Path wrongWaypointsFolder3 = config.resolve("XaeroWaypoints");
            Path wrongWaypointsFolder2 = this.modJAR != null ? this.modJAR.toPath().getParent().resolve("XaeroWaypoints") : config.getParent().resolve("mods").resolve("XaeroWaypoints");
            Path wrongWaypointsFolder4 = new File(config.toFile().getCanonicalPath()).toPath().getParent().resolve("XaeroWaypoints");
            Path wrongWaypointsFolder5 = config.getParent().resolve("XaeroWaypoints");
            this.waypointsFolder = gameDir.resolve("XaeroWaypoints").toFile();
            if (wrongWaypointsFile.exists() && !this.waypointsFile.exists()) {
                Files.move(wrongWaypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
            }
            if (wrongWaypointsFolder.exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder.toPath(), this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder2.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder2, this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder3.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder3, this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder4.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder4, this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder5.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder5, this.waypointsFolder.toPath(), new CopyOption[0]);
            }
            Path waypointsFolderBackup062020 = this.waypointsFolder.toPath().resolveSibling(this.waypointsFolder.getName() + "_BACKUP032021");
            if (!Files.exists(waypointsFolderBackup062020, new LinkOption[0]) && this.waypointsFolder.exists()) {
                System.out.println("Backing up XaeroWaypoints...");
                SimpleBackup.copyDirectoryWithContents(this.waypointsFolder.toPath(), waypointsFolderBackup062020, 32, new CopyOption[0]);
                System.out.println("Done backing up XaeroWaypoints!");
            }
            this.configFile = config.resolve("xaerominimap.txt").toFile();
            if (oldConfigFile.exists() && !this.configFile.getAbsolutePath().equals(oldConfigFile.getAbsolutePath())) {
                Files.move(oldConfigFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
            }
            Patreon6.checkPatreon();
            Patreon6.rendersCapes = this.fileLayoutID;
            this.widgetScreenHandler = new WidgetScreenHandler();
            this.widgetLoader = new WidgetLoadingHandler(this.widgetScreenHandler);
            this.controlsRegister = new MinimapControlsRegister();
            this.guiHelper = new MinimapGuiHelper(this);
            this.fieldValidators = new FieldValidatorHolder(new NumericFieldValidator());
            this.interfaceRenderer = new InterfaceRenderer(this);
            MinimapInterfaceLoader interfaceLoader = new MinimapInterfaceLoader();
            this.interfaces = new InterfaceManager(this, interfaceLoader);
            ModEvents modEvents = new ModEvents(this);
            FMLJavaModLoadingContext.get().getModEventBus().register((Object)modEvents);
            XaeroMinimapCore.modMain = this;
            DeferredWorkQueue.runLater(this::loadLater);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadLater() {
        this.LOGGER.info("Loading Xaero's Minimap - Stage 2/2");
        try {
            this.events = new ForgeEventHandler(this);
            MinecraftForge.EVENT_BUS.register((Object)this.events);
            MinecraftForge.EVENT_BUS.register((Object)new FMLEventHandler(this));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            PatreonMod4 patreonEntry;
            LevelMapPropertiesCoder levelMapPropertiesCoder = new LevelMapPropertiesCoder();
            network.registerMessage(0, LevelMapProperties.class, (BiConsumer)levelMapPropertiesCoder, (Function)((Object)levelMapPropertiesCoder), (BiConsumer)new LevelMapPropertiesConsumer());
            if (old_optionsFile.exists() && !this.configFile.exists()) {
                this.configFile.getParentFile().mkdirs();
                Files.move(old_optionsFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
            }
            if (old_waypointsFile.exists() && !this.waypointsFile.exists()) {
                this.waypointsFile.getParentFile().mkdirs();
                Files.move(old_waypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
            }
            this.settings = new ModSettings(this);
            this.settings.loadSettings();
            Internet.checkModVersion(this);
            if (this.isOutdated && (patreonEntry = this.getPatreon()) != null) {
                patreonEntry.modJar = this.modJAR;
                patreonEntry.currentVersion = versionID;
                patreonEntry.latestVersion = this.latestVersion;
                patreonEntry.md5 = this.latestVersionMD5;
                patreonEntry.onVersionIgnore = () -> {
                    ModSettings.ignoreUpdate = this.newestUpdateID;
                    try {
                        this.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                };
                Patreon6.addOutdatedMod(patreonEntry);
            }
            this.supportMods = new SupportMods(this);
        }
        catch (Throwable e) {
            this.interfaces.getMinimapInterface().setCrashedWith(e);
        }
    }

    private void loadCommon(FMLCommonSetupEvent event) {
        new XaeroMinimapCommonBase().setup(event);
    }

    private void loadServer(FMLDedicatedServerSetupEvent event) {
        XaeroMinimapServer minimapServer = new XaeroMinimapServer(this);
        minimapServer.load(event);
        XaeroMinimapServerCore.minimapServer = minimapServer;
        DeferredWorkQueue.runLater(minimapServer::loadLater);
    }

    @Override
    public String getVersionsURL() {
        return "http://data.chocolateminecraft.com/Versions_" + Patreon6.KEY_VERSION + "/Minimap.txt";
    }

    @Override
    public String getUpdateLink() {
        return "http://chocolateminecraft.com/update/minimap.html";
    }

    @Override
    public SimpleChannel getNetwork() {
        return network;
    }

    @Override
    public File getOldOptionsFile() {
        return old_optionsFile;
    }

    @Override
    public File getOldConfigFile() {
        return oldConfigFile;
    }

    @Override
    public String getFileLayoutID() {
        return this.fileLayoutID;
    }

    @Override
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public File getModJAR() {
        return this.modJAR;
    }

    @Override
    public ModSettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(ModSettings minimapSettings) {
        this.settings = minimapSettings;
    }

    @Override
    public void resetSettings() throws IOException {
        this.settings = new ModSettings(this);
        this.settings.loadDefaultSettings();
    }

    @Override
    public boolean isOutdated() {
        return this.isOutdated;
    }

    @Override
    public void setOutdated(boolean value) {
        this.isOutdated = value;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String string) {
        this.message = string;
    }

    @Override
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public void setLatestVersion(String string) {
        this.latestVersion = string;
    }

    @Override
    public int getNewestUpdateID() {
        return this.newestUpdateID;
    }

    @Override
    public void setNewestUpdateID(int parseInt) {
        this.newestUpdateID = parseInt;
    }

    @Override
    public PatreonMod4 getPatreon() {
        return Patreon6.mods.get(this.fileLayoutID);
    }

    @Override
    public String getVersionID() {
        return versionID;
    }

    @Override
    public Object getSettingsKey() {
        return MinimapControlsRegister.keyBindSettings;
    }

    @Override
    public File getWaypointsFile() {
        return this.waypointsFile;
    }

    @Override
    public File getWaypointsFolder() {
        return this.waypointsFolder;
    }

    @Override
    public Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    public WidgetScreenHandler getWidgetScreenHandler() {
        return this.widgetScreenHandler;
    }

    @Override
    public WidgetLoadingHandler getWidgetLoader() {
        return this.widgetLoader;
    }

    @Override
    public XaeroMinimapSession createSession() {
        return new XaeroMinimapStandaloneSession(this);
    }

    @Override
    public SupportMods getSupportMods() {
        return this.supportMods;
    }

    @Override
    public GuiHelper getGuiHelper() {
        return this.guiHelper;
    }

    @Override
    public FieldValidatorHolder getFieldValidators() {
        return this.fieldValidators;
    }

    @Override
    public ControlsRegister getControlsRegister() {
        return this.controlsRegister;
    }

    @Override
    public ForgeEventHandler getEvents() {
        return this.events;
    }

    @Override
    public InterfaceManager getInterfaces() {
        return this.interfaces;
    }

    @Override
    public InterfaceRenderer getInterfaceRenderer() {
        return this.interfaceRenderer;
    }

    @Override
    public void setLatestVersionMD5(String string) {
        this.latestVersionMD5 = string;
    }

    @Override
    public String getLatestVersionMD5() {
        return this.latestVersionMD5;
    }

    static {
        versionID_fair = XaeroMinimap.class.getAnnotation(Mod.class).value().endsWith("fair");
        versionID = "1.15.2_21.10.0.3" + (versionID_fair ? "_fair" : "");
        old_optionsFile = new File("xaerominimap.txt");
        oldConfigFile = new File("config/xaerominimap.txt");
        network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("xaerominimap", "main"), () -> "1.0", s -> true, s -> true);
    }
}

