/*
 * Decompiled with CFR 0.152.
 */
package xaero.minimap.gui;

import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiMinimapSettings;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ModOptionButton;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.minimap.gui.GuiMinimap2;

public class GuiMinimap
extends GuiMinimapSettings {
    private Button waypointsButton;

    public GuiMinimap(IXaeroMinimap modMain, Screen par1GuiScreen, Screen escScreen) {
        super(modMain, (TextComponent)new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_minimap_settings", (Object[])new Object[0]) + "  1"), par1GuiScreen, escScreen);
        this.options = new ModOptions[]{ModOptions.MINIMAP, ModOptions.EDIT, ModOptions.SIZE, ModOptions.MINIMAP_SHAPE, ModOptions.CAVE_MAPS, ModOptions.DOTS, ModOptions.WAYPOINTS, ModOptions.INGAME_WAYPOINTS, ModOptions.NORTH, ModOptions.DEATHPOINTS, ModOptions.CHUNK_GRID, ModOptions.OLD_DEATHPOINTS};
    }

    @Override
    public void init() {
        super.init();
        for (int i = 0; i < this.buttons.size(); ++i) {
            Widget widget = (Widget)this.buttons.get(i);
            if (!(widget instanceof ModOptionButton) || ((ModOptionButton)widget).getModOption() != ModOptions.EDIT) continue;
            widget.setMessage(I18n.func_135052_a((String)"gui.xaero_change_position", (Object[])new Object[0]));
        }
        if (ModSettings.serverSettings != ModSettings.defaultSettings) {
            this.screenTitle = "\u00a7e" + I18n.func_135052_a((String)"gui.xaero_server_disabled", (Object[])new Object[0]);
        }
        this.waypointsButton = new Button(this.width / 2 - 100, this.height / 7 + 144, 200, 20, I18n.func_135052_a((String)"gui.xaero_waypoints", (Object[])new Object[0]), b -> {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null && this.modMain.getSettings().waypointsGUI(minimapSession.getWaypointsManager())) {
                this.minecraft.func_147108_a((Screen)new GuiWaypoints(this.modMain, minimapSession, (Screen)this, this.escape));
            }
        });
        this.addButton((Widget)this.waypointsButton);
    }

    @Override
    public void render(int par1, int par2, float par3) {
        this.waypointsButton.active = false;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            this.waypointsButton.active = this.modMain.getSettings().waypointsGUI(minimapSession.getWaypointsManager());
        }
        super.render(par1, par2, par3);
    }

    @Override
    protected boolean isNextButtonEnabled() {
        return true;
    }

    @Override
    protected boolean isPrevButtonEnabled() {
        return false;
    }

    @Override
    protected void onNextButton() {
        this.minecraft.func_147108_a((Screen)new GuiMinimap2(this.modMain, this.parent, this.escape));
    }

    @Override
    protected void onPrevButton() {
    }
}

