/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.controls;

import com.google.common.collect.Lists;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import org.lwjgl.glfw.GLFW;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiSlimeSeed;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public class ControlsHandler {
    protected IXaeroMinimap modMain;
    protected XaeroMinimapSession minimapSession;
    protected WaypointsManager waypointsManager;
    protected MinimapProcessor minimap;

    public ControlsHandler(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.minimap = minimapSession.getMinimapProcessor();
    }

    public void setKeyState(KeyBinding kb, boolean pressed) {
        KeyBinding.func_197980_a((InputMappings.Input)kb.getKey(), (boolean)pressed);
    }

    public boolean isDown(KeyBinding kb) {
        if (kb.getKey().func_197937_c() == -1) {
            return false;
        }
        if (kb.getKey().func_197938_b() == InputMappings.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)kb.getKey().func_197937_c()) == 1;
        }
        if (kb.getKey().func_197938_b() == InputMappings.Type.KEYSYM) {
            return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)kb.getKey().func_197937_c());
        }
        return false;
    }

    public void keyDownPre(KeyBinding kb) {
    }

    public void keyDownPost(KeyBinding kb) {
    }

    public void keyDown(KeyBinding kb, boolean tickEnd, boolean isRepeat) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!tickEnd) {
            WaypointWorld currentWorld;
            Screen currentEscScreen;
            Screen current;
            this.keyDownPre(kb);
            if (kb == ModSettings.newWaypoint && this.modMain.getSettings().waypointsGUI(this.waypointsManager)) {
                mc.func_147108_a((Screen)new GuiAddWaypoint(this.modMain, this.waypointsManager, null, Lists.newArrayList(), this.waypointsManager.getCurrentContainerID().split("/")[0], this.waypointsManager.getCurrentWorld(), true));
            }
            if (kb == ModSettings.keyWaypoints && this.modMain.getSettings().waypointsGUI(this.waypointsManager)) {
                current = mc.field_71462_r;
                currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                mc.func_147108_a((Screen)new GuiWaypoints(this.modMain, this.minimapSession, current, currentEscScreen));
            }
            if (kb == ModSettings.keyLargeMap) {
                this.minimapSession.getMinimapProcessor().setEnlargedMap(true);
                this.minimap.setToResetImage(true);
                this.minimap.instantZoom();
            }
            if (!(kb != ModSettings.keyToggleMap || mc.field_71439_g.func_70644_a(Effects.NO_MINIMAP) || mc.field_71439_g.func_70644_a(Effects.NO_MINIMAP_BENEFICIAL) || mc.field_71439_g.func_70644_a(Effects.NO_MINIMAP_HARMFUL))) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.MINIMAP);
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keyToggleWaypoints) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.INGAME_WAYPOINTS);
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keyToggleMapWaypoints) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.WAYPOINTS);
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keyToggleSlimes) {
                try {
                    if (this.modMain.getSettings().customSlimeSeedNeeded(this.minimapSession) && this.modMain.getSettings().getBooleanValue(ModOptions.OPEN_SLIME_SETTINGS)) {
                        current = mc.field_71462_r;
                        currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                        Minecraft.func_71410_x().func_147108_a((Screen)new GuiSlimeSeed(this.modMain, this.waypointsManager, current, currentEscScreen));
                    } else {
                        this.modMain.getSettings().slimeChunks = !this.modMain.getSettings().slimeChunks;
                        this.modMain.getSettings().saveSettings();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keyToggleGrid) {
                try {
                    this.modMain.getSettings().chunkGrid = -this.modMain.getSettings().chunkGrid - 1;
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!(kb != ModSettings.keyInstantWaypoint || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_BENEFICIAL) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL))) {
                this.waypointsManager.createTemporaryWaypoints(this.waypointsManager.getCurrentWorld(), OptimizedMath.myFloor(mc.field_71439_g.func_226277_ct_()), OptimizedMath.myFloor(mc.field_71439_g.func_226278_cu_()), OptimizedMath.myFloor(mc.field_71439_g.func_226281_cx_()));
            }
            if (kb == ModSettings.keySwitchSet && (currentWorld = this.waypointsManager.getCurrentWorld()) != null) {
                String[] keys = currentWorld.getSets().keySet().toArray(new String[0]);
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] == null || !keys[i].equals(currentWorld.getCurrent())) continue;
                    currentWorld.setCurrent(keys[(i + 1) % keys.length]);
                    break;
                }
                this.waypointsManager.updateWaypoints();
                this.waypointsManager.setChanged = System.currentTimeMillis();
                try {
                    this.modMain.getSettings().saveWaypoints(currentWorld);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keyAllSets) {
                this.modMain.getSettings().setOptionValue(ModOptions.WAYPOINTS_ALL_SETS);
            }
            if (kb == ModSettings.keyLightOverlay) {
                this.modMain.getSettings().lightOverlayType = this.modMain.getSettings().lightOverlayType == 0 ? 1 : (this.modMain.getSettings().lightOverlayType *= -1);
                try {
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!this.minimapSession.getMinimapProcessor().isEnlargedMap() || !this.modMain.getSettings().zoomedOutEnlarged) {
                if (kb == ModSettings.keyBindZoom) {
                    this.modMain.getSettings().setOptionValue(ModOptions.ZOOM);
                }
                if (kb == ModSettings.keyBindZoom1) {
                    --this.modMain.getSettings().zoom;
                    if (this.modMain.getSettings().zoom == -1) {
                        this.modMain.getSettings().zoom = this.modMain.getSettings().zooms.length - 1;
                    }
                    try {
                        this.modMain.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.keyDownPost(kb);
        }
    }

    public void keyUpPre(KeyBinding kb) {
    }

    public void keyUpPost(KeyBinding kb) {
    }

    public void keyUp(KeyBinding kb, boolean tickEnd) {
        if (!tickEnd) {
            this.keyUpPre(kb);
            if (kb == ModSettings.keyLargeMap) {
                this.minimapSession.getMinimapProcessor().setEnlargedMap(false);
                this.minimap.setToResetImage(true);
                this.minimap.instantZoom();
            }
            this.keyUpPost(kb);
        }
    }
}

