/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.lwjgl.opengl.GL11;
import xaero.common.minimap.render.radar.ModelPartRenderDetectionInfo;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;

public class EntityIconModelPartsRenderer {
    public Method ageableModelHeadPartsMethod;
    public Method ageableModelBodyPartsMethod;
    public Method segmentedModelPartsMethod;
    private Field cubeListField;
    private Field childModelsField;

    public EntityIconModelPartsRenderer() {
        try {
            this.ageableModelHeadPartsMethod = AgeableModel.class.getDeclaredMethod("func_225602_a_", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                this.ageableModelHeadPartsMethod = AgeableModel.class.getDeclaredMethod("getHeadParts", new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.ageableModelBodyPartsMethod = AgeableModel.class.getDeclaredMethod("func_225600_b_", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                this.ageableModelBodyPartsMethod = AgeableModel.class.getDeclaredMethod("getBodyParts", new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.segmentedModelPartsMethod = SegmentedModel.class.getDeclaredMethod("func_225601_a_", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                this.segmentedModelPartsMethod = SegmentedModel.class.getDeclaredMethod("getParts", new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.cubeListField = ModelRenderer.class.getDeclaredField("field_78804_l");
        }
        catch (NoSuchFieldException e) {
            try {
                this.cubeListField = ModelRenderer.class.getDeclaredField("cubeList");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.childModelsField = ModelRenderer.class.getDeclaredField("field_78805_m");
        }
        catch (NoSuchFieldException e) {
            try {
                this.childModelsField = ModelRenderer.class.getDeclaredField("childModels");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectList<ModelRenderer.ModelBox> getCubeList(ModelRenderer modelRenderer) {
        boolean accessibleBU = this.cubeListField.isAccessible();
        this.cubeListField.setAccessible(true);
        try {
            ObjectList objectList = (ObjectList)this.cubeListField.get(modelRenderer);
            return objectList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.cubeListField.setAccessible(accessibleBU);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectList<ModelRenderer> getChildModels(ModelRenderer modelRenderer) {
        boolean accessibleBU = this.childModelsField.isAccessible();
        this.childModelsField.setAccessible(true);
        try {
            ObjectList objectList = (ObjectList)this.childModelsField.get(modelRenderer);
            return objectList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.childModelsField.setAccessible(accessibleBU);
        }
        return null;
    }

    private boolean hasCubes(ModelRenderer mr) {
        ObjectList<ModelRenderer.ModelBox> mrCubeList = this.getCubeList(mr);
        if (mrCubeList != null && !mrCubeList.isEmpty()) {
            return true;
        }
        ObjectList<ModelRenderer> mrChildren = this.getChildModels(mr);
        for (ModelRenderer child : mrChildren) {
            if (!this.hasCubes(child)) continue;
            return true;
        }
        return false;
    }

    public void renderPart(MatrixStack matrixStack, IVertexBuilder vertexBuilder, ModelRenderer mr, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainModelPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (mr == null) {
            return;
        }
        if (renderedModels.contains(mr)) {
            return;
        }
        ModelPartRenderDetectionInfo renderInfo = mrde.getModelPartRenderInfo(mr);
        if (renderInfo == null) {
            return;
        }
        if (!this.hasCubes(mr)) {
            return;
        }
        float rotationPointBUX = mr.field_78800_c;
        float rotationPointBUY = mr.field_78797_d;
        float rotationPointBUZ = mr.field_78798_e;
        float rotateAngleBUX = mr.field_78795_f;
        float rotateAngleBUY = mr.field_78796_g;
        float rotateAngleBUZ = mr.field_78808_h;
        boolean showModelBU = mr.field_78806_j;
        float centerPointX = mainModelPart.field_78800_c;
        float centerPointY = mainModelPart.field_78797_d;
        float centerPointZ = mainModelPart.field_78798_e;
        ObjectList<ModelRenderer.ModelBox> mainCubeList = this.getCubeList(mainModelPart);
        if (mainCubeList != null && !mainCubeList.isEmpty()) {
            ModelRenderer.ModelBox firstBox = (ModelRenderer.ModelBox)mainCubeList.get(0);
            centerPointX += (firstBox.field_78248_d + firstBox.field_78252_a) / 2.0f;
            centerPointY += (firstBox.field_78249_e + firstBox.field_78250_b) / 2.0f;
            centerPointZ += (firstBox.field_78246_f + firstBox.field_78251_c) / 2.0f;
        }
        if (zeroRotation) {
            mr.field_78795_f = 0.0f;
            mr.field_78796_g = 0.0f;
            mr.field_78808_h = 0.0f;
        }
        mr.field_78806_j = true;
        try {
            mr.func_78793_a(mr.field_78800_c - centerPointX, mr.field_78797_d - centerPointY, mr.field_78798_e - centerPointZ);
            mr.func_228309_a_(matrixStack, vertexBuilder, 0xF000F0, OverlayTexture.field_229196_a_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
            renderedModels.add(mr);
        }
        catch (Throwable t) {
            System.out.println("Exception when rendering entity part. " + mr);
        }
        while (GL11.glGetError() != 0) {
        }
        mr.field_78800_c = rotationPointBUX;
        mr.field_78797_d = rotationPointBUY;
        mr.field_78798_e = rotationPointBUZ;
        if (zeroRotation) {
            mr.field_78795_f = rotateAngleBUX;
            mr.field_78796_g = rotateAngleBUY;
            mr.field_78808_h = rotateAngleBUZ;
        }
        mr.field_78806_j = showModelBU;
    }

    public ModelRenderer renderDeclaredMethod(MatrixStack matrixStack, IVertexBuilder vertexBuilder, Method m, EntityModel entityModel, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Iterable<ModelRenderer> renderers = this.handleDeclaredMethod(m, entityModel);
        return this.renderPartsIterable(renderers, matrixStack, vertexBuilder, renderedModels, mainPart, zeroRotation, mrde);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ModelRenderer> handleDeclaredMethod(Method m, EntityModel entityModel) {
        if (m != null) {
            boolean accessibleBU = m.isAccessible();
            m.setAccessible(true);
            try {
                Iterable iterable = (Iterable)m.invoke((Object)entityModel, new Object[0]);
                return iterable;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                m.setAccessible(accessibleBU);
            }
        }
        return null;
    }

    public ModelRenderer renderPartsIterable(Iterable<ModelRenderer> parts, MatrixStack matrixStack, IVertexBuilder vertexBuilder, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<ModelRenderer> partsIterator = parts.iterator();
        if (partsIterator.hasNext()) {
            if (mainPart == null) {
                mainPart = partsIterator.next();
                this.renderPart(matrixStack, vertexBuilder, mainPart, renderedModels, mainPart, zeroRotation, mrde);
            }
            while (partsIterator.hasNext()) {
                this.renderPart(matrixStack, vertexBuilder, partsIterator.next(), renderedModels, mainPart, zeroRotation, mrde);
            }
        }
        return mainPart;
    }
}

