/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiMisc;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    public static final float DEFAULT_SCALE = 0.8f;
    public static final float MINECRAFT_SCALE = 0.02666667f;
    private IXaeroMinimap modMain;
    private MatrixStack identityMatrixStack;

    public WaypointsIngameRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
        this.identityMatrixStack = new MatrixStack();
    }

    public void render(XaeroMinimapSession minimapSession, float partial) {
        if (this.modMain.getSettings().getShowIngameWaypoints()) {
            Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_BENEFICIAL) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL)) {
                return;
            }
            WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
            Entity entity = mc.func_175606_aa();
            ActiveRenderInfo activeRender = Minecraft.func_71410_x().field_71460_t.func_215316_n();
            double actualEntityX = entity.func_226277_ct_();
            double actualEntityY = entity.func_226278_cu_();
            double actualEntityZ = entity.func_226281_cx_();
            Vector3d cameraPos = activeRender.func_216785_c();
            double d3 = cameraPos.func_82615_a();
            double d4 = cameraPos.func_82617_b();
            double d5 = cameraPos.func_82616_c();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.disableCull();
            RenderSystem.pushMatrix();
            boolean lookingBack = mc.field_71474_y.func_243230_g() == PointOfView.THIRD_PERSON_FRONT;
            float yaw = (float)(lookingBack ? 0 : 180) + entity.func_195046_g(partial);
            float pitch = (float)(lookingBack ? -1 : 1) * entity.func_195050_f(partial);
            RenderSystem.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.rotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            double fov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            int screenHeight = Minecraft.func_71410_x().func_228018_at_().func_198091_l();
            float cameraAngleYaw = MathHelper.func_76142_g((float)(yaw - 180.0f));
            float cameraAnglePitch = MathHelper.func_76142_g((float)pitch);
            Vector3d lookVector = entity.func_70040_Z();
            if (lookingBack) {
                lookVector = lookVector.func_216371_e();
            }
            double clampDepth = this.modMain.getSettings().getWaypointsClampDepth(fov, screenHeight);
            double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
            IRenderTypeBuffer.Impl textRenderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            if (waypointsManager.getWaypoints() != null) {
                if (this.modMain.getSettings().renderAllSets) {
                    HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                    for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                        this.renderWaypointsList(setEntry.getValue().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth, textRenderTypeBuffer);
                    }
                } else {
                    this.renderWaypointsList(waypointsManager.getWaypoints().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth, textRenderTypeBuffer);
                }
            }
            if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
                for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                    this.renderWaypointsList(modCustomWaypoints.values(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth, textRenderTypeBuffer);
                }
            }
            RenderHelper.func_74518_a();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.popMatrix();
        }
    }

    private void renderWaypointsList(Collection<Waypoint> list, double d3, double d4, double d5, Entity entity, BufferBuilder bufferbuilder, Tessellator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, float yaw, float pitch, double fov, int screenHeight, float cameraAngleYaw, float cameraAnglePitch, Vector3d lookVector, double clampDepth, IRenderTypeBuffer.Impl textRenderTypeBuffer) {
        for (Waypoint w : list) {
            this.renderWaypointIngame(cameraAngleYaw, cameraAnglePitch, lookVector, w, this.modMain, clampDepth, d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, textRenderTypeBuffer);
        }
    }

    private void renderWaypointIngame(float cameraAngleYaw, float cameraAnglePitch, Vector3d lookVector, Waypoint w, IXaeroMinimap modMain, double depthClamp, double d3, double d4, double d5, Entity entity, BufferBuilder bufferBuilder, Tessellator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, float yaw, float pitch, IRenderTypeBuffer.Impl textRenderTypeBuffer) {
        float offZ;
        float offY;
        if (w.isDisabled() || w.getType() == 1 && !modMain.getSettings().getDeathpoints()) {
            return;
        }
        float offX = (float)((double)w.getX(dimDiv) - d3) + 0.5f;
        double depth = (double)offX * lookVector.field_72450_a + (double)(offY = (float)((double)w.getY() - d4) + 1.0f) * lookVector.field_72448_b + (double)(offZ = (float)((double)w.getZ(dimDiv) - d5) + 0.5f) * lookVector.field_72449_c;
        if (depth < 0.0) {
            return;
        }
        double correctOffX = actualEntityX - (double)w.getX() - 0.5;
        double correctOffY = actualEntityY - (double)w.getY();
        double correctOffZ = actualEntityZ - (double)w.getZ() - 0.5;
        double correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + correctOffZ * correctOffZ);
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        float originalOffY = offY;
        double waypointsDistance = modMain.getSettings().getMaxWaypointsDistance();
        if (w.getType() == 0 && !w.isGlobal() && waypointsDistance != 0.0 && distance2D > waypointsDistance || modMain.getSettings().waypointsDistanceMin != 0.0 && distance2D < modMain.getSettings().waypointsDistanceMin) {
            return;
        }
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        FontRenderer fontrenderer = renderManager.func_78716_a();
        if (fontrenderer == null) {
            return;
        }
        RenderSystem.pushMatrix();
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        String distanceText = "";
        boolean showDistance = false;
        float zoomer2 = 1.0f;
        if (depth > depthClamp) {
            double maxDistance = (double)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0;
            if (depth > maxDistance) {
                zoomer2 = (float)(maxDistance / depthClamp);
                float zoomer = (float)(maxDistance / depth);
                offX *= zoomer;
                offY *= zoomer;
                offZ *= zoomer;
            } else {
                zoomer2 = (float)(depth / depthClamp);
            }
        }
        if (correctDistance > 20.0 || modMain.getSettings().alwaysShowDistance) {
            if (modMain.getSettings().distance == 1) {
                float offset;
                float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                if (offZ < 0.0f) {
                    angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                }
                boolean bl = showDistance = Math.abs(offset = MathHelper.func_76142_g((float)(angle - cameraAngleYaw))) < (float)modMain.getSettings().lookingAtAngle;
                if (modMain.getSettings().lookingAtAngleVertical != 180) {
                    float verticalAngle = (float)Math.toDegrees(Math.atan((double)(-originalOffY) / (distance2D == 0.0 ? 1.0E-5 : distance2D)));
                    showDistance = showDistance && Math.abs(verticalAngle - cameraAnglePitch) < (float)modMain.getSettings().lookingAtAngleVertical;
                }
            } else if (modMain.getSettings().distance == 2) {
                showDistance = true;
            }
            if (showDistance) {
                distanceText = GuiMisc.simpleFormat.format(correctDistance) + "m";
                if (!modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        RenderSystem.translatef((float)offX, (float)offY, (float)offZ);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.scalef((float)-0.02666667f, (float)-0.02666667f, (float)1.0f);
        RenderSystem.scalef((float)zoomer2, (float)zoomer2, (float)1.0f);
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.scalef((float)0.8f, (float)0.8f, (float)1.0f);
        this.drawIconInWorld(w, modMain.getSettings(), bufferBuilder, tessellator, fontrenderer, name, distanceText, textSize, showDistance, textRenderTypeBuffer);
        RenderSystem.enableLighting();
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public void drawIconInWorld(Waypoint w, ModSettings settings, BufferBuilder vertexBuffer, Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance, IRenderTypeBuffer.Impl textRenderTypeBuffer) {
        int t;
        double ingameScale = settings.waypointsIngameScale;
        double distanceScale = settings.waypointsDistanceScale;
        double nameScale = settings.waypointsNameScale;
        int ingameOpacity = settings.waypointOpacityIngame;
        RenderSystem.scaled((double)ingameScale, (double)ingameScale, (double)1.0);
        int addedFrame = 0;
        if (Minecraft.func_71410_x().func_211821_e()) {
            textSize *= 1.5f;
        }
        int c = ModSettings.COLORS[w.getColor()];
        float l = (float)(c >> 16 & 0xFF) / 255.0f;
        float i1 = (float)(c >> 8 & 0xFF) / 255.0f;
        float j1 = (float)(c & 0xFF) / 255.0f;
        if (w.getType() == 0) {
            RenderSystem.scalef((float)textSize, (float)textSize, (float)textSize);
            int s = fontrenderer.func_78256_a(w.getSymbol()) / 2;
            RenderSystem.disableTexture();
            RenderSystem.color4f((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)ingameOpacity / 100.0f) / 255.0f));
            addedFrame = this.renderColorBackground(vertexBuffer, tessellator, addedFrame, s);
            RenderSystem.enableTexture();
            Misc.drawPiercingText(this.identityMatrixStack, w.getSymbol(), (float)(-s), -8.0f, -1, false, textRenderTypeBuffer);
        } else if (w.getType() == 1) {
            RenderSystem.color4f((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)ingameOpacity / 100.0f) / 255.0f));
            RenderSystem.disableTexture();
            addedFrame = this.renderColorBackground(vertexBuffer, tessellator, addedFrame, 4);
            RenderSystem.enableTexture();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            RenderSystem.color4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            this.renderTexturedIcon(vertexBuffer, tessellator, addedFrame, 0, 78);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!showDistance) {
                name = w.getLocalizedName();
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        boolean showingName = name.length() > 0;
        RenderSystem.translatef((float)0.0f, (float)(1 + addedFrame), (float)0.0f);
        if (w.getType() != 0) {
            RenderSystem.scalef((float)textSize, (float)textSize, (float)1.0f);
        }
        if (showingName) {
            RenderSystem.scaled((double)nameScale, (double)nameScale, (double)1.0);
            t = fontrenderer.func_78256_a(name) / 2;
            Misc.drawPiercingText(this.identityMatrixStack, name, (float)(-t), 0.0f, -1, false, textRenderTypeBuffer);
            RenderSystem.translatef((float)0.0f, (float)10.0f, (float)0.0f);
            RenderSystem.scaled((double)(1.0 / nameScale), (double)(1.0 / nameScale), (double)1.0);
            RenderSystem.enableBlend();
        }
        if (distance.length() > 0) {
            RenderSystem.scaled((double)distanceScale, (double)distanceScale, (double)1.0);
            t = fontrenderer.func_78256_a(distance) / 2;
            RenderSystem.disableTexture();
            RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.27450982f);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            vertexBuffer.func_225582_a_((double)(-t) - 1.0, 0.0, 0.0).func_181675_d();
            vertexBuffer.func_225582_a_((double)(-t) - 1.0, 9.0, 0.0).func_181675_d();
            vertexBuffer.func_225582_a_((double)t, 9.0, 0.0).func_181675_d();
            vertexBuffer.func_225582_a_((double)t, 0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.enableTexture();
            Misc.drawPiercingText(this.identityMatrixStack, distance, (float)(-t), 1.0f, -1, false, textRenderTypeBuffer);
        }
    }

    private int renderColorBackground(BufferBuilder vertexBuffer, Tessellator tessellator, int addedFrame, int s) {
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        if (s > 4) {
            addedFrame = s - 4;
        }
        vertexBuffer.func_225582_a_(-5.0 - (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_225582_a_(-5.0 - (double)addedFrame, (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_225582_a_(4.0 + (double)addedFrame, (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_225582_a_(4.0 + (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_181675_d();
        tessellator.func_78381_a();
        return addedFrame;
    }

    private void renderTexturedIcon(BufferBuilder vertexBuffer, Tessellator tessellator, int addedFrame, int textureX, int textureY) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_225582_a_(-5.0 - (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_225583_a_((float)textureX * f, (float)textureY * f1).func_181675_d();
        vertexBuffer.func_225582_a_(-5.0 - (double)addedFrame, (double)addedFrame, 0.0).func_225583_a_((float)textureX * f, (float)(textureY + 9 + addedFrame * 2) * f1).func_181675_d();
        vertexBuffer.func_225582_a_(4.0 + (double)addedFrame, (double)addedFrame, 0.0).func_225583_a_((float)(textureX + 9 + addedFrame * 2) * f, (float)(textureY + 9 + addedFrame * 2) * f1).func_181675_d();
        vertexBuffer.func_225582_a_(4.0 + (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_225583_a_((float)(textureX + 9 + addedFrame * 2) * f, (float)textureY * f1).func_181675_d();
        tessellator.func_78381_a();
    }
}

