/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.chunk.Chunk;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.IScreenBase;

public class Misc {
    public static double getMouseX(Minecraft mc) {
        return mc.field_71417_B.func_198024_e() * (double)mc.func_228018_at_().func_198109_k() / (double)mc.func_228018_at_().func_198105_m();
    }

    public static double getMouseY(Minecraft mc) {
        return mc.field_71417_B.func_198026_f() * (double)mc.func_228018_at_().func_198091_l() / (double)mc.func_228018_at_().func_198083_n();
    }

    public static void drawPiercingText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_228079_a_(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, true, 0, 0xF000F0);
        renderTypeBuffer.func_228461_a_();
    }

    public static void drawPiercingText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_243247_a(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, true, 0, 0xF000F0);
        renderTypeBuffer.func_228461_a_();
    }

    public static void drawCenteredPiercingText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void drawCenteredPiercingText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void minecraftOrtho(Minecraft mc) {
        MainWindow mainwindow = mc.func_228018_at_();
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)mainwindow.func_198109_k() / mainwindow.func_198100_s()), (double)((double)mainwindow.func_198091_l() / mainwindow.func_198100_s()), (double)0.0, (double)1000.0, (double)3000.0);
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFromOnFail) throws IOException {
        Path backupPath = null;
        try {
            if (Files.exists(to, new LinkOption[0])) {
                backupPath = Misc.quickFileBackupMove(to);
            }
            Files.move(from, to, new CopyOption[0]);
        }
        catch (IOException ioe) {
            while (backupFromOnFail) {
                try {
                    if (!Files.exists(from, new LinkOption[0])) break;
                    Misc.quickFileBackupMove(from);
                    break;
                }
                catch (IOException ioe2) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            throw ioe;
        }
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static boolean inputMatchesKeyBinding(InputMappings.Type type, int code, KeyBinding kb) {
        return code != -1 && kb.getKey().func_197938_b() == type && kb.getKey().func_197937_c() == code;
    }

    public static boolean screenShouldSkipWorldRender(IXaeroMinimap modMain, Screen screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && modMain.getSupportMods().worldmap() && modMain.getSupportMods().worldmapSupport.screenShouldSkipWorldRender(screen);
    }

    public static long getChunkPosAsLong(Chunk chunk) {
        return chunk.func_76632_l().func_201841_a();
    }

    public static Field getFieldReflection(Class<?> c, String obfuscatedName, String name) {
        Field field = null;
        try {
            field = c.getDeclaredField(obfuscatedName);
        }
        catch (NoSuchFieldException e) {
            try {
                field = c.getDeclaredField(name);
            }
            catch (NoSuchFieldException e1) {
                throw new RuntimeException(e1);
            }
        }
        return field;
    }

    public static <A, B> B getReflectFieldValue(A parentObject, Field field) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(parentObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        field.setAccessible(accessibleBU);
        return (B)result;
    }

    public static void download(BufferedOutputStream output, InputStream input) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        input.close();
        output.close();
    }
}

